/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.stringsreplace;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pentaho.di.core.Const;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.replacestring.ReplaceStringMeta;
import org.pentaho.metaverse.api.ChangeType;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.ComponentDerivationRecord;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepAnalyzer;
import org.pentaho.metaverse.api.model.Operation;

public class StringsReplaceStepAnalyzer
extends StepAnalyzer<ReplaceStringMeta> {
    private Map<String, Integer> renameIndex = new HashMap<String, Integer>();

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        HashSet<Class<? extends BaseStepMeta>> set = new HashSet<Class<? extends BaseStepMeta>>(1);
        set.add(ReplaceStringMeta.class);
        return set;
    }

    private ComponentDerivationRecord buildChangeRecord(ReplaceStringMeta stringsReplaceMeta, int index) throws MetaverseAnalyzerException {
        String fieldInString = stringsReplaceMeta.getFieldInStream()[index];
        String fieldOutString = stringsReplaceMeta.getFieldOutStream()[index];
        if (this.containsField(fieldOutString)) {
            Integer nameIdx = this.renameIndex.get(fieldOutString);
            this.renameIndex.put(fieldOutString, nameIdx == null ? 1 : nameIdx + 1);
            fieldOutString = fieldOutString + "_" + this.renameIndex.get(fieldOutString);
        }
        if (fieldOutString == null || fieldOutString.length() < 1) {
            fieldOutString = fieldInString;
        }
        ComponentDerivationRecord changeRecord = new ComponentDerivationRecord(fieldInString, fieldOutString, ChangeType.DATA);
        String fieldReplaceString = stringsReplaceMeta.getFieldReplaceByString()[index];
        String changeOperation = fieldInString + " -> [ replace [ ";
        changeOperation = changeOperation + stringsReplaceMeta.getReplaceString()[index] + " with ";
        changeOperation = fieldReplaceString != null && fieldReplaceString.length() > 0 ? changeOperation + fieldReplaceString : changeOperation + stringsReplaceMeta.getReplaceByString()[0];
        changeOperation = changeOperation + " ] ] -> " + fieldOutString;
        changeRecord.addOperation(new Operation("calculation", ChangeType.DATA, "transforms", changeOperation));
        return changeRecord;
    }

    public Set<ComponentDerivationRecord> getChangeRecords(ReplaceStringMeta stringsReplaceMeta) throws MetaverseAnalyzerException {
        this.renameIndex.clear();
        HashSet<ComponentDerivationRecord> changeRecords = new HashSet<ComponentDerivationRecord>();
        for (int i = 0; i < stringsReplaceMeta.getFieldInStream().length; ++i) {
            ComponentDerivationRecord changeRecord = this.buildChangeRecord(stringsReplaceMeta, i);
            changeRecords.add(changeRecord);
        }
        return changeRecords;
    }

    protected boolean isPassthrough(StepField originalFieldName) {
        String[] inFields = ((ReplaceStringMeta)this.baseStepMeta).getFieldInStream();
        String origFieldName = originalFieldName.getFieldName();
        for (int i = 0; i < inFields.length; ++i) {
            if (!inFields[i].equals(origFieldName) || !Const.isEmpty((String)((ReplaceStringMeta)this.baseStepMeta).getFieldOutStream()[i])) continue;
            return false;
        }
        return true;
    }

    protected Set<StepField> getUsedFields(ReplaceStringMeta meta) {
        HashSet<StepField> usedFields = new HashSet<StepField>();
        for (String fieldInString : meta.getFieldInStream()) {
            usedFields.addAll(this.createStepFields(fieldInString, this.getInputs()));
        }
        for (String replaceByField : meta.getFieldReplaceByString()) {
            if (Const.isEmpty((String)replaceByField)) continue;
            usedFields.addAll(this.createStepFields(replaceByField, this.getInputs()));
        }
        return usedFields;
    }

    protected void customAnalyze(ReplaceStringMeta meta, IMetaverseNode rootNode) throws MetaverseAnalyzerException {
    }

    private boolean containsField(String field) {
        return !Const.isEmpty((String)field) && !Const.isEmpty((List)this.getInputs().findNodes(field));
    }

    protected void setStepMeta(ReplaceStringMeta meta) {
        this.baseStepMeta = meta;
    }
}

