/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.tableoutput;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.tableoutput.TableOutputMeta;
import org.pentaho.dictionary.DictionaryConst;
import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.MetaverseComponentDescriptor;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.ComponentDerivationRecord;
import org.pentaho.metaverse.api.analyzer.kettle.step.ConnectionExternalResourceStepAnalyzer;
import org.pentaho.metaverse.api.model.BaseDatabaseResourceInfo;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;

public class TableOutputStepAnalyzer
extends ConnectionExternalResourceStepAnalyzer<TableOutputMeta> {
    public static final String TRUNCATE_TABLE = "truncateTable";

    protected void customAnalyze(TableOutputMeta meta, IMetaverseNode node) throws MetaverseAnalyzerException {
        super.customAnalyze((BaseStepMeta)meta, node);
        boolean truncate = meta.truncateTable();
        node.setProperty(TRUNCATE_TABLE, (Object)truncate);
    }

    protected IMetaverseNode createTableNode(IExternalResourceInfo resource) throws MetaverseAnalyzerException {
        BaseDatabaseResourceInfo resourceInfo = (BaseDatabaseResourceInfo)resource;
        Object obj = resourceInfo.getAttributes().get("table");
        String tableName = obj == null ? null : obj.toString();
        obj = resourceInfo.getAttributes().get("schema");
        String schema = obj == null ? null : obj.toString();
        MetaverseComponentDescriptor componentDescriptor = new MetaverseComponentDescriptor(tableName, "Database Table", this.getConnectionNode(), this.getDescriptor().getContext());
        IMetaverseNode tableNode = this.createNodeFromDescriptor((IComponentDescriptor)componentDescriptor);
        tableNode.setProperty("namespace", (Object)componentDescriptor.getNamespace().getNamespaceId());
        tableNode.setProperty("table", (Object)tableName);
        tableNode.setProperty("schema", (Object)schema);
        tableNode.setLogicalIdGenerator(DictionaryConst.LOGICAL_ID_GENERATOR_DB_TABLE);
        return tableNode;
    }

    protected Map<String, RowMetaInterface> getOutputRowMetaInterfaces(TableOutputMeta meta) {
        Object[] nextStepNames = this.parentTransMeta.getNextStepNames(this.parentStepMeta);
        HashMap<String, RowMetaInterface> outputRows = new HashMap<String, RowMetaInterface>();
        RowMetaInterface outputFields = this.getOutputFields((BaseStepMeta)meta);
        if (outputFields != null && ArrayUtils.isEmpty((Object[])nextStepNames)) {
            nextStepNames = new String[]{"_none_"};
        }
        for (Object stepName : nextStepNames) {
            outputRows.put((String)stepName, outputFields);
        }
        RowMeta tableFields = new RowMeta();
        Set<String> outFields = this.getOutputResourceFields(meta);
        for (String outField : outFields) {
            ValueMeta vmi = new ValueMeta(outField);
            tableFields.addValueMeta((ValueMetaInterface)vmi);
        }
        outputRows.put("_resource_", (RowMetaInterface)tableFields);
        return outputRows;
    }

    public Set<String> getOutputResourceFields(TableOutputMeta meta) {
        Object[] fieldArray = meta.getFieldDatabase();
        if (ArrayUtils.isEmpty((Object[])fieldArray) && !meta.specifyFields()) {
            fieldArray = this.getOutputFields((BaseStepMeta)meta).getFieldNames();
        }
        LinkedHashSet<Object> fields = new LinkedHashSet<Object>(Arrays.asList(fieldArray));
        return fields;
    }

    public Set<ComponentDerivationRecord> getChangeRecords(TableOutputMeta meta) throws MetaverseAnalyzerException {
        HashSet<ComponentDerivationRecord> changes = new HashSet<ComponentDerivationRecord>();
        String[] tableFields = meta.getFieldDatabase();
        String[] streamFields = meta.getFieldStream();
        if (this.getInputs() != null) {
            Set stepNames = this.getInputs().getStepNames();
            for (int i = 0; i < tableFields.length; ++i) {
                String tableField = tableFields[i];
                String streamField = streamFields[i];
                for (String stepName : stepNames) {
                    if ("_resource_".equals(stepName)) continue;
                    StepField inputField = new StepField(stepName, streamField);
                    StepField outField = new StepField("_resource_", tableField);
                    ComponentDerivationRecord change = new ComponentDerivationRecord(inputField, outField);
                    changes.add(change);
                }
            }
        }
        return changes;
    }

    public IMetaverseNode getConnectionNode() throws MetaverseAnalyzerException {
        this.connectionNode = (IMetaverseNode)this.getConnectionAnalyzer().analyze(this.getDescriptor(), (Object)((TableOutputMeta)this.baseStepMeta).getDatabaseMeta());
        return this.connectionNode;
    }

    protected Set<StepField> getUsedFields(TableOutputMeta meta) {
        return null;
    }

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        return new HashSet<Class<? extends BaseStepMeta>>(){
            {
                this.add(TableOutputMeta.class);
            }
        };
    }

    public String getResourceInputNodeType() {
        return null;
    }

    public String getResourceOutputNodeType() {
        return "Database Column";
    }

    public boolean isOutput() {
        return true;
    }

    public boolean isInput() {
        return false;
    }

    protected void setBaseStepMeta(TableOutputMeta meta) {
        this.baseStepMeta = meta;
    }

    protected void setRootNode(IMetaverseNode node) {
        this.rootNode = node;
    }

    protected void setParentTransMeta(TransMeta tm) {
        this.parentTransMeta = tm;
    }

    protected void setParentStepMeta(StepMeta sm) {
        this.parentStepMeta = sm;
    }
}

