/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.client;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.branch.LoopPipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.pentaho.di.core.Const;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.metaverse.api.ILineageClient;
import org.pentaho.metaverse.api.MetaverseException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.StepFieldOperations;
import org.pentaho.metaverse.api.model.Operations;
import org.pentaho.metaverse.graph.LineageGraphMap;
import org.pentaho.metaverse.util.MetaverseUtil;

public class LineageClient
implements ILineageClient {
    protected static final int MAX_LOOPS = 50;
    private static final StepFieldOperationsPipeFunction STEPFIELDOPS_PIPE_FUNC = new StepFieldOperationsPipeFunction();

    public Map<String, Set<StepField>> getOriginSteps(TransMeta transMeta, String targetStepName, Collection<String> fieldNames) throws MetaverseException {
        HashMap<String, Set<StepField>> originStepsMap = new HashMap<String, Set<StepField>>();
        try {
            Graph lineageGraph;
            List<Vertex> targetFields;
            GremlinPipeline pipe;
            List pathList;
            Future<Graph> lineageGraphTask = LineageGraphMap.getInstance().get(transMeta);
            if (lineageGraphTask != null && (pathList = (pipe = this.getOriginStepsPipe(targetFields = this.getTargetFields(lineageGraph = lineageGraphTask.get(), targetStepName, fieldNames))).toList()) != null) {
                for (List path : pathList) {
                    String targetField = (String)((Vertex)path.get(0)).getProperty("name");
                    HashSet<StepField> pathSet = (HashSet<StepField>)originStepsMap.get(targetField);
                    if (pathSet == null) {
                        pathSet = new HashSet<StepField>();
                        originStepsMap.put(targetField, pathSet);
                    }
                    Vertex v = (Vertex)path.get(path.size() - 1);
                    Map<String, String> stepField = STEPFIELDOPS_PIPE_FUNC.compute(v);
                    String stepName = stepField.get("stepName");
                    String fieldName = stepField.get("fieldName");
                    pathSet.add(new StepField(stepName, fieldName));
                }
            }
        }
        catch (Exception e) {
            throw new MetaverseException((Throwable)e);
        }
        return originStepsMap;
    }

    public Map<String, Set<List<StepFieldOperations>>> getOperationPaths(TransMeta transMeta, String targetStepName, Collection<String> fieldNames) throws MetaverseException {
        HashMap<String, Set<List<StepFieldOperations>>> operationPathMap = new HashMap<String, Set<List<StepFieldOperations>>>();
        try {
            List<Vertex> getTargetFields;
            GremlinPipeline pipe;
            List pathList;
            Graph lineageGraph;
            Future<Graph> lineageGraphTask = LineageGraphMap.getInstance().get(transMeta);
            if (lineageGraphTask != null && (lineageGraph = lineageGraphTask.get()) != null && (pathList = (pipe = this.getOriginStepsPipe(getTargetFields = this.getTargetFields(lineageGraph, targetStepName, fieldNames))).toList()) != null) {
                for (List path : pathList) {
                    ArrayList<StepFieldOperations> stepFieldOps = new ArrayList<StepFieldOperations>();
                    String targetField = (String)((Vertex)path.get(0)).getProperty("name");
                    HashSet<ArrayList<StepFieldOperations>> pathSet = (HashSet<ArrayList<StepFieldOperations>>)operationPathMap.get(targetField);
                    if (pathSet == null) {
                        pathSet = new HashSet<ArrayList<StepFieldOperations>>();
                        operationPathMap.put(targetField, pathSet);
                    }
                    for (Vertex v : path) {
                        Map<String, String> stepField = STEPFIELDOPS_PIPE_FUNC.compute(v);
                        String stepName = stepField.get("stepName");
                        String fieldName = stepField.get("fieldName");
                        Operations operations = MetaverseUtil.convertOperationsStringToMap((String)v.getProperty("operations"));
                        stepFieldOps.add(0, new StepFieldOperations(stepName, fieldName, operations));
                    }
                    pathSet.add(stepFieldOps);
                }
            }
        }
        catch (Exception e) {
            throw new MetaverseException((Throwable)e);
        }
        return operationPathMap;
    }

    protected List<Vertex> getTargetFields(Graph lineageGraph, String targetStepName, final Collection<String> fieldNames) {
        GremlinPipeline targetFieldNodesPipe = new GremlinPipeline((Object)lineageGraph).V("name", (Object)targetStepName).has("type", (Object)"Transformation Step").out(new String[]{"outputs"}).has("type", (Object)"Transformation Stream field").cast(Vertex.class).filter((PipeFunction)new PipeFunction<Vertex, Boolean>(){

            public Boolean compute(Vertex v) {
                Object name = v.getProperty("name");
                return name != null && fieldNames.contains(name.toString());
            }
        }).cast(Vertex.class);
        return targetFieldNodesPipe.toList();
    }

    protected GremlinPipeline getOriginStepsPipe(List<Vertex> inV) {
        GremlinPipeline pipe = new GremlinPipeline(inV).ifThenElse((PipeFunction)new HasDerivesOrJoinsLink(), (PipeFunction)new PipeFunction<Vertex, GremlinPipeline>(){

            public GremlinPipeline compute(Vertex it) {
                GremlinPipeline basePipe = new GremlinPipeline((Object)it).in(new String[]{"derives", "joins"}).loop(1, new NumLoops(50), (PipeFunction)new NotNullAndNotDerivativeLoop()).dedup();
                return basePipe.path(new PipeFunction[0]);
            }
        }, (PipeFunction)new PipeFunction<Vertex, GremlinPipeline>(){

            public GremlinPipeline compute(Vertex it) {
                return new GremlinPipeline((Object)it).path(new PipeFunction[0]);
            }
        });
        return pipe;
    }

    protected static class StepFieldOperationsPipeFunction
    implements PipeFunction<Vertex, Map<String, String>> {
        protected StepFieldOperationsPipeFunction() {
        }

        public Map<String, String> compute(Vertex it) {
            HashMap<String, String> stepFieldOpsMap = new HashMap<String, String>();
            stepFieldOpsMap.put("stepName", (String)((Vertex)it.getVertices(Direction.IN, new String[]{"outputs"}).iterator().next()).getProperty("name"));
            stepFieldOpsMap.put("fieldName", (String)it.getProperty("name"));
            String operations = (String)it.getProperty("operations");
            if (!Const.isEmpty((String)operations)) {
                stepFieldOpsMap.put("metadataOperations", operations);
            }
            return stepFieldOpsMap;
        }
    }

    protected static class StepFieldPipeFunction
    implements PipeFunction<Vertex, List<String>> {
        protected StepFieldPipeFunction() {
        }

        public List<String> compute(Vertex it) {
            return Arrays.asList(it.getProperty("name").toString(), ((Vertex)it.getVertices(Direction.IN, new String[]{"outputs"}).iterator().next()).getProperty("name").toString());
        }
    }

    protected static class HasDerivesOrJoinsLink
    implements PipeFunction<Vertex, Boolean> {
        protected HasDerivesOrJoinsLink() {
        }

        public Boolean compute(Vertex v) {
            return v != null && v.getVertices(Direction.IN, new String[]{"derives", "joins"}).iterator().hasNext();
        }
    }

    protected static class NotNullAndNotDerivativeLoop
    implements PipeFunction<LoopPipe.LoopBundle<Vertex>, Boolean> {
        protected NotNullAndNotDerivativeLoop() {
        }

        public Boolean compute(LoopPipe.LoopBundle<Vertex> argument) {
            Vertex v = (Vertex)argument.getObject();
            return v != null && !v.getVertices(Direction.IN, new String[]{"derives"}).iterator().hasNext();
        }
    }

    protected static class NumLoops<S>
    implements PipeFunction<LoopPipe.LoopBundle<S>, Boolean> {
        private int numLoops = 1;

        public NumLoops(int numLoops) {
            this.numLoops = numLoops;
        }

        public Boolean compute(LoopPipe.LoopBundle argument) {
            return argument.getLoops() < this.numLoops;
        }
    }
}

