/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.graph;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.metaverse.graph.GraphUtil;

public class GraphPath {
    private List<Object> path = new ArrayList<Object>();

    public void addVertex(Vertex vertex) {
        this.path.add(vertex);
    }

    public void addEdge(Edge edge) {
        this.path.add(edge);
    }

    public Object pop() {
        Object obj = this.path.remove(this.path.size() - 1);
        return obj;
    }

    public int getLength() {
        return this.path.size();
    }

    public GraphPath clone() {
        GraphPath clone = new GraphPath();
        for (Object o : this.path) {
            clone.add(o);
        }
        return clone;
    }

    protected void add(Object o) {
        this.path.add(o);
    }

    public void addToGraph(Graph g) {
        for (Object item : this.path) {
            Vertex v2;
            Edge edge;
            Edge e;
            if (item instanceof Vertex) {
                Vertex vertex = (Vertex)item;
                Vertex v = g.getVertex(vertex.getId());
                if (v != null) continue;
                v = GraphUtil.cloneVertexIntoGraph(vertex, g);
                continue;
            }
            if (!(item instanceof Edge) || (e = g.getEdge((edge = (Edge)item).getId())) != null) continue;
            Vertex v1 = g.getVertex((Object)edge.getVertex(Direction.OUT));
            if (v1 == null) {
                v1 = GraphUtil.cloneVertexIntoGraph(edge.getVertex(Direction.OUT), g);
            }
            if ((v2 = g.getVertex((Object)edge.getVertex(Direction.IN))) == null) {
                v2 = GraphUtil.cloneVertexIntoGraph(edge.getVertex(Direction.IN), g);
            }
            e = g.addEdge(edge.getId(), v1, v2, edge.getLabel());
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (Object obj : this.path) {
            if (!(obj instanceof Vertex)) continue;
            if (str.length() > 0) {
                str.append("->");
            }
            str.append(((Vertex)obj).getId());
        }
        return str.toString();
    }
}

