/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.graph;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.GraphFactory;
import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.util.wrappers.id.IdGraph;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.pentaho.metaverse.graph.SynchronizedGraph;
import org.pentaho.metaverse.messages.Messages;

public class SynchronizedGraphFactory {
    protected SynchronizedGraphFactory() {
        throw new UnsupportedOperationException();
    }

    public static Graph open(Configuration configuration) {
        Graph graph = GraphFactory.open((Configuration)configuration);
        return SynchronizedGraphFactory.wrapGraph(graph);
    }

    public static Graph open(Map configuration) {
        Graph graph = GraphFactory.open((Map)configuration);
        return SynchronizedGraphFactory.wrapGraph(graph);
    }

    public static Graph open(String configurationFile) {
        Graph graph = GraphFactory.open((String)configurationFile);
        return SynchronizedGraphFactory.wrapGraph(graph);
    }

    protected static Graph wrapGraph(Graph graph) {
        if (graph instanceof KeyIndexableGraph) {
            KeyIndexableGraph keyIndexableGraph = (KeyIndexableGraph)graph;
            IdGraph idGraph = new IdGraph(keyIndexableGraph);
            return new SynchronizedGraph((IdGraph<KeyIndexableGraph>)idGraph);
        }
        throw new IllegalArgumentException(Messages.getString("ERROR.BackingGraph.MustImplement.KeyIndexableGraph"));
    }
}

