/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.awt;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointUtilities;
import org.pentaho.reporting.libraries.fonts.registry.BaselineInfo;
import org.pentaho.reporting.libraries.fonts.registry.FontContext;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.registry.FontNativeContext;
import org.pentaho.reporting.libraries.fonts.tools.FontStrictGeomUtility;

public class AWTFontMetrics
implements FontMetrics {
    private static final Graphics2D[] graphics = new Graphics2D[4];
    private FontNativeContext record;
    private Font font;
    private long maxCharAdvance;
    private char[] cpBuffer;
    private FontRenderContext frc;
    private long xheight;
    private long ascent;
    private long descent;
    private long[] cachedWidths;
    private BaselineInfo[] cachedBaselines;
    private long leading;
    private long maxAscent;
    private long maxDescent;
    private boolean uniformLineMetrics;

    private static Graphics2D produce(boolean antiAlias, boolean fractMetrics) {
        BufferedImage image = new BufferedImage(1, 1, 2);
        Graphics2D g2 = image.createGraphics();
        if (antiAlias) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (fractMetrics) {
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }
        return g2;
    }

    public AWTFontMetrics(FontNativeContext record, Font font, FontContext context) {
        this.record = record;
        this.font = font;
        this.frc = new FontRenderContext(null, context.isAntiAliased(), context.isFractionalMetrics());
        Graphics2D graphics = this.createGraphics(context);
        java.awt.FontMetrics fontMetrics = graphics.getFontMetrics(font.deriveFont(font.getSize2D() * 1000.0f));
        this.leading = fontMetrics.getLeading();
        this.maxAscent = fontMetrics.getMaxAscent();
        this.maxDescent = fontMetrics.getMaxDescent();
        this.uniformLineMetrics = fontMetrics.hasUniformLineMetrics();
        Rectangle2D rect = this.font.getMaxCharBounds(this.frc);
        this.maxCharAdvance = FontStrictGeomUtility.toInternalValue(rect.getWidth());
        this.ascent = FontStrictGeomUtility.toInternalValue(-rect.getY());
        this.descent = FontStrictGeomUtility.toInternalValue(rect.getHeight() + rect.getY());
        GlyphVector gv = font.createGlyphVector(this.frc, "x");
        Rectangle2D bounds = gv.getVisualBounds();
        this.xheight = FontStrictGeomUtility.toInternalValue(bounds.getHeight());
        this.cpBuffer = new char[4];
        this.cachedBaselines = new BaselineInfo[224];
        this.cachedWidths = new long[224];
        Arrays.fill(this.cachedWidths, -1L);
    }

    protected Graphics2D createGraphics(FontContext context) {
        int idx = 0;
        if (context.isAntiAliased()) {
            ++idx;
        }
        if (context.isFractionalMetrics()) {
            idx += 2;
        }
        return graphics[idx];
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public long getAscent() {
        return this.ascent;
    }

    @Override
    public long getDescent() {
        return this.descent;
    }

    @Override
    public long getLeading() {
        return this.leading;
    }

    @Override
    public long getXHeight() {
        return this.xheight;
    }

    @Override
    public long getOverlinePosition() {
        return this.getLeading() - Math.max(1000L, this.getMaxHeight() / 20L);
    }

    @Override
    public long getUnderlinePosition() {
        return this.getLeading() + this.getMaxAscent() + Math.max(1000L, this.getMaxHeight() / 20L);
    }

    @Override
    public long getStrikeThroughPosition() {
        return this.getMaxAscent() - (long)(0.5 * (double)this.getXHeight());
    }

    @Override
    public long getMaxAscent() {
        return this.maxAscent;
    }

    @Override
    public long getMaxDescent() {
        return this.maxDescent;
    }

    @Override
    public long getMaxHeight() {
        return this.getMaxAscent() + this.getMaxDescent() + this.getLeading();
    }

    @Override
    public long getMaxCharAdvance() {
        return this.maxCharAdvance;
    }

    @Override
    public long getCharWidth(int character) {
        if (character >= 32 && character < 256) {
            int index = character - 32;
            long cachedWidth = this.cachedWidths[index];
            if (cachedWidth >= 0L) {
                return cachedWidth;
            }
            int retval = CodePointUtilities.toChars(character, this.cpBuffer, 0);
            if (retval > 0) {
                long width;
                Rectangle2D lm = this.font.getStringBounds(this.cpBuffer, 0, retval, this.frc);
                this.cachedWidths[index] = width = FontStrictGeomUtility.toInternalValue(lm.getWidth());
                return width;
            }
            this.cachedWidths[index] = 0L;
            return 0L;
        }
        int retval = CodePointUtilities.toChars(character, this.cpBuffer, 0);
        if (retval > 0) {
            Rectangle2D lm = this.font.getStringBounds(this.cpBuffer, 0, retval, this.frc);
            return FontStrictGeomUtility.toInternalValue(lm.getWidth());
        }
        return 0L;
    }

    @Override
    public long getKerning(int previous, int character) {
        int retvalC1 = CodePointUtilities.toChars(previous, this.cpBuffer, 0);
        if (retvalC1 <= 0) {
            return 0L;
        }
        int retvalC2 = CodePointUtilities.toChars(character, this.cpBuffer, retvalC1);
        if (retvalC2 > 0) {
            int limit = retvalC1 + retvalC2;
            GlyphVector gv = this.font.createGlyphVector(this.frc, new String(this.cpBuffer, 0, limit));
            long totalSize = FontStrictGeomUtility.toInternalValue(gv.getGlyphPosition(limit).getX());
            long renderedWidth = FontStrictGeomUtility.toInternalValue(gv.getOutline().getBounds2D().getWidth());
            return totalSize - renderedWidth;
        }
        return 0L;
    }

    @Override
    public BaselineInfo getBaselines(int c, BaselineInfo info) {
        BaselineInfo fromCache;
        boolean cacheable;
        boolean bl = cacheable = c >= 32 && c < 256;
        if (cacheable && (fromCache = this.cachedBaselines[c - 32]) != null) {
            if (info == null) {
                info = new BaselineInfo();
            }
            info.update(fromCache);
            return info;
        }
        this.cpBuffer[0] = (char)(c & 0xFFFF);
        LineMetrics lm = this.font.getLineMetrics(this.cpBuffer, 0, 1, this.frc);
        float[] bls = lm.getBaselineOffsets();
        int idx = lm.getBaselineIndex();
        if (info == null) {
            info = new BaselineInfo();
        }
        long maxAscent = this.getMaxAscent();
        long ascent = FontStrictGeomUtility.toInternalValue(lm.getAscent());
        long delta = maxAscent - ascent;
        info.setBaseline(1, delta + maxAscent - this.getXHeight());
        info.setBaseline(5, this.getMaxHeight());
        info.setBaseline(3, maxAscent / 2L);
        long base = delta + ascent;
        switch (idx) {
            case 1: {
                info.setBaseline(2, base);
                info.setBaseline(4, base + FontStrictGeomUtility.toInternalValue(bls[0]));
                info.setBaseline(0, base + FontStrictGeomUtility.toInternalValue(bls[2]));
                info.setDominantBaseline(2);
                break;
            }
            case 2: {
                info.setBaseline(2, base + FontStrictGeomUtility.toInternalValue(bls[1]));
                info.setBaseline(4, base + FontStrictGeomUtility.toInternalValue(bls[0]));
                info.setBaseline(0, base);
                info.setDominantBaseline(0);
                break;
            }
            default: {
                info.setBaseline(4, base);
                info.setBaseline(2, base + FontStrictGeomUtility.toInternalValue(bls[1]));
                info.setBaseline(0, base + FontStrictGeomUtility.toInternalValue(bls[2]));
                info.setDominantBaseline(4);
            }
        }
        if (cacheable) {
            BaselineInfo cached = new BaselineInfo();
            cached.update(info);
            this.cachedBaselines[c - 32] = cached;
        }
        return info;
    }

    @Override
    public boolean isUniformFontMetrics() {
        return this.uniformLineMetrics;
    }

    @Override
    public long getItalicAngle() {
        return 0L;
    }

    @Override
    public FontNativeContext getNativeContext() {
        return this.record;
    }

    static {
        AWTFontMetrics.graphics[0] = AWTFontMetrics.produce(false, false);
        AWTFontMetrics.graphics[1] = AWTFontMetrics.produce(true, false);
        AWTFontMetrics.graphics[2] = AWTFontMetrics.produce(false, true);
        AWTFontMetrics.graphics[3] = AWTFontMetrics.produce(true, true);
    }
}

