/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.scoring;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.scoring.WekaScoringData;
import org.pentaho.di.scoring.WekaScoringMeta;
import org.pentaho.di.scoring.WekaScoringModel;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import weka.core.BatchPredictor;
import weka.core.Instances;
import weka.core.SerializedObject;
import weka.core.WekaPackageManager;

public class WekaScoring
extends BaseStep
implements StepInterface {
    private WekaScoringMeta m_meta;
    private WekaScoringData m_data;
    private int m_indexOfFieldToLoadFrom = -1;
    private Map<String, WekaScoringModel> m_modelCache;
    private String m_lastRowModelFile = "";
    private int m_batchScoringSize = 100;
    private List<Object[]> m_batch;

    public WekaScoring(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private void setModelFromField(Object[] row) throws KettleException {
        WekaScoringModel modelToUse;
        RowMetaInterface inputRowMeta = this.getInputRowMeta();
        String modelFileName = inputRowMeta.getString(row, this.m_indexOfFieldToLoadFrom);
        if (Const.isEmpty((String)modelFileName)) {
            WekaScoringModel defaultM = this.m_data.getDefaultModel();
            if (defaultM == null) {
                throw new KettleException(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoring.Error.NoModelFileSpecifiedInFieldAndNoDefaultModel", (String[])new String[0]));
            }
            this.logDebug(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoring.Debug.UsingDefaultModel", (String[])new String[0]));
            this.m_data.setModel(defaultM);
            return;
        }
        String resolvedName = this.environmentSubstitute(modelFileName);
        if (resolvedName.equals(this.m_lastRowModelFile)) {
            return;
        }
        if (this.m_meta.getCacheLoadedModels() && (modelToUse = this.m_modelCache.get(resolvedName)) != null) {
            this.logDebug(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoring.Debug.FoundModelInCache", (String[])new String[0]) + " " + modelToUse.getModel().getClass());
            this.m_data.setModel(modelToUse);
            this.m_lastRowModelFile = resolvedName;
            return;
        }
        this.logDebug(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoring.Debug.LoadingModelUsingFieldValue", (String[])new String[0]) + " " + this.environmentSubstitute(modelFileName));
        modelToUse = this.setModel(modelFileName);
        if (this.m_meta.getCacheLoadedModels()) {
            this.m_modelCache.put(resolvedName, modelToUse);
        }
    }

    private WekaScoringModel setModel(String modelFileName) throws KettleException {
        WekaScoringModel model = null;
        try {
            model = WekaScoringData.loadSerializedModel(modelFileName, this.getLogChannel(), (VariableSpace)this);
            this.m_data.setModel(model);
            if (this.m_meta.getFileNameFromField()) {
                this.m_lastRowModelFile = this.environmentSubstitute(modelFileName);
            }
        }
        catch (Exception ex) {
            throw new KettleException(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoring.Error.ProblemDeserializingModel", (String[])new String[0]), (Throwable)ex);
        }
        return model;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] r;
        block49: {
            this.m_meta = (WekaScoringMeta)smi;
            this.m_data = (WekaScoringData)sdi;
            r = this.getRow();
            if (r == null) {
                if (this.m_data.getModel().isBatchPredictor() && !this.m_meta.getFileNameFromField() && this.m_batch.size() > 0) {
                    try {
                        this.outputBatchRows();
                    }
                    catch (Exception ex) {
                        throw new KettleException(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoring.Error.ProblemWhileGettingPredictionsForBatch", (String[])new String[0]), (Throwable)ex);
                    }
                }
                if (!this.m_meta.getFileNameFromField() && this.m_meta.getUpdateIncrementalModel() && !Const.isEmpty((String)this.m_meta.getSavedModelFileName())) {
                    try {
                        String modName = this.environmentSubstitute(this.m_meta.getSavedModelFileName());
                        File updatedModelFile = null;
                        if (modName.startsWith("file:")) {
                            try {
                                modName = modName.replace(" ", "%20");
                                updatedModelFile = new File(new URI(modName));
                            }
                            catch (Exception ex) {
                                throw new KettleException(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoring.Error.MalformedURIForUpdatedModelFile", (String[])new String[0]), (Throwable)ex);
                            }
                        } else {
                            updatedModelFile = new File(modName);
                        }
                        WekaScoringData.saveSerializedModel(this.m_data.getModel(), updatedModelFile);
                    }
                    catch (Exception ex) {
                        throw new KettleException(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoring.Error.ProblemSavingUpdatedModelToFile", (String[])new String[0]), (Throwable)ex);
                    }
                }
                if (this.m_meta.getFileNameFromField()) {
                    this.m_data.setModel(null);
                } else {
                    this.m_data.getModel().done();
                }
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                block48: {
                    WekaScoringModel defaultModel;
                    this.first = false;
                    WekaPackageManager.loadPackages((boolean)false);
                    this.m_data.setOutputRowMeta(this.getInputRowMeta().clone());
                    if (this.m_meta.getFileNameFromField()) {
                        RowMetaInterface inputRowMeta = this.getInputRowMeta();
                        this.m_indexOfFieldToLoadFrom = inputRowMeta.indexOfValue(this.m_meta.getFieldNameToLoadModelFrom());
                        if (this.m_indexOfFieldToLoadFrom < 0) {
                            throw new KettleException("Unable to locate model file field " + this.m_meta.getFieldNameToLoadModelFrom() + " in the incoming stream!");
                        }
                        if (!inputRowMeta.getValueMeta(this.m_indexOfFieldToLoadFrom).isString()) {
                            throw new KettleException(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoring.Error.", (String[])new String[0]));
                        }
                        if (this.m_meta.getCacheLoadedModels()) {
                            this.m_modelCache = new HashMap<String, WekaScoringModel>();
                        }
                        if (!Const.isEmpty((String)this.m_meta.getSerializedModelFileName())) {
                            defaultModel = this.setModel(this.m_meta.getSerializedModelFileName());
                            this.m_data.setDefaultModel(defaultModel);
                        } else if (this.m_meta.getModel() != null) {
                            try {
                                SerializedObject so = new SerializedObject((Object)this.m_meta.getModel());
                                WekaScoringModel defaultModel2 = (WekaScoringModel)so.getObject();
                                this.m_data.setDefaultModel(defaultModel2);
                            }
                            catch (Exception ex) {
                                throw new KettleException((Throwable)ex);
                            }
                        }
                        this.setModelFromField(r);
                        this.logBasic(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoring.Message.SourcingModelNamesFromInputField", (String[])new String[]{this.m_meta.getFieldNameToLoadModelFrom()}));
                    } else if (this.m_meta.getModel() == null || !Const.isEmpty((String)this.m_meta.getSerializedModelFileName())) {
                        if (Const.isEmpty((String)this.m_meta.getSerializedModelFileName())) {
                            throw new KettleException(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoring.Error.NoFilenameToLoadModelFrom", (String[])new String[0]));
                        }
                        this.setModel(this.m_meta.getSerializedModelFileName());
                    } else if (this.m_meta.getModel() != null) {
                        try {
                            SerializedObject so = new SerializedObject((Object)this.m_meta.getModel());
                            defaultModel = (WekaScoringModel)so.getObject();
                            this.m_data.setModel(defaultModel);
                        }
                        catch (Exception ex) {
                            throw new KettleException((Throwable)ex);
                        }
                    }
                    try {
                        Instances header = this.m_data.getModel().getHeader();
                        this.m_data.mapIncomingRowMetaData(header, this.getInputRowMeta(), this.m_meta.getUpdateIncrementalModel(), this.log);
                    }
                    catch (Exception ex) {
                        throw new KettleException(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoring.Error.IncomingDataFormatDoesNotMatchModel", (String[])new String[0]), (Throwable)ex);
                    }
                    this.m_meta.getFields(this.m_data.getOutputRowMeta(), this.getStepname(), null, null, (VariableSpace)this);
                    if (!Const.isEmpty((String)this.m_meta.getBatchScoringSize())) {
                        try {
                            String bss = this.environmentSubstitute(this.m_meta.getBatchScoringSize());
                            this.m_batchScoringSize = Integer.parseInt(bss);
                        }
                        catch (NumberFormatException ex) {
                            String modelPreferred = this.environmentSubstitute(((BatchPredictor)this.m_meta.getModel().getModel()).getBatchSize());
                            boolean sizeOk = false;
                            if (!Const.isEmpty((String)modelPreferred)) {
                                this.logBasic(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoring.Message.UnableToParseBatchScoringSize", (String[])new String[]{modelPreferred}));
                                try {
                                    this.m_batchScoringSize = Integer.parseInt(modelPreferred);
                                    sizeOk = true;
                                }
                                catch (NumberFormatException e) {
                                    // empty catch block
                                }
                            }
                            if (sizeOk) break block48;
                            this.logBasic(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoring.Message.UnableToParseBatchScoringSizeDefault", (Object[])new Object[]{100}));
                            this.m_batchScoringSize = 100;
                        }
                    }
                }
                if (this.m_data.getModel().isBatchPredictor()) {
                    this.m_batch = new ArrayList<Object[]>();
                }
            }
            try {
                if (this.m_meta.getFileNameFromField()) {
                    this.setModelFromField(r);
                }
                if (this.m_data.getModel().isBatchPredictor() && !this.m_meta.getFileNameFromField()) {
                    try {
                        this.m_batch.add(r);
                        if (this.m_batch.size() == this.m_batchScoringSize) {
                            this.outputBatchRows();
                        }
                        break block49;
                    }
                    catch (Exception ex) {
                        throw new KettleException(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoring.Error.ErrorGettingBatchPredictions", (String[])new String[0]), (Throwable)ex);
                    }
                }
                Object[] outputRow = this.m_data.generatePrediction(this.getInputRowMeta(), this.m_data.getOutputRowMeta(), r, this.m_meta);
                this.putRow(this.m_data.getOutputRowMeta(), outputRow);
            }
            catch (Exception ex) {
                throw new KettleException(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoring.Error.UnableToMakePredictionForRow", (Object[])new Object[]{this.getLinesRead()}), (Throwable)ex);
            }
        }
        if (this.log.isRowLevel()) {
            this.log.logRowlevel(this.toString(), new Object[]{"Read row #" + this.getLinesRead() + " : " + r});
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic("Linenr " + this.getLinesRead());
        }
        return true;
    }

    protected void outputBatchRows() throws Exception {
        Object[][] outputRows = this.m_data.generatePredictions(this.getInputRowMeta(), this.m_data.getOutputRowMeta(), this.m_batch, this.m_meta);
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoring.Message.PredictingBatch", (String[])new String[0]));
        }
        for (Object[] row : outputRows) {
            this.putRow(this.m_data.getOutputRowMeta(), row);
        }
        this.m_batch.clear();
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.m_meta = (WekaScoringMeta)smi;
        this.m_data = (WekaScoringData)sdi;
        return super.init(smi, sdi);
    }
}

