/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.scoring;

import org.apache.commons.vfs.FileObject;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.scoring.WekaScoringClusterer;
import org.pentaho.di.scoring.WekaScoringData;
import org.pentaho.di.scoring.WekaScoringMeta;
import org.pentaho.di.scoring.WekaScoringModel;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.vfs.ui.VfsFileChooserDialog;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.WekaPackageManager;
import weka.core.xml.XStream;

public class WekaScoringDialog
extends BaseStepDialog
implements StepDialogInterface {
    private Label m_wlStepname;
    private Text m_wStepname;
    private FormData m_fdlStepname;
    private FormData m_fdStepname;
    private FormData m_fdTabFolder;
    private FormData m_fdFileComp;
    private FormData m_fdFieldsComp;
    private FormData m_fdModelComp;
    private CTabFolder m_wTabFolder;
    private CTabItem m_wFileTab;
    private CTabItem m_wFieldsTab;
    private CTabItem m_wModelTab;
    private Label m_wlFilename;
    private Label m_wAcceptFileNameFromFieldCheckLab;
    private Button m_storeModelInStepMetaData;
    private Button m_wAcceptFileNameFromFieldCheckBox;
    private Label m_wAcceptFileNameFromFieldTextLab;
    private TextVar m_wAcceptFileNameFromFieldText;
    private Label m_wCacheModelsLab;
    private Button m_wCacheModelsCheckBox;
    private Label m_wOutputProbsLab;
    private Button m_wOutputProbs;
    private FormData m_fdlOutputProbs;
    private FormData m_fdOutputProbs;
    private Label m_wUpdateModelLab;
    private Button m_wUpdateModel;
    private FormData m_fdlUpdateModel;
    private FormData m_fdUpdateModel;
    private FormData m_fdlFilename;
    private FormData m_fdbFilename;
    private FormData m_fdFilename;
    private Button m_wbFilename;
    private TextVar m_wFilename;
    private Label m_wlSaveFilename;
    private FormData m_fdlSaveFilename;
    private FormData m_fdbSaveFilename;
    private FormData m_fdSaveFilename;
    private Button m_wbSaveFilename;
    private TextVar m_wSaveFilename;
    private TextVar m_batchScoringBatchSizeText;
    private Text m_wModelText;
    private FormData m_fdModelText;
    private Text m_wMappingText;
    private FormData m_fdMappingText;
    private final WekaScoringMeta m_currentMeta;
    private final WekaScoringMeta m_originalMeta;

    public WekaScoringDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.m_currentMeta = (WekaScoringMeta)((Object)in);
        this.m_originalMeta = (WekaScoringMeta)((Object)this.m_currentMeta.clone());
    }

    public String open() {
        WekaPackageManager.loadPackages((boolean)false);
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.m_currentMeta);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WekaScoringDialog.this.m_currentMeta.setChanged();
            }
        };
        this.changed = this.m_currentMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.m_wlStepname = new Label((Composite)this.shell, 131072);
        this.m_wlStepname.setText(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.StepName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.m_wlStepname);
        this.m_fdlStepname = new FormData();
        this.m_fdlStepname.left = new FormAttachment(0, 0);
        this.m_fdlStepname.right = new FormAttachment(middle, -margin);
        this.m_fdlStepname.top = new FormAttachment(0, margin);
        this.m_wlStepname.setLayoutData((Object)this.m_fdlStepname);
        this.m_wStepname = new Text((Composite)this.shell, 18436);
        this.m_wStepname.setText(this.stepname);
        this.props.setLook((Control)this.m_wStepname);
        this.m_wStepname.addModifyListener(lsMod);
        this.m_fdStepname = new FormData();
        this.m_fdStepname.left = new FormAttachment(middle, 0);
        this.m_fdStepname.top = new FormAttachment(0, margin);
        this.m_fdStepname.right = new FormAttachment(100, 0);
        this.m_wStepname.setLayoutData((Object)this.m_fdStepname);
        this.m_wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.m_wTabFolder, 5);
        this.m_wTabFolder.setSimple(false);
        this.m_wFileTab = new CTabItem(this.m_wTabFolder, 0);
        this.m_wFileTab.setText(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.FileTab.TabTitle", (String[])new String[0]));
        Composite wFileComp = new Composite((Composite)this.m_wTabFolder, 0);
        this.props.setLook((Control)wFileComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wFileComp.setLayout((Layout)fileLayout);
        this.m_wlFilename = new Label(wFileComp, 131072);
        this.m_wlFilename.setText(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.Filename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.m_wlFilename);
        this.m_fdlFilename = new FormData();
        this.m_fdlFilename.left = new FormAttachment(0, 0);
        this.m_fdlFilename.top = new FormAttachment(0, margin);
        this.m_fdlFilename.right = new FormAttachment(middle, -margin);
        this.m_wlFilename.setLayoutData((Object)this.m_fdlFilename);
        this.m_wbFilename = new Button(wFileComp, 0x1000008);
        this.props.setLook((Control)this.m_wbFilename);
        this.m_wbFilename.setText(BaseMessages.getString(WekaScoringMeta.PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.m_fdbFilename = new FormData();
        this.m_fdbFilename.right = new FormAttachment(100, 0);
        this.m_fdbFilename.top = new FormAttachment(0, 0);
        this.m_wbFilename.setLayoutData((Object)this.m_fdbFilename);
        this.m_wFilename = new TextVar((VariableSpace)this.transMeta, wFileComp, 18436);
        this.props.setLook((Control)this.m_wFilename);
        this.m_wFilename.addModifyListener(lsMod);
        this.m_fdFilename = new FormData();
        this.m_fdFilename.left = new FormAttachment(middle, 0);
        this.m_fdFilename.top = new FormAttachment(0, margin);
        this.m_fdFilename.right = new FormAttachment((Control)this.m_wbFilename, -margin);
        this.m_wFilename.setLayoutData((Object)this.m_fdFilename);
        Label saveModelMetaLab = new Label(wFileComp, 131072);
        this.props.setLook((Control)saveModelMetaLab);
        saveModelMetaLab.setText(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.SaveModelToMeta.Label", (String[])new String[0]));
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_wFilename, margin);
        fd.right = new FormAttachment(middle, -margin);
        saveModelMetaLab.setLayoutData((Object)fd);
        this.m_storeModelInStepMetaData = new Button(wFileComp, 32);
        this.props.setLook((Control)this.m_storeModelInStepMetaData);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.m_wFilename, margin);
        fd.right = new FormAttachment(100, 0);
        this.m_storeModelInStepMetaData.setLayoutData((Object)fd);
        this.m_wUpdateModelLab = new Label(wFileComp, 131072);
        this.m_wUpdateModelLab.setText(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.UpdateModel.Label", (String[])new String[0]));
        this.props.setLook((Control)this.m_wUpdateModelLab);
        this.m_fdlUpdateModel = new FormData();
        this.m_fdlUpdateModel.left = new FormAttachment(0, 0);
        this.m_fdlUpdateModel.top = new FormAttachment((Control)this.m_storeModelInStepMetaData, margin);
        this.m_fdlUpdateModel.right = new FormAttachment(middle, -margin);
        this.m_wUpdateModelLab.setLayoutData((Object)this.m_fdlUpdateModel);
        this.m_wUpdateModel = new Button(wFileComp, 32);
        this.props.setLook((Control)this.m_wUpdateModel);
        this.m_fdUpdateModel = new FormData();
        this.m_fdUpdateModel.left = new FormAttachment(middle, 0);
        this.m_fdUpdateModel.top = new FormAttachment((Control)this.m_storeModelInStepMetaData, margin);
        this.m_fdUpdateModel.right = new FormAttachment(100, 0);
        this.m_wUpdateModel.setLayoutData((Object)this.m_fdUpdateModel);
        this.m_wUpdateModel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WekaScoringDialog.this.m_currentMeta.setChanged();
                WekaScoringDialog.this.m_wbSaveFilename.setEnabled(WekaScoringDialog.this.m_wUpdateModel.getSelection());
                WekaScoringDialog.this.m_wSaveFilename.setEnabled(WekaScoringDialog.this.m_wUpdateModel.getSelection());
            }
        });
        this.m_wlSaveFilename = new Label(wFileComp, 131072);
        this.m_wlSaveFilename.setText(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.SaveFilename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.m_wlSaveFilename);
        this.m_fdlSaveFilename = new FormData();
        this.m_fdlSaveFilename.left = new FormAttachment(0, 0);
        this.m_fdlSaveFilename.top = new FormAttachment((Control)this.m_wUpdateModel, margin);
        this.m_fdlSaveFilename.right = new FormAttachment(middle, -margin);
        this.m_wlSaveFilename.setLayoutData((Object)this.m_fdlSaveFilename);
        this.m_wbSaveFilename = new Button(wFileComp, 0x1000008);
        this.props.setLook((Control)this.m_wbSaveFilename);
        this.m_wbSaveFilename.setText(BaseMessages.getString(WekaScoringMeta.PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.m_fdbSaveFilename = new FormData();
        this.m_fdbSaveFilename.right = new FormAttachment(100, 0);
        this.m_fdbSaveFilename.top = new FormAttachment((Control)this.m_wUpdateModel, 0);
        this.m_wbSaveFilename.setLayoutData((Object)this.m_fdbSaveFilename);
        this.m_wbSaveFilename.setEnabled(false);
        this.m_wSaveFilename = new TextVar((VariableSpace)this.transMeta, wFileComp, 18436);
        this.props.setLook((Control)this.m_wSaveFilename);
        this.m_wSaveFilename.addModifyListener(lsMod);
        this.m_fdSaveFilename = new FormData();
        this.m_fdSaveFilename.left = new FormAttachment(middle, 0);
        this.m_fdSaveFilename.top = new FormAttachment((Control)this.m_wUpdateModel, margin);
        this.m_fdSaveFilename.right = new FormAttachment((Control)this.m_wbSaveFilename, -margin);
        this.m_wSaveFilename.setLayoutData((Object)this.m_fdSaveFilename);
        this.m_wSaveFilename.setEnabled(false);
        this.m_fdFileComp = new FormData();
        this.m_fdFileComp.left = new FormAttachment(0, 0);
        this.m_fdFileComp.top = new FormAttachment(0, 0);
        this.m_fdFileComp.right = new FormAttachment(100, 0);
        this.m_fdFileComp.bottom = new FormAttachment(100, 0);
        wFileComp.setLayoutData((Object)this.m_fdFileComp);
        wFileComp.layout();
        this.m_wFileTab.setControl((Control)wFileComp);
        this.m_wAcceptFileNameFromFieldCheckLab = new Label(wFileComp, 131072);
        this.m_wAcceptFileNameFromFieldCheckLab.setText(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.AcceptFileNamesFromFieldCheck.Label", (String[])new String[0]));
        this.props.setLook((Control)this.m_wAcceptFileNameFromFieldCheckLab);
        FormData fdAcceptCheckLab = new FormData();
        fdAcceptCheckLab.left = new FormAttachment(0, 0);
        fdAcceptCheckLab.top = new FormAttachment((Control)this.m_wSaveFilename, margin);
        fdAcceptCheckLab.right = new FormAttachment(middle, -margin);
        this.m_wAcceptFileNameFromFieldCheckLab.setLayoutData((Object)fdAcceptCheckLab);
        this.m_wAcceptFileNameFromFieldCheckBox = new Button(wFileComp, 32);
        this.props.setLook((Control)this.m_wAcceptFileNameFromFieldCheckBox);
        FormData fdAcceptCheckBox = new FormData();
        fdAcceptCheckBox.left = new FormAttachment(middle, 0);
        fdAcceptCheckBox.top = new FormAttachment((Control)this.m_wSaveFilename, margin);
        fdAcceptCheckBox.right = new FormAttachment(100, 0);
        this.m_wAcceptFileNameFromFieldCheckBox.setLayoutData((Object)fdAcceptCheckBox);
        this.m_wAcceptFileNameFromFieldCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WekaScoringDialog.this.m_currentMeta.setChanged();
                if (WekaScoringDialog.this.m_wAcceptFileNameFromFieldCheckBox.getSelection()) {
                    WekaScoringDialog.this.m_wUpdateModel.setSelection(false);
                    WekaScoringDialog.this.m_wUpdateModel.setEnabled(false);
                    WekaScoringDialog.this.m_wSaveFilename.setText("");
                    WekaScoringDialog.this.m_wlFilename.setText(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.Default.Label", (String[])new String[0]));
                    if (!Const.isEmpty((String)WekaScoringDialog.this.m_wFilename.getText())) {
                        WekaScoringDialog.this.loadModel();
                    } else {
                        WekaScoringDialog.this.m_currentMeta.setDefaultModel(WekaScoringDialog.this.m_currentMeta.getModel());
                        WekaScoringDialog.this.m_currentMeta.setModel(null);
                    }
                } else {
                    if (!Const.isEmpty((String)WekaScoringDialog.this.m_wFilename.getText())) {
                        WekaScoringDialog.this.loadModel();
                    } else {
                        WekaScoringDialog.this.m_currentMeta.setModel(WekaScoringDialog.this.m_currentMeta.getDefaultModel());
                        WekaScoringDialog.this.m_currentMeta.setDefaultModel(null);
                    }
                    WekaScoringDialog.this.m_wCacheModelsCheckBox.setSelection(false);
                    WekaScoringDialog.this.m_wlFilename.setText(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.Filename.Label", (String[])new String[0]));
                }
                WekaScoringDialog.this.m_wCacheModelsCheckBox.setEnabled(WekaScoringDialog.this.m_wAcceptFileNameFromFieldCheckBox.getSelection());
                WekaScoringDialog.this.m_wAcceptFileNameFromFieldText.setEnabled(WekaScoringDialog.this.m_wAcceptFileNameFromFieldCheckBox.getSelection());
                WekaScoringDialog.this.m_wbSaveFilename.setEnabled(!WekaScoringDialog.this.m_wAcceptFileNameFromFieldCheckBox.getSelection() && WekaScoringDialog.this.m_wUpdateModel.getSelection());
                WekaScoringDialog.this.m_wSaveFilename.setEnabled(!WekaScoringDialog.this.m_wAcceptFileNameFromFieldCheckBox.getSelection() && WekaScoringDialog.this.m_wUpdateModel.getSelection());
            }
        });
        this.m_wAcceptFileNameFromFieldTextLab = new Label(wFileComp, 131072);
        this.m_wAcceptFileNameFromFieldTextLab.setText(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.AcceptFileNamesFromField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.m_wAcceptFileNameFromFieldTextLab);
        FormData fdAcceptLab = new FormData();
        fdAcceptLab.left = new FormAttachment(0, 0);
        fdAcceptLab.top = new FormAttachment((Control)this.m_wAcceptFileNameFromFieldCheckBox, margin);
        fdAcceptLab.right = new FormAttachment(middle, -margin);
        this.m_wAcceptFileNameFromFieldTextLab.setLayoutData((Object)fdAcceptLab);
        this.m_wAcceptFileNameFromFieldText = new TextVar((VariableSpace)this.transMeta, wFileComp, 18436);
        this.props.setLook((Control)this.m_wAcceptFileNameFromFieldText);
        this.m_wAcceptFileNameFromFieldText.addModifyListener(lsMod);
        FormData fdAcceptText = new FormData();
        fdAcceptText.left = new FormAttachment(middle, 0);
        fdAcceptText.top = new FormAttachment((Control)this.m_wAcceptFileNameFromFieldCheckBox, margin);
        fdAcceptText.right = new FormAttachment(100, 0);
        this.m_wAcceptFileNameFromFieldText.setLayoutData((Object)fdAcceptText);
        this.m_wAcceptFileNameFromFieldText.setEnabled(false);
        this.m_wCacheModelsLab = new Label(wFileComp, 131072);
        this.m_wCacheModelsLab.setText(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.CacheModels.Label", (String[])new String[0]));
        this.props.setLook((Control)this.m_wCacheModelsLab);
        FormData fdCacheLab = new FormData();
        fdCacheLab.left = new FormAttachment(0, 0);
        fdCacheLab.top = new FormAttachment((Control)this.m_wAcceptFileNameFromFieldText, margin);
        fdCacheLab.right = new FormAttachment(middle, -margin);
        this.m_wCacheModelsLab.setLayoutData((Object)fdCacheLab);
        this.m_wCacheModelsCheckBox = new Button(wFileComp, 32);
        this.props.setLook((Control)this.m_wCacheModelsCheckBox);
        FormData fdCacheCheckBox = new FormData();
        fdCacheCheckBox.left = new FormAttachment(middle, 0);
        fdCacheCheckBox.top = new FormAttachment((Control)this.m_wAcceptFileNameFromFieldText, margin);
        fdCacheCheckBox.right = new FormAttachment(100, 0);
        this.m_wCacheModelsCheckBox.setLayoutData((Object)fdCacheCheckBox);
        this.m_wCacheModelsCheckBox.setEnabled(false);
        this.m_wOutputProbsLab = new Label(wFileComp, 131072);
        this.m_wOutputProbsLab.setText(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.OutputProbs.Label", (String[])new String[0]));
        this.props.setLook((Control)this.m_wOutputProbsLab);
        this.m_fdlOutputProbs = new FormData();
        this.m_fdlOutputProbs.left = new FormAttachment(0, 0);
        this.m_fdlOutputProbs.top = new FormAttachment((Control)this.m_wCacheModelsCheckBox, margin);
        this.m_fdlOutputProbs.right = new FormAttachment(middle, -margin);
        this.m_wOutputProbsLab.setLayoutData((Object)this.m_fdlOutputProbs);
        this.m_wOutputProbs = new Button(wFileComp, 32);
        this.props.setLook((Control)this.m_wOutputProbs);
        this.m_fdOutputProbs = new FormData();
        this.m_fdOutputProbs.left = new FormAttachment(middle, 0);
        this.m_fdOutputProbs.top = new FormAttachment((Control)this.m_wCacheModelsCheckBox, margin);
        this.m_fdOutputProbs.right = new FormAttachment(100, 0);
        this.m_wOutputProbs.setLayoutData((Object)this.m_fdOutputProbs);
        Label batchLab = new Label(wFileComp, 131072);
        batchLab.setText("Batch scoring batch size");
        this.props.setLook((Control)batchLab);
        FormData fdd = new FormData();
        fdd.left = new FormAttachment(0, 0);
        fdd.top = new FormAttachment((Control)this.m_wOutputProbs, margin);
        fdd.right = new FormAttachment(middle, -margin);
        batchLab.setLayoutData((Object)fdd);
        this.m_batchScoringBatchSizeText = new TextVar((VariableSpace)this.transMeta, wFileComp, 18436);
        this.props.setLook((Control)this.m_batchScoringBatchSizeText);
        this.m_batchScoringBatchSizeText.addModifyListener(lsMod);
        fdd = new FormData();
        fdd.left = new FormAttachment(middle, 0);
        fdd.top = new FormAttachment((Control)this.m_wOutputProbs, margin);
        fdd.right = new FormAttachment(100, 0);
        this.m_batchScoringBatchSizeText.setLayoutData((Object)fdd);
        this.m_batchScoringBatchSizeText.setEnabled(false);
        this.m_wFieldsTab = new CTabItem(this.m_wTabFolder, 0);
        this.m_wFieldsTab.setText(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.FieldsTab.TabTitle", (String[])new String[0]));
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 3;
        fieldsLayout.marginHeight = 3;
        Composite wFieldsComp = new Composite((Composite)this.m_wTabFolder, 0);
        this.props.setLook((Control)wFieldsComp);
        wFieldsComp.setLayout((Layout)fieldsLayout);
        this.m_wMappingText = new Text(wFieldsComp, 2818);
        this.m_wMappingText.setEditable(false);
        FontData fontd = new FontData("Courier New", 12, 0);
        this.m_wMappingText.setFont(new Font((Device)this.getParent().getDisplay(), fontd));
        this.props.setLook((Control)this.m_wMappingText);
        this.m_fdMappingText = new FormData();
        this.m_fdMappingText.left = new FormAttachment(0, 0);
        this.m_fdMappingText.top = new FormAttachment(0, margin);
        this.m_fdMappingText.right = new FormAttachment(100, 0);
        this.m_fdMappingText.bottom = new FormAttachment(100, 0);
        this.m_wMappingText.setLayoutData((Object)this.m_fdMappingText);
        this.m_fdFieldsComp = new FormData();
        this.m_fdFieldsComp.left = new FormAttachment(0, 0);
        this.m_fdFieldsComp.top = new FormAttachment(0, 0);
        this.m_fdFieldsComp.right = new FormAttachment(100, 0);
        this.m_fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)this.m_fdFieldsComp);
        wFieldsComp.layout();
        this.m_wFieldsTab.setControl((Control)wFieldsComp);
        this.m_wModelTab = new CTabItem(this.m_wTabFolder, 0);
        this.m_wModelTab.setText(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.ModelTab.TabTitle", (String[])new String[0]));
        FormLayout modelLayout = new FormLayout();
        modelLayout.marginWidth = 3;
        modelLayout.marginHeight = 3;
        Composite wModelComp = new Composite((Composite)this.m_wTabFolder, 0);
        this.props.setLook((Control)wModelComp);
        wModelComp.setLayout((Layout)modelLayout);
        this.m_wModelText = new Text(wModelComp, 2818);
        this.m_wModelText.setEditable(false);
        fontd = new FontData("Courier New", 12, 0);
        this.m_wModelText.setFont(new Font((Device)this.getParent().getDisplay(), fontd));
        this.props.setLook((Control)this.m_wModelText);
        this.m_fdModelText = new FormData();
        this.m_fdModelText.left = new FormAttachment(0, 0);
        this.m_fdModelText.top = new FormAttachment(0, margin);
        this.m_fdModelText.right = new FormAttachment(100, 0);
        this.m_fdModelText.bottom = new FormAttachment(100, 0);
        this.m_wModelText.setLayoutData((Object)this.m_fdModelText);
        this.m_fdModelComp = new FormData();
        this.m_fdModelComp.left = new FormAttachment(0, 0);
        this.m_fdModelComp.top = new FormAttachment(0, 0);
        this.m_fdModelComp.right = new FormAttachment(100, 0);
        this.m_fdModelComp.bottom = new FormAttachment(100, 0);
        wModelComp.setLayoutData((Object)this.m_fdModelComp);
        wModelComp.layout();
        this.m_wModelTab.setControl((Control)wModelComp);
        this.m_fdTabFolder = new FormData();
        this.m_fdTabFolder.left = new FormAttachment(0, 0);
        this.m_fdTabFolder.top = new FormAttachment((Control)this.m_wStepname, margin);
        this.m_fdTabFolder.right = new FormAttachment(100, 0);
        this.m_fdTabFolder.bottom = new FormAttachment(100, -50);
        this.m_wTabFolder.setLayoutData((Object)this.m_fdTabFolder);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(WekaScoringMeta.PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(WekaScoringMeta.PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, (Control)this.m_wTabFolder);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                WekaScoringDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                WekaScoringDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                WekaScoringDialog.this.ok();
            }
        };
        this.m_wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                WekaScoringDialog.this.cancel();
            }
        });
        this.m_wFilename.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WekaScoringDialog.this.m_wFilename.setToolTipText(WekaScoringDialog.this.transMeta.environmentSubstitute(WekaScoringDialog.this.m_wFilename.getText()));
            }
        });
        this.m_wSaveFilename.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WekaScoringDialog.this.m_wSaveFilename.setToolTipText(WekaScoringDialog.this.transMeta.environmentSubstitute(WekaScoringDialog.this.m_wSaveFilename.getText()));
            }
        });
        this.m_wFilename.addSelectionListener(new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (!WekaScoringDialog.this.loadModel()) {
                    WekaScoringDialog.this.log.logError(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.Log.FileLoadingError", (String[])new String[0]));
                }
            }
        });
        this.m_wbFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] extensions = null;
                String[] filterNames = null;
                if (XStream.isPresent()) {
                    extensions = new String[4];
                    filterNames = new String[4];
                    extensions[0] = "*.model";
                    filterNames[0] = BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.FileType.ModelFileBinary", (String[])new String[0]);
                    extensions[1] = "*.xstreammodel";
                    filterNames[1] = BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.FileType.ModelFileXML", (String[])new String[0]);
                    extensions[2] = "*.xml";
                    filterNames[2] = BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.FileType.ModelFilePMML", (String[])new String[0]);
                    extensions[3] = "*";
                    filterNames[3] = BaseMessages.getString(WekaScoringMeta.PKG, (String)"System.FileType.AllFiles", (String[])new String[0]);
                } else {
                    extensions = new String[3];
                    filterNames = new String[3];
                    extensions[0] = "*.model";
                    filterNames[0] = BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.FileType.ModelFileBinary", (String[])new String[0]);
                    extensions[1] = "*.xml";
                    filterNames[1] = BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.FileType.ModelFilePMML", (String[])new String[0]);
                    extensions[2] = "*";
                    filterNames[2] = BaseMessages.getString(WekaScoringMeta.PKG, (String)"System.FileType.AllFiles", (String[])new String[0]);
                }
                FileObject rootFile = null;
                FileObject initialFile = null;
                FileObject defaultInitialFile = null;
                try {
                    if (WekaScoringDialog.this.m_wFilename.getText() != null) {
                        String fname = WekaScoringDialog.this.transMeta.environmentSubstitute(WekaScoringDialog.this.m_wFilename.getText());
                        if (!Const.isEmpty((String)fname)) {
                            initialFile = KettleVFS.getFileObject((String)fname);
                            rootFile = initialFile.getFileSystem().getRoot();
                        } else {
                            defaultInitialFile = KettleVFS.getFileObject((String)Spoon.getInstance().getLastFileOpened());
                        }
                    } else {
                        defaultInitialFile = KettleVFS.getFileObject((String)"file:///c:/");
                    }
                    if (rootFile == null) {
                        rootFile = defaultInitialFile.getFileSystem().getRoot();
                    }
                    VfsFileChooserDialog fileChooserDialog = Spoon.getInstance().getVfsFileChooserDialog(rootFile, initialFile);
                    fileChooserDialog.setRootFile(rootFile);
                    fileChooserDialog.setInitialFile(initialFile);
                    fileChooserDialog.defaultInitialFile = rootFile;
                    String in = !Const.isEmpty((String)WekaScoringDialog.this.m_wFilename.getText()) ? initialFile.getName().getPath() : null;
                    FileObject selectedFile = fileChooserDialog.open(WekaScoringDialog.this.shell, null, "file", true, in, extensions, filterNames, 0);
                    if (selectedFile != null) {
                        WekaScoringDialog.this.m_wFilename.setText(selectedFile.getURL().toString());
                    }
                    if (!WekaScoringDialog.this.loadModel()) {
                        WekaScoringDialog.this.log.logError(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.Log.FileLoadingError", (String[])new String[0]));
                    }
                }
                catch (Exception ex) {
                    WekaScoringDialog.this.logError("A problem occurred", ex);
                }
            }
        });
        this.m_wbSaveFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(WekaScoringDialog.this.shell, 8192);
                String[] extensions = null;
                String[] filterNames = null;
                if (XStream.isPresent()) {
                    extensions = new String[3];
                    filterNames = new String[3];
                    extensions[0] = "*.model";
                    filterNames[0] = BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.FileType.ModelFileBinary", (String[])new String[0]);
                    extensions[1] = "*.xstreammodel";
                    filterNames[1] = BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.FileType.ModelFileXML", (String[])new String[0]);
                    extensions[2] = "*";
                    filterNames[2] = BaseMessages.getString(WekaScoringMeta.PKG, (String)"System.FileType.AllFiles", (String[])new String[0]);
                } else {
                    extensions = new String[2];
                    filterNames = new String[2];
                    extensions[0] = "*.model";
                    filterNames[0] = BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.FileType.ModelFileBinary", (String[])new String[0]);
                    extensions[1] = "*";
                    filterNames[1] = BaseMessages.getString(WekaScoringMeta.PKG, (String)"System.FileType.AllFiles", (String[])new String[0]);
                }
                dialog.setFilterExtensions(extensions);
                if (WekaScoringDialog.this.m_wSaveFilename.getText() != null) {
                    dialog.setFileName(WekaScoringDialog.this.transMeta.environmentSubstitute(WekaScoringDialog.this.m_wSaveFilename.getText()));
                }
                dialog.setFilterNames(filterNames);
                if (dialog.open() != null) {
                    WekaScoringDialog.this.m_wSaveFilename.setText(dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName());
                }
            }
        });
        this.m_wTabFolder.setSelection(0);
        this.setSize();
        this.getData();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private boolean loadModel() {
        String filename = this.m_wFilename.getText();
        if (Const.isEmpty((String)filename)) {
            return false;
        }
        boolean success = false;
        try {
            if (!Const.isEmpty((String)filename) && WekaScoringData.modelFileExists(filename, (VariableSpace)this.transMeta)) {
                WekaScoringModel tempM = WekaScoringData.loadSerializedModel(filename, (LogChannelInterface)this.log, (VariableSpace)this.transMeta);
                this.m_wModelText.setText(tempM.toString());
                if (this.m_wAcceptFileNameFromFieldCheckBox.getSelection()) {
                    this.m_currentMeta.setDefaultModel(tempM);
                } else {
                    this.m_currentMeta.setModel(tempM);
                }
                this.checkAbilityToBatchScore(tempM);
                this.checkAbilityToProduceProbabilities(tempM);
                this.checkAbilityToUpdateModelIncrementally(tempM);
                this.mappingString(tempM);
                success = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log.logError(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.Log.FileLoadingError", (String[])new String[0]), (Throwable)ex);
        }
        return success;
    }

    private void mappingString(WekaScoringModel model) {
        try {
            StepMeta stepMetaTemp = this.transMeta.findStep(this.stepname);
            if (stepMetaTemp != null) {
                RowMetaInterface rowM = this.transMeta.getPrevStepFields(stepMetaTemp);
                Instances header = model.getHeader();
                int[] mappings = WekaScoringData.findMappings(header, rowM);
                StringBuffer result = new StringBuffer(header.numAttributes() * 10);
                int maxLength = 0;
                for (int i = 0; i < header.numAttributes(); ++i) {
                    if (header.attribute(i).name().length() <= maxLength) continue;
                    maxLength = header.attribute(i).name().length();
                }
                int minLength = 16;
                String headerS = BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.Mapping.ModelAttsHeader", (String[])new String[0]);
                String sep = "----------------";
                if ((maxLength += 12) < minLength) {
                    maxLength = minLength;
                }
                headerS = WekaScoringDialog.getFixedLengthString(headerS, ' ', maxLength);
                sep = WekaScoringDialog.getFixedLengthString(sep, '-', maxLength);
                sep = sep + "\t    ----------------\n";
                headerS = headerS + "\t    " + BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.Mapping.IncomingFields", (String[])new String[0]) + "\n";
                result.append(headerS);
                result.append(sep);
                for (int i = 0; i < header.numAttributes(); ++i) {
                    Attribute temp = header.attribute(i);
                    String attName = "(";
                    if (temp.isNumeric()) {
                        attName = attName + BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.Mapping.Numeric", (String[])new String[0]) + ")";
                    } else if (temp.isNominal()) {
                        attName = attName + BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.Mapping.Nominal", (String[])new String[0]) + ")";
                    } else if (temp.isString()) {
                        attName = attName + BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.Mapping.String", (String[])new String[0]) + ")";
                    }
                    attName = attName + " " + temp.name();
                    attName = WekaScoringDialog.getFixedLengthString(attName, ' ', maxLength);
                    attName = attName + "\t--> ";
                    result.append(attName);
                    String inFieldNum = "";
                    if (mappings[i] == -1) {
                        inFieldNum = inFieldNum + "- ";
                        result.append(inFieldNum + BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.Mapping.MissingNoMatch", (String[])new String[0]) + "\n");
                        continue;
                    }
                    if (mappings[i] == -2) {
                        inFieldNum = inFieldNum + (rowM.indexOfValue(temp.name()) + 1) + " ";
                        result.append(inFieldNum + BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.Mapping.MissingTypeMismatch", (String[])new String[0]) + "\n");
                        continue;
                    }
                    ValueMetaInterface tempField = rowM.getValueMeta(mappings[i]);
                    String fieldName = "" + (mappings[i] + 1) + " (";
                    if (tempField.isBoolean()) {
                        fieldName = fieldName + BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.Mapping.Boolean", (String[])new String[0]) + ")";
                    } else if (tempField.isNumeric()) {
                        fieldName = fieldName + BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.Mapping.Numeric", (String[])new String[0]) + ")";
                    } else if (tempField.isString()) {
                        fieldName = fieldName + BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.Mapping.String", (String[])new String[0]) + ")";
                    }
                    fieldName = fieldName + " " + tempField.getName();
                    result.append(fieldName + "\n");
                }
                this.m_wMappingText.setText(result.toString());
            }
        }
        catch (KettleException e) {
            this.log.logError(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.Log.UnableToFindInput", (String[])new String[0]));
            return;
        }
    }

    public void getData() {
        WekaScoringModel tempM;
        if (this.m_currentMeta.getFileNameFromField()) {
            this.m_wAcceptFileNameFromFieldCheckBox.setSelection(true);
            this.m_wCacheModelsCheckBox.setEnabled(true);
            this.m_wSaveFilename.setEnabled(false);
            this.m_wbSaveFilename.setEnabled(false);
            this.m_wSaveFilename.setText("");
            this.m_wUpdateModel.setEnabled(false);
            if (!Const.isEmpty((String)this.m_currentMeta.getFieldNameToLoadModelFrom())) {
                this.m_wAcceptFileNameFromFieldText.setText(this.m_currentMeta.getFieldNameToLoadModelFrom());
            }
            this.m_wAcceptFileNameFromFieldText.setEnabled(true);
            this.m_wCacheModelsCheckBox.setSelection(this.m_currentMeta.getCacheLoadedModels());
            this.m_wlFilename.setText(BaseMessages.getString(WekaScoringMeta.PKG, (String)"WekaScoringDialog.Default.Label", (String[])new String[0]));
        }
        if (this.m_currentMeta.getSerializedModelFileName() != null) {
            this.m_wFilename.setText(this.m_currentMeta.getSerializedModelFileName());
        }
        this.m_wOutputProbs.setSelection(this.m_currentMeta.getOutputProbabilities());
        if (!this.m_currentMeta.getFileNameFromField()) {
            this.m_wUpdateModel.setSelection(this.m_currentMeta.getUpdateIncrementalModel());
        }
        if (this.m_wUpdateModel.getSelection() && this.m_currentMeta.getSavedModelFileName() != null) {
            this.m_wSaveFilename.setText(this.m_currentMeta.getSavedModelFileName());
        }
        if (!Const.isEmpty((String)this.m_currentMeta.getBatchScoringSize())) {
            this.m_batchScoringBatchSizeText.setText(this.m_currentMeta.getBatchScoringSize());
        }
        this.m_storeModelInStepMetaData.setSelection(this.m_currentMeta.getStoreModelInStepMetaData());
        WekaScoringModel wekaScoringModel = tempM = this.m_currentMeta.getFileNameFromField() ? this.m_currentMeta.getDefaultModel() : this.m_currentMeta.getModel();
        if (tempM != null) {
            this.m_wModelText.setText(tempM.toString());
            this.mappingString(tempM);
            this.checkAbilityToBatchScore(tempM);
            this.checkAbilityToProduceProbabilities(tempM);
            this.checkAbilityToUpdateModelIncrementally(tempM);
        } else {
            this.loadModel();
        }
    }

    private void checkAbilityToBatchScore(WekaScoringModel tempM) {
        if (tempM.isBatchPredictor()) {
            this.m_wUpdateModel.setSelection(false);
            this.m_wUpdateModel.setEnabled(false);
            this.m_wbSaveFilename.setEnabled(false);
            this.m_wSaveFilename.setEnabled(false);
            this.m_wSaveFilename.setText("");
            this.m_wAcceptFileNameFromFieldCheckBox.setSelection(false);
            this.m_wAcceptFileNameFromFieldCheckBox.setEnabled(false);
            this.m_wAcceptFileNameFromFieldText.setEnabled(false);
            this.m_wAcceptFileNameFromFieldText.setText("");
            this.m_batchScoringBatchSizeText.setEnabled(true);
        } else {
            this.m_wUpdateModel.setEnabled(true);
            this.m_wbSaveFilename.setEnabled(true);
            this.m_wSaveFilename.setEnabled(true);
            this.m_wAcceptFileNameFromFieldCheckBox.setEnabled(true);
            this.m_wAcceptFileNameFromFieldText.setEnabled(true);
            this.m_batchScoringBatchSizeText.setEnabled(false);
        }
    }

    private void checkAbilityToUpdateModelIncrementally(WekaScoringModel tempM) {
        if (!tempM.isUpdateableModel()) {
            this.m_wUpdateModel.setSelection(false);
            this.m_wUpdateModel.setEnabled(false);
            this.m_wbSaveFilename.setEnabled(false);
            this.m_wSaveFilename.setEnabled(false);
            this.m_wSaveFilename.setText("");
        } else if (!this.m_wAcceptFileNameFromFieldCheckBox.getSelection()) {
            this.m_wUpdateModel.setEnabled(true);
            if (this.m_wUpdateModel.getSelection()) {
                this.m_wbSaveFilename.setEnabled(true);
                this.m_wSaveFilename.setEnabled(true);
            }
        }
    }

    private void checkAbilityToProduceProbabilities(WekaScoringModel tempM) {
        if (!tempM.isSupervisedLearningModel()) {
            if (((WekaScoringClusterer)tempM).canProduceProbabilities()) {
                this.m_wOutputProbs.setEnabled(true);
            } else {
                this.m_wOutputProbs.setSelection(false);
                this.m_wOutputProbs.setEnabled(false);
            }
        } else {
            Instances header = tempM.getHeader();
            if (header.classIndex() >= 0) {
                if (header.classAttribute().isNumeric()) {
                    this.m_wOutputProbs.setSelection(false);
                    this.m_wOutputProbs.setEnabled(false);
                } else {
                    this.m_wOutputProbs.setEnabled(true);
                }
            }
        }
    }

    private void cancel() {
        this.stepname = null;
        this.m_currentMeta.setChanged(this.changed);
        WekaScoringModel temp = this.m_originalMeta.getFileNameFromField() ? this.m_originalMeta.getDefaultModel() : this.m_originalMeta.getModel();
        this.m_currentMeta.setModel(temp);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.m_wStepname.getText())) {
            return;
        }
        this.stepname = this.m_wStepname.getText();
        this.m_currentMeta.setFileNameFromField(this.m_wAcceptFileNameFromFieldCheckBox.getSelection());
        this.m_currentMeta.setStoreModelInStepMetaData(this.m_storeModelInStepMetaData.getSelection());
        if (!Const.isEmpty((String)this.m_wFilename.getText()) && !this.m_currentMeta.getStoreModelInStepMetaData()) {
            this.m_currentMeta.setSerializedModelFileName(this.m_wFilename.getText());
        } else {
            if (!Const.isEmpty((String)this.m_wFilename.getText())) {
                this.loadModel();
            }
            this.m_currentMeta.setSerializedModelFileName(null);
        }
        if (!Const.isEmpty((String)this.m_wAcceptFileNameFromFieldText.getText())) {
            this.m_currentMeta.setFieldNameToLoadModelFrom(this.m_wAcceptFileNameFromFieldText.getText());
        }
        this.m_currentMeta.setCacheLoadedModels(this.m_wCacheModelsCheckBox.getSelection());
        this.m_currentMeta.setOutputProbabilities(this.m_wOutputProbs.getSelection());
        this.m_currentMeta.setUpdateIncrementalModel(this.m_wUpdateModel.getSelection());
        if (this.m_currentMeta.getUpdateIncrementalModel()) {
            if (!Const.isEmpty((String)this.m_wSaveFilename.getText())) {
                this.m_currentMeta.setSavedModelFileName(this.m_wSaveFilename.getText());
            } else {
                this.m_currentMeta.setSavedModelFileName("");
            }
        }
        if (!Const.isEmpty((String)this.m_batchScoringBatchSizeText.getText())) {
            this.m_currentMeta.setBatchScoringSize(this.m_batchScoringBatchSizeText.getText());
        }
        if (!this.m_originalMeta.equals((Object)this.m_currentMeta)) {
            this.m_currentMeta.setChanged();
            this.changed = this.m_currentMeta.hasChanged();
        }
        this.dispose();
    }

    private static String getFixedLengthString(String s, char pad, int len) {
        String padded = null;
        if (len <= 0) {
            return s;
        }
        if (s.length() >= len) {
            return s.substring(0, len);
        }
        char[] buf = new char[len - s.length()];
        for (int j = 0; j < len - s.length(); ++j) {
            buf[j] = pad;
        }
        padded = s + new String(buf);
        return padded;
    }
}

