/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.scoring;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.scoring.WekaScoring;
import org.pentaho.di.scoring.WekaScoringClusterer;
import org.pentaho.di.scoring.WekaScoringData;
import org.pentaho.di.scoring.WekaScoringModel;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.w3c.dom.Node;
import weka.core.Instances;
import weka.core.SerializedObject;
import weka.core.WekaPackageManager;

@Step(id="WekaScoring", image="WS.png", name="Weka Scoring", description="Appends predictions from a pre-built Weka model", categoryDescription="Data Mining")
public class WekaScoringMeta
extends BaseStepMeta
implements StepMetaInterface {
    protected static Class<?> PKG = WekaScoringMeta.class;
    public static final String XML_TAG = "weka_scoring";
    private boolean m_fileNameFromField;
    private boolean m_cacheLoadedModels;
    private String m_fieldNameToLoadModelFrom;
    private String m_modelFileName;
    private String m_savedModelFileName;
    private boolean m_outputProbabilities;
    private boolean m_updateIncrementalModel;
    private boolean m_storeModelInStepMetaData;
    private WekaScoringModel m_model;
    private WekaScoringModel m_defaultModel;
    public static final int DEFAULT_BATCH_SCORING_SIZE = 100;
    private String m_batchScoringSize = "";

    public void setStoreModelInStepMetaData(boolean b) {
        this.m_storeModelInStepMetaData = b;
    }

    public boolean getStoreModelInStepMetaData() {
        return this.m_storeModelInStepMetaData;
    }

    public void setBatchScoringSize(String size) {
        this.m_batchScoringSize = size;
    }

    public String getBatchScoringSize() {
        return this.m_batchScoringSize;
    }

    public void setFileNameFromField(boolean f) {
        this.m_fileNameFromField = f;
    }

    public boolean getFileNameFromField() {
        return this.m_fileNameFromField;
    }

    public void setCacheLoadedModels(boolean l) {
        this.m_cacheLoadedModels = l;
    }

    public boolean getCacheLoadedModels() {
        return this.m_cacheLoadedModels;
    }

    public void setFieldNameToLoadModelFrom(String fn) {
        this.m_fieldNameToLoadModelFrom = fn;
    }

    public String getFieldNameToLoadModelFrom() {
        return this.m_fieldNameToLoadModelFrom;
    }

    public void setSerializedModelFileName(String mfile) {
        this.m_modelFileName = mfile;
    }

    public String getSerializedModelFileName() {
        return this.m_modelFileName;
    }

    public void setSavedModelFileName(String savedM) {
        this.m_savedModelFileName = savedM;
    }

    public String getSavedModelFileName() {
        return this.m_savedModelFileName;
    }

    public void setModel(WekaScoringModel model) {
        this.m_model = model;
    }

    public WekaScoringModel getModel() {
        return this.m_model;
    }

    public WekaScoringModel getDefaultModel() {
        return this.m_defaultModel;
    }

    public void setDefaultModel(WekaScoringModel defaultM) {
        this.m_defaultModel = defaultM;
    }

    public void setOutputProbabilities(boolean b) {
        this.m_outputProbabilities = b;
    }

    public boolean getOutputProbabilities() {
        return this.m_outputProbabilities;
    }

    public boolean getUpdateIncrementalModel() {
        return this.m_updateIncrementalModel;
    }

    public void setUpdateIncrementalModel(boolean u) {
        this.m_updateIncrementalModel = u;
    }

    protected String getXML(boolean logging) {
        WekaScoringModel temp;
        StringBuffer retval = new StringBuffer(100);
        retval.append("<weka_scoring>");
        retval.append(XMLHandler.addTagValue((String)"output_probabilities", (boolean)this.m_outputProbabilities));
        retval.append(XMLHandler.addTagValue((String)"update_model", (boolean)this.m_updateIncrementalModel));
        retval.append(XMLHandler.addTagValue((String)"store_model_in_meta", (boolean)this.m_storeModelInStepMetaData));
        if (this.m_updateIncrementalModel && !Const.isEmpty((String)this.m_savedModelFileName)) {
            retval.append(XMLHandler.addTagValue((String)"model_export_file_name", (String)this.m_savedModelFileName));
        }
        retval.append(XMLHandler.addTagValue((String)"file_name_from_field", (boolean)this.m_fileNameFromField));
        if (this.m_fileNameFromField && !Const.isEmpty((String)this.m_fieldNameToLoadModelFrom)) {
            retval.append(XMLHandler.addTagValue((String)"field_name_to_load_from", (String)this.m_fieldNameToLoadModelFrom));
            System.out.println(BaseMessages.getString(PKG, (String)"WekaScoringMeta.Log.ModelSourcedFromField", (String[])new String[0]) + " " + this.m_fieldNameToLoadModelFrom);
        }
        if (!Const.isEmpty((String)this.m_batchScoringSize)) {
            retval.append(XMLHandler.addTagValue((String)"batch_scoring_size", (String)this.m_batchScoringSize));
        }
        retval.append(XMLHandler.addTagValue((String)"cache_loaded_models", (boolean)this.m_cacheLoadedModels));
        WekaScoringModel wekaScoringModel = temp = this.m_fileNameFromField ? this.m_defaultModel : this.m_model;
        if (temp != null && Const.isEmpty((String)this.m_modelFileName)) {
            try {
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                BufferedOutputStream bos = new BufferedOutputStream(bao);
                ObjectOutputStream oo = new ObjectOutputStream(bos);
                oo.writeObject(temp);
                oo.flush();
                byte[] model = bao.toByteArray();
                String base64model = XMLHandler.addTagValue((String)"weka_scoring_model", (byte[])model);
                String modType = this.m_fileNameFromField ? "default" : "";
                System.out.println("Serializing " + modType + " model.");
                System.out.println(BaseMessages.getString(PKG, (String)"WekaScoringMeta.Log.SizeOfModel", (String[])new String[0]) + " " + base64model.length());
                retval.append(base64model);
                oo.close();
            }
            catch (Exception ex) {
                System.out.println(BaseMessages.getString(PKG, (String)"WekaScoringMeta.Log.Base64SerializationProblem", (String[])new String[0]));
            }
        } else {
            if (!Const.isEmpty((String)this.m_modelFileName) && logging) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"WekaScoringMeta.Log.ModelSourcedFromFile", (String[])new String[0]) + " " + this.m_modelFileName);
            }
            retval.append(XMLHandler.addTagValue((String)"model_file_name", (String)this.m_modelFileName));
        }
        retval.append("</weka_scoring>");
        return retval.toString();
    }

    public String getXML() {
        return this.getXML(true);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(((Object)((Object)this)).getClass())) {
            WekaScoringMeta m = (WekaScoringMeta)((Object)obj);
            return this.getXML(false) == m.getXML(false);
        }
        return false;
    }

    public int hashCode() {
        return this.getXML(false).hashCode();
    }

    public Object clone() {
        WekaScoringModel copy;
        SerializedObject so;
        WekaScoringMeta retval = (WekaScoringMeta)((Object)super.clone());
        if (this.m_model != null) {
            try {
                so = new SerializedObject((Object)this.m_model);
                copy = (WekaScoringModel)so.getObject();
                copy.setLog(this.getLog());
                retval.setModel(copy);
            }
            catch (Exception ex) {
                this.logError(BaseMessages.getString(PKG, (String)"WekaScoringMeta.Log.DeepCopyingError", (String[])new String[0]));
            }
        }
        if (this.m_defaultModel != null) {
            try {
                so = new SerializedObject((Object)this.m_defaultModel);
                copy = (WekaScoringModel)so.getObject();
                copy.setLog(this.getLog());
                retval.setDefaultModel(copy);
            }
            catch (Exception ex) {
                this.logError(BaseMessages.getString(PKG, (String)"WekaScoringMeta.Log.DeepCopyingError", (String[])new String[0]));
            }
        }
        return retval;
    }

    public void setDefault() {
        this.m_modelFileName = null;
        this.m_outputProbabilities = false;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        WekaPackageManager.loadPackages((boolean)false);
        int nrModels = XMLHandler.countNodes((Node)stepnode, (String)XML_TAG);
        if (nrModels > 0) {
            Node wekanode = XMLHandler.getSubNodeByNr((Node)stepnode, (String)XML_TAG, (int)0);
            String temp = XMLHandler.getTagValue((Node)wekanode, (String)"file_name_from_field");
            this.m_fileNameFromField = !temp.equalsIgnoreCase("N");
            if (this.m_fileNameFromField) {
                this.m_fieldNameToLoadModelFrom = XMLHandler.getTagValue((Node)wekanode, (String)"field_name_to_load_from");
            }
            this.m_batchScoringSize = XMLHandler.getTagValue((Node)wekanode, (String)"batch_scoring_size");
            String store = XMLHandler.getTagValue((Node)wekanode, (String)"store_model_in_meta");
            if (store != null) {
                this.m_storeModelInStepMetaData = store.equalsIgnoreCase("Y");
            }
            this.m_cacheLoadedModels = !(temp = XMLHandler.getTagValue((Node)wekanode, (String)"cache_loaded_models")).equalsIgnoreCase("N");
            boolean success = false;
            try {
                String base64modelXML = XMLHandler.getTagValue((Node)wekanode, (String)"weka_scoring_model");
                this.deSerializeBase64Model(base64modelXML);
                success = true;
                String modType = this.m_fileNameFromField ? "default" : "";
                this.logBasic("Deserializing " + modType + " model.");
                this.logDetailed(BaseMessages.getString(PKG, (String)"WekaScoringMeta.Log.DeserializationSuccess", (String[])new String[0]));
            }
            catch (Exception ex) {
                success = false;
            }
            if (!success) {
                this.m_modelFileName = XMLHandler.getTagValue((Node)wekanode, (String)"model_file_name");
            }
            this.m_outputProbabilities = !(temp = XMLHandler.getTagValue((Node)wekanode, (String)"output_probabilities")).equalsIgnoreCase("N");
            temp = XMLHandler.getTagValue((Node)wekanode, (String)"update_model");
            this.m_updateIncrementalModel = !temp.equalsIgnoreCase("N");
            if (this.m_updateIncrementalModel) {
                this.m_savedModelFileName = XMLHandler.getTagValue((Node)wekanode, (String)"model_export_file_name");
            }
        }
    }

    protected void loadModelFile() throws Exception {
        if (WekaScoringData.modelFileExists(this.m_modelFileName, (VariableSpace)new Variables())) {
            if (this.m_fileNameFromField) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"WekaScoringMeta.Message.LoadingDefaultModelFromFile", (String[])new String[0]));
                this.m_defaultModel = WekaScoringData.loadSerializedModel(this.m_modelFileName, this.getLog(), (VariableSpace)new Variables());
            } else {
                this.logDetailed(BaseMessages.getString(PKG, (String)"WekaScoringMeta.Message.LoadingModelFromFile", (String[])new String[0]));
                this.m_model = WekaScoringData.loadSerializedModel(this.m_modelFileName, this.getLog(), (VariableSpace)new Variables());
            }
        }
    }

    protected void deSerializeBase64Model(String base64modelXML) throws Exception {
        byte[] model = XMLHandler.stringToBinary((String)base64modelXML);
        ByteArrayInputStream bis = new ByteArrayInputStream(model);
        ObjectInputStream ois = new ObjectInputStream(bis);
        if (this.m_fileNameFromField) {
            this.m_defaultModel = (WekaScoringModel)ois.readObject();
        } else {
            this.m_model = (WekaScoringModel)ois.readObject();
        }
        ois.close();
    }

    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        WekaPackageManager.loadPackages((boolean)false);
        this.m_fileNameFromField = rep.getStepAttributeBoolean(id_step, 0, "file_name_from_field");
        this.m_batchScoringSize = rep.getStepAttributeString(id_step, 0, "batch_scoring_size");
        if (this.m_fileNameFromField) {
            this.m_fieldNameToLoadModelFrom = rep.getStepAttributeString(id_step, 0, "field_name_to_load_from");
        }
        this.m_cacheLoadedModels = rep.getStepAttributeBoolean(id_step, 0, "cache_loaded_models");
        this.m_storeModelInStepMetaData = rep.getStepAttributeBoolean(id_step, 0, "store_model_in_meta");
        boolean success = false;
        try {
            this.m_modelFileName = rep.getStepAttributeString(id_step, 0, "model_file_name");
            success = true;
            if (this.m_modelFileName == null || Const.isEmpty((String)this.m_modelFileName)) {
                success = false;
            }
        }
        catch (KettleException ex) {
            success = false;
        }
        if (!success) {
            try {
                String base64XMLModel = rep.getStepAttributeString(id_step, 0, "weka_scoring_model");
                this.logDebug(BaseMessages.getString(PKG, (String)"WekaScoringMeta.Log.SizeOfModel", (String[])new String[0]) + " " + base64XMLModel.length());
                if (base64XMLModel != null && base64XMLModel.length() > 0) {
                    this.deSerializeBase64Model(base64XMLModel);
                    success = true;
                } else {
                    success = false;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                success = false;
            }
        }
        this.m_outputProbabilities = rep.getStepAttributeBoolean(id_step, 0, "output_probabilities");
        this.m_updateIncrementalModel = rep.getStepAttributeBoolean(id_step, 0, "update_model");
        if (this.m_updateIncrementalModel) {
            this.m_savedModelFileName = rep.getStepAttributeString(id_step, 0, "model_export_file_name");
        }
    }

    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        WekaScoringModel temp;
        rep.saveStepAttribute(id_transformation, id_step, 0, "output_probabilities", this.m_outputProbabilities);
        rep.saveStepAttribute(id_transformation, id_step, 0, "update_model", this.m_updateIncrementalModel);
        if (this.m_updateIncrementalModel && !Const.isEmpty((String)this.m_savedModelFileName)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "model_export_file_name", this.m_savedModelFileName);
        }
        rep.saveStepAttribute(id_transformation, id_step, 0, "file_name_from_field", this.m_fileNameFromField);
        if (this.m_fileNameFromField) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "field_name_to_load_from", this.m_fieldNameToLoadModelFrom);
        }
        rep.saveStepAttribute(id_transformation, id_step, 0, "cache_loaded_models", this.m_cacheLoadedModels);
        rep.saveStepAttribute(id_transformation, id_step, 0, "store_model_in_meta", this.m_storeModelInStepMetaData);
        if (!Const.isEmpty((String)this.m_batchScoringSize)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "batch_scoring_size", this.m_batchScoringSize);
        }
        WekaScoringModel wekaScoringModel = temp = this.m_fileNameFromField ? this.m_defaultModel : this.m_model;
        if (temp != null && Const.isEmpty((String)this.m_modelFileName)) {
            try {
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                BufferedOutputStream bos = new BufferedOutputStream(bao);
                ObjectOutputStream oo = new ObjectOutputStream(bos);
                oo.writeObject(temp);
                oo.flush();
                byte[] model = bao.toByteArray();
                String base64XMLModel = KettleDatabaseRepository.byteArrayToString((byte[])model);
                String modType = this.m_fileNameFromField ? "default" : "";
                this.logDebug("Serializing " + modType + " model.");
                rep.saveStepAttribute(id_transformation, id_step, 0, "weka_scoring_model", base64XMLModel);
                oo.close();
            }
            catch (Exception ex) {
                this.logError(BaseMessages.getString(PKG, (String)"WekaScoringDialog.Log.Base64SerializationProblem", (String[])new String[0]), ex);
            }
        } else {
            if (!Const.isEmpty((String)this.m_modelFileName)) {
                this.logBasic(BaseMessages.getString(PKG, (String)"WekaScoringMeta.Log.ModelSourcedFromFile", (String[])new String[0]) + " " + this.m_modelFileName);
            }
            rep.saveStepAttribute(id_transformation, id_step, 0, "model_file_name", this.m_modelFileName);
        }
    }

    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        if (this.m_model == null && !Const.isEmpty((String)this.getSerializedModelFileName())) {
            String modName = this.getSerializedModelFileName();
            try {
                if (!WekaScoringData.modelFileExists(modName, space)) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"WekaScoring.Error.NonExistentModelFile", (String[])new String[0]));
                }
                WekaScoringModel model = WekaScoringData.loadSerializedModel(this.m_modelFileName, this.getLog(), space);
                this.setModel(model);
            }
            catch (Exception ex) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"WekaScoring.Error.ProblemDeserializingModel", (String[])new String[0]), (Throwable)ex);
            }
        }
        if (this.m_model != null) {
            Instances header = this.m_model.getHeader();
            String classAttName = null;
            boolean supervised = this.m_model.isSupervisedLearningModel();
            if (supervised) {
                classAttName = header.classAttribute().name();
                if (header.classAttribute().isNumeric() || !this.m_outputProbabilities) {
                    int valueType = header.classAttribute().isNumeric() ? 1 : 2;
                    ValueMeta newVM = new ValueMeta(classAttName + "_predicted", valueType);
                    newVM.setOrigin(origin);
                    row.addValueMeta((ValueMetaInterface)newVM);
                } else {
                    for (int i = 0; i < header.classAttribute().numValues(); ++i) {
                        String classVal = header.classAttribute().value(i);
                        ValueMeta newVM = new ValueMeta(classAttName + ":" + classVal + "_predicted_prob", 1);
                        newVM.setOrigin(origin);
                        row.addValueMeta((ValueMetaInterface)newVM);
                    }
                }
            } else if (this.m_outputProbabilities) {
                try {
                    int numClusters = ((WekaScoringClusterer)this.m_model).numberOfClusters();
                    for (int i = 0; i < numClusters; ++i) {
                        ValueMeta newVM = new ValueMeta("cluster_" + i + "_predicted_prob", 1);
                        newVM.setOrigin(origin);
                        row.addValueMeta((ValueMetaInterface)newVM);
                    }
                }
                catch (Exception ex) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"WekaScoringMeta.Error.UnableToGetNumberOfClusters", (String[])new String[0]), (Throwable)ex);
                }
            } else {
                ValueMeta newVM = new ValueMeta("cluster#_predicted", 1);
                newVM.setOrigin(origin);
                row.addValueMeta((ValueMetaInterface)newVM);
            }
        }
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transmeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        File f;
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, "Not receiving any fields from previous steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.m_model == null && !Const.isEmpty((String)this.m_modelFileName) && !(f = new File(this.m_modelFileName)).exists()) {
            cr = new CheckResult(4, "Step does not have access to a usable model!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public String getDialogClassName() {
        return "org.pentaho.di.scoring.WekaScoringDialog";
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new WekaScoring(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    public StepDataInterface getStepData() {
        return new WekaScoringData();
    }
}

