/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.scoring;

import java.io.Serializable;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.scoring.WekaScoringClassifier;
import org.pentaho.di.scoring.WekaScoringClusterer;
import org.pentaho.dm.commons.LogAdapter;
import weka.classifiers.Classifier;
import weka.clusterers.Clusterer;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.pmml.PMMLModel;
import weka.gui.Logger;

public abstract class WekaScoringModel
implements Serializable {
    private Instances m_header;

    public WekaScoringModel(Object model) {
        this.setModel(model);
    }

    public void setLog(LogChannelInterface log) {
        if (this.getModel() instanceof PMMLModel) {
            LogAdapter logger = new LogAdapter(log);
            ((PMMLModel)this.getModel()).setLog((Logger)logger);
        }
    }

    public void setHeader(Instances header) {
        this.m_header = header;
    }

    public Instances getHeader() {
        return this.m_header;
    }

    public void done() {
    }

    public abstract void setModel(Object var1);

    public abstract Object getModel();

    public abstract double classifyInstance(Instance var1) throws Exception;

    public abstract double[] distributionForInstance(Instance var1) throws Exception;

    public abstract double[] classifyInstances(Instances var1) throws Exception;

    public abstract double[][] distributionsForInstances(Instances var1) throws Exception;

    public abstract boolean isSupervisedLearningModel();

    public abstract boolean isUpdateableModel();

    public abstract boolean isBatchPredictor();

    public abstract boolean update(Instance var1) throws Exception;

    public static WekaScoringModel createScorer(Object model) throws Exception {
        if (model instanceof Classifier) {
            return new WekaScoringClassifier(model);
        }
        if (model instanceof Clusterer) {
            return new WekaScoringClusterer(model);
        }
        return null;
    }
}

