/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.util.Enumeration;
import java.util.Vector;
import weka.associations.AbstractAssociator;
import weka.associations.Associator;
import weka.associations.FPGrowth;
import weka.core.Capabilities;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public abstract class SingleAssociatorEnhancer
extends AbstractAssociator
implements OptionHandler {
    private static final long serialVersionUID = -3665885256363525164L;
    protected Associator m_Associator = new FPGrowth();

    protected String defaultAssociatorString() {
        return FPGrowth.class.getName();
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tFull name of base associator.\n\t(default: " + this.defaultAssociatorString() + ")", "W", 1, "-W"));
        if (this.m_Associator instanceof OptionHandler) {
            result.addElement(new Option("", "", 0, "\nOptions specific to associator " + this.m_Associator.getClass().getName() + ":"));
            Enumeration enm = ((OptionHandler)((Object)this.m_Associator)).listOptions();
            while (enm.hasMoreElements()) {
                result.addElement((Option)enm.nextElement());
            }
        }
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('W', options);
        if (tmpStr.length() > 0) {
            this.setAssociator(AbstractAssociator.forName(tmpStr, null));
            this.setAssociator(AbstractAssociator.forName(tmpStr, Utils.partitionOptions(options)));
        } else {
            this.setAssociator(AbstractAssociator.forName(this.defaultAssociatorString(), null));
            this.setAssociator(AbstractAssociator.forName(this.defaultAssociatorString(), Utils.partitionOptions(options)));
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-W");
        result.add(this.getAssociator().getClass().getName());
        if (this.getAssociator() instanceof OptionHandler) {
            String[] options = ((OptionHandler)((Object)this.getAssociator())).getOptions();
            result.add("--");
            for (int i = 0; i < options.length; ++i) {
                result.add(options[i]);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public String associatorTipText() {
        return "The base associator to be used.";
    }

    public void setAssociator(Associator value) {
        this.m_Associator = value;
    }

    public Associator getAssociator() {
        return this.m_Associator;
    }

    protected String getAssociatorSpec() {
        Associator c = this.getAssociator();
        return c.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)c)).getOptions());
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = this.getAssociator() != null ? this.getAssociator().getCapabilities() : new Capabilities(this);
        for (Capabilities.Capability cap : Capabilities.Capability.values()) {
            result.enableDependency(cap);
        }
        result.setOwner(this);
        return result;
    }
}

