/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.estimate;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.estimate.BayesNetEstimator;
import weka.classifiers.bayes.net.estimate.DiscreteEstimatorBayes;
import weka.classifiers.bayes.net.estimate.DiscreteEstimatorFullBayes;
import weka.classifiers.bayes.net.search.local.K2;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Statistics;
import weka.core.Utils;
import weka.estimators.Estimator;

public class MultiNomialBMAEstimator
extends BayesNetEstimator {
    static final long serialVersionUID = 8330705772601586313L;
    protected boolean m_bUseK2Prior = true;

    @Override
    public String globalInfo() {
        return "Multinomial BMA Estimator.";
    }

    @Override
    public void estimateCPTs(BayesNet bayesNet) throws Exception {
        int iAttribute;
        this.initCPTs(bayesNet);
        for (int iAttribute2 = 0; iAttribute2 < bayesNet.m_Instances.numAttributes(); ++iAttribute2) {
            if (bayesNet.getParentSet(iAttribute2).getNrOfParents() <= 1) continue;
            throw new Exception("Cannot handle networks with nodes with more than 1 parent (yet).");
        }
        Instances instances = new Instances(bayesNet.m_Instances);
        while (instances.numInstances() > 0) {
            instances.delete(0);
        }
        for (int iAttribute3 = instances.numAttributes() - 1; iAttribute3 >= 0; --iAttribute3) {
            if (iAttribute3 == instances.classIndex()) continue;
            FastVector<String> values = new FastVector<String>();
            values.addElement("0");
            values.addElement("1");
            Attribute a = new Attribute(instances.attribute(iAttribute3).name(), values);
            instances.deleteAttributeAt(iAttribute3);
            instances.insertAttributeAt(a, iAttribute3);
        }
        for (int iInstance = 0; iInstance < bayesNet.m_Instances.numInstances(); ++iInstance) {
            Instance instanceOrig = bayesNet.m_Instances.instance(iInstance);
            DenseInstance instance = new DenseInstance(instances.numAttributes());
            for (iAttribute = 0; iAttribute < instances.numAttributes(); ++iAttribute) {
                if (iAttribute != instances.classIndex()) {
                    if (!(instanceOrig.value(iAttribute) > 0.0)) continue;
                    instance.setValue(iAttribute, 1.0);
                    continue;
                }
                instance.setValue(iAttribute, instanceOrig.value(iAttribute));
            }
        }
        BayesNet EmptyNet = new BayesNet();
        K2 oSearchAlgorithm = new K2();
        oSearchAlgorithm.setInitAsNaiveBayes(false);
        oSearchAlgorithm.setMaxNrOfParents(0);
        EmptyNet.setSearchAlgorithm(oSearchAlgorithm);
        EmptyNet.buildClassifier(instances);
        BayesNet NBNet = new BayesNet();
        oSearchAlgorithm.setInitAsNaiveBayes(true);
        oSearchAlgorithm.setMaxNrOfParents(1);
        NBNet.setSearchAlgorithm(oSearchAlgorithm);
        NBNet.buildClassifier(instances);
        for (iAttribute = 0; iAttribute < instances.numAttributes(); ++iAttribute) {
            int iParent;
            int iAttValue;
            if (iAttribute == instances.classIndex()) continue;
            double w1 = 0.0;
            double w2 = 0.0;
            int nAttValues = instances.attribute(iAttribute).numValues();
            if (this.m_bUseK2Prior) {
                for (iAttValue = 0; iAttValue < nAttValues; ++iAttValue) {
                    w1 += Statistics.lnGamma(1.0 + ((DiscreteEstimatorBayes)EmptyNet.m_Distributions[iAttribute][0]).getCount(iAttValue)) - Statistics.lnGamma(1.0);
                }
                w1 += Statistics.lnGamma(nAttValues) - Statistics.lnGamma(nAttValues + instances.numInstances());
                for (iParent = 0; iParent < bayesNet.getParentSet(iAttribute).getCardinalityOfParents(); ++iParent) {
                    int nTotal = 0;
                    for (int iAttValue2 = 0; iAttValue2 < nAttValues; ++iAttValue2) {
                        double nCount = ((DiscreteEstimatorBayes)NBNet.m_Distributions[iAttribute][iParent]).getCount(iAttValue2);
                        w2 += Statistics.lnGamma(1.0 + nCount) - Statistics.lnGamma(1.0);
                        nTotal = (int)((double)nTotal + nCount);
                    }
                    w2 += Statistics.lnGamma(nAttValues) - Statistics.lnGamma(nAttValues + nTotal);
                }
            } else {
                for (iAttValue = 0; iAttValue < nAttValues; ++iAttValue) {
                    w1 += Statistics.lnGamma(1.0 / (double)nAttValues + ((DiscreteEstimatorBayes)EmptyNet.m_Distributions[iAttribute][0]).getCount(iAttValue)) - Statistics.lnGamma(1.0 / (double)nAttValues);
                }
                w1 += Statistics.lnGamma(1.0) - Statistics.lnGamma(1 + instances.numInstances());
                int nParentValues = bayesNet.getParentSet(iAttribute).getCardinalityOfParents();
                for (int iParent2 = 0; iParent2 < nParentValues; ++iParent2) {
                    int nTotal = 0;
                    for (int iAttValue3 = 0; iAttValue3 < nAttValues; ++iAttValue3) {
                        double nCount = ((DiscreteEstimatorBayes)NBNet.m_Distributions[iAttribute][iParent2]).getCount(iAttValue3);
                        w2 += Statistics.lnGamma(1.0 / (double)(nAttValues * nParentValues) + nCount) - Statistics.lnGamma(1.0 / (double)(nAttValues * nParentValues));
                        nTotal = (int)((double)nTotal + nCount);
                    }
                    w2 += Statistics.lnGamma(1.0) - Statistics.lnGamma(1 + nTotal);
                }
            }
            if (w1 < w2) {
                w2 -= w1;
                w1 = 0.0;
                w1 = 1.0 / (1.0 + Math.exp(w2));
                w2 = Math.exp(w2) / (1.0 + Math.exp(w2));
            } else {
                w1 -= w2;
                w2 = 0.0;
                w2 = 1.0 / (1.0 + Math.exp(w1));
                w1 = Math.exp(w1) / (1.0 + Math.exp(w1));
            }
            for (iParent = 0; iParent < bayesNet.getParentSet(iAttribute).getCardinalityOfParents(); ++iParent) {
                bayesNet.m_Distributions[iAttribute][iParent] = new DiscreteEstimatorFullBayes(instances.attribute(iAttribute).numValues(), w1, w2, (DiscreteEstimatorBayes)EmptyNet.m_Distributions[iAttribute][0], (DiscreteEstimatorBayes)NBNet.m_Distributions[iAttribute][iParent], this.m_fAlpha);
            }
        }
        iAttribute = instances.classIndex();
        bayesNet.m_Distributions[iAttribute][0] = EmptyNet.m_Distributions[iAttribute][0];
    }

    @Override
    public void updateClassifier(BayesNet bayesNet, Instance instance) throws Exception {
        throw new Exception("updateClassifier does not apply to BMA estimator");
    }

    @Override
    public void initCPTs(BayesNet bayesNet) throws Exception {
        bayesNet.m_Distributions = new Estimator[bayesNet.m_Instances.numAttributes()][2];
    }

    public boolean isUseK2Prior() {
        return this.m_bUseK2Prior;
    }

    public void setUseK2Prior(boolean bUseK2Prior) {
        this.m_bUseK2Prior = bUseK2Prior;
    }

    @Override
    public double[] distributionForInstance(BayesNet bayesNet, Instance instance) throws Exception {
        int iClass;
        int iClass2;
        Instances instances = bayesNet.m_Instances;
        int nNumClasses = instances.numClasses();
        double[] fProbs = new double[nNumClasses];
        for (iClass2 = 0; iClass2 < nNumClasses; ++iClass2) {
            fProbs[iClass2] = 1.0;
        }
        iClass2 = 0;
        while (iClass2 < nNumClasses) {
            double logfP = 0.0;
            for (int iAttribute = 0; iAttribute < instances.numAttributes(); ++iAttribute) {
                double iCPT = 0.0;
                for (int iParent = 0; iParent < bayesNet.getParentSet(iAttribute).getNrOfParents(); ++iParent) {
                    int nParent = bayesNet.getParentSet(iAttribute).getParent(iParent);
                    iCPT = nParent == instances.classIndex() ? iCPT * (double)nNumClasses + (double)iClass2 : iCPT * (double)instances.attribute(nParent).numValues() + instance.value(nParent);
                }
                if (iAttribute == instances.classIndex()) {
                    logfP += Math.log(bayesNet.m_Distributions[iAttribute][(int)iCPT].getProbability(iClass2));
                    continue;
                }
                logfP += instance.value(iAttribute) * Math.log(bayesNet.m_Distributions[iAttribute][(int)iCPT].getProbability(instance.value(1)));
            }
            int n = iClass2++;
            fProbs[n] = fProbs[n] + logfP;
        }
        double fMax = fProbs[0];
        for (iClass = 0; iClass < nNumClasses; ++iClass) {
            if (!(fProbs[iClass] > fMax)) continue;
            fMax = fProbs[iClass];
        }
        for (iClass = 0; iClass < nNumClasses; ++iClass) {
            fProbs[iClass] = Math.exp(fProbs[iClass] - fMax);
        }
        Utils.normalize(fProbs);
        return fProbs;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tWhether to use K2 prior.\n", "k2", 0, "-k2"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement((Option)enu.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setUseK2Prior(Utils.getFlag("k2", options));
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[1 + superOptions.length];
        int current = 0;
        if (this.isUseK2Prior()) {
            options[current++] = "-k2";
        }
        for (int iOption = 0; iOption < superOptions.length; ++iOption) {
            options[current++] = superOptions[iOption];
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8048 $");
    }
}

