/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.global;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.search.global.GlobalScoreSearchAlgorithm;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class SimulatedAnnealing
extends GlobalScoreSearchAlgorithm
implements TechnicalInformationHandler {
    static final long serialVersionUID = -5482721887881010916L;
    double m_fTStart = 10.0;
    double m_fDelta = 0.999;
    int m_nRuns = 10000;
    boolean m_bUseArcReversal = false;
    int m_nSeed = 1;
    Random m_random;

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.PHDTHESIS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "R.R. Bouckaert");
        result.setValue(TechnicalInformation.Field.YEAR, "1995");
        result.setValue(TechnicalInformation.Field.TITLE, "Bayesian Belief Networks: from Construction to Inference");
        result.setValue(TechnicalInformation.Field.INSTITUTION, "University of Utrecht");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Utrecht, Netherlands");
        return result;
    }

    @Override
    public void search(BayesNet bayesNet, Instances instances) throws Exception {
        double fCurrentScore;
        this.m_random = new Random(this.m_nSeed);
        double fBestScore = fCurrentScore = this.calcScore(bayesNet);
        BayesNet bestBayesNet = new BayesNet();
        bestBayesNet.m_Instances = instances;
        bestBayesNet.initStructure();
        this.copyParentSets(bestBayesNet, bayesNet);
        double fTemp = this.m_fTStart;
        for (int iRun = 0; iRun < this.m_nRuns; ++iRun) {
            boolean bRunSucces = false;
            double fDeltaScore = 0.0;
            while (!bRunSucces) {
                double fScore;
                int iTailNode = Math.abs(this.m_random.nextInt()) % instances.numAttributes();
                int iHeadNode = Math.abs(this.m_random.nextInt()) % instances.numAttributes();
                while (iTailNode == iHeadNode) {
                    iHeadNode = Math.abs(this.m_random.nextInt()) % instances.numAttributes();
                }
                if (this.isArc(bayesNet, iHeadNode, iTailNode)) {
                    bRunSucces = true;
                    bayesNet.getParentSet(iHeadNode).deleteParent(iTailNode, instances);
                    fScore = this.calcScore(bayesNet);
                    fDeltaScore = fScore - fCurrentScore;
                    if (fTemp * Math.log((double)(Math.abs(this.m_random.nextInt()) % 10000) / 10000.0 + 1.0E-100) < fDeltaScore) {
                        fCurrentScore = fScore;
                        continue;
                    }
                    bayesNet.getParentSet(iHeadNode).addParent(iTailNode, instances);
                    continue;
                }
                if (!this.addArcMakesSense(bayesNet, instances, iHeadNode, iTailNode)) continue;
                bRunSucces = true;
                fScore = this.calcScoreWithExtraParent(iHeadNode, iTailNode);
                fDeltaScore = fScore - fCurrentScore;
                if (!(fTemp * Math.log((double)(Math.abs(this.m_random.nextInt()) % 10000) / 10000.0 + 1.0E-100) < fDeltaScore)) continue;
                bayesNet.getParentSet(iHeadNode).addParent(iTailNode, instances);
                fCurrentScore = fScore;
            }
            if (fCurrentScore > fBestScore) {
                this.copyParentSets(bestBayesNet, bayesNet);
            }
            fTemp *= this.m_fDelta;
        }
        this.copyParentSets(bayesNet, bestBayesNet);
    }

    void copyParentSets(BayesNet dest, BayesNet source) {
        int nNodes = source.getNrOfNodes();
        for (int iNode = 0; iNode < nNodes; ++iNode) {
            dest.getParentSet(iNode).copy(source.getParentSet(iNode));
        }
    }

    public double getDelta() {
        return this.m_fDelta;
    }

    public double getTStart() {
        return this.m_fTStart;
    }

    public int getRuns() {
        return this.m_nRuns;
    }

    public void setDelta(double fDelta) {
        this.m_fDelta = fDelta;
    }

    public void setTStart(double fTStart) {
        this.m_fTStart = fTStart;
    }

    public void setRuns(int nRuns) {
        this.m_nRuns = nRuns;
    }

    public int getSeed() {
        return this.m_nSeed;
    }

    public void setSeed(int nSeed) {
        this.m_nSeed = nSeed;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(3);
        newVector.addElement(new Option("\tStart temperature", "A", 1, "-A <float>"));
        newVector.addElement(new Option("\tNumber of runs", "U", 1, "-U <integer>"));
        newVector.addElement(new Option("\tDelta temperature", "D", 1, "-D <float>"));
        newVector.addElement(new Option("\tRandom number seed", "R", 1, "-R <seed>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement((Option)enu.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String sSeed;
        String sDelta;
        String sRuns;
        String sTStart = Utils.getOption('A', options);
        if (sTStart.length() != 0) {
            this.setTStart(Double.parseDouble(sTStart));
        }
        if ((sRuns = Utils.getOption('U', options)).length() != 0) {
            this.setRuns(Integer.parseInt(sRuns));
        }
        if ((sDelta = Utils.getOption('D', options)).length() != 0) {
            this.setDelta(Double.parseDouble(sDelta));
        }
        if ((sSeed = Utils.getOption('R', options)).length() != 0) {
            this.setSeed(Integer.parseInt(sSeed));
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[8 + superOptions.length];
        int current = 0;
        options[current++] = "-A";
        options[current++] = "" + this.getTStart();
        options[current++] = "-U";
        options[current++] = "" + this.getRuns();
        options[current++] = "-D";
        options[current++] = "" + this.getDelta();
        options[current++] = "-R";
        options[current++] = "" + this.getSeed();
        for (int iOption = 0; iOption < superOptions.length; ++iOption) {
            options[current++] = superOptions[iOption];
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public String globalInfo() {
        return "This Bayes Network learning algorithm uses the general purpose search method of simulated annealing to find a well scoring network structure.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public String TStartTipText() {
        return "Sets the start temperature of the simulated annealing search. The start temperature determines the probability that a step in the 'wrong' direction in the search space is accepted. The higher the temperature, the higher the probability of acceptance.";
    }

    public String runsTipText() {
        return "Sets the number of iterations to be performed by the simulated annealing search.";
    }

    public String deltaTipText() {
        return "Sets the factor with which the temperature (and thus the acceptance probability of steps in the wrong direction in the search space) is decreased in each iteration.";
    }

    public String seedTipText() {
        return "Initialization value for random number generator. Setting the seed allows replicability of experiments.";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8048 $");
    }
}

