/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.global;

import java.util.Enumeration;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.search.global.GlobalScoreSearchAlgorithm;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;

public class TAN
extends GlobalScoreSearchAlgorithm
implements TechnicalInformationHandler {
    static final long serialVersionUID = 1715277053980895298L;

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "N. Friedman and D. Geiger and M. Goldszmidt");
        result.setValue(TechnicalInformation.Field.YEAR, "1997");
        result.setValue(TechnicalInformation.Field.TITLE, "Bayesian network classifiers");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        result.setValue(TechnicalInformation.Field.VOLUME, "29");
        result.setValue(TechnicalInformation.Field.NUMBER, "2-3");
        result.setValue(TechnicalInformation.Field.PAGES, "131-163");
        return result;
    }

    @Override
    public void buildStructure(BayesNet bayesNet, Instances instances) throws Exception {
        int iLinkNode1;
        this.m_BayesNet = bayesNet;
        this.m_bInitAsNaiveBayes = true;
        this.m_nMaxNrOfParents = 2;
        super.buildStructure(bayesNet, instances);
        int nNrOfAtts = instances.numAttributes();
        int nClassNode = instances.classIndex();
        int[] link1 = new int[nNrOfAtts - 1];
        int[] link2 = new int[nNrOfAtts - 1];
        boolean[] linked = new boolean[nNrOfAtts];
        int nBestLinkNode1 = -1;
        int nBestLinkNode2 = -1;
        double fBestDeltaScore = 0.0;
        for (iLinkNode1 = 0; iLinkNode1 < nNrOfAtts; ++iLinkNode1) {
            if (iLinkNode1 == nClassNode) continue;
            for (int iLinkNode2 = 0; iLinkNode2 < nNrOfAtts; ++iLinkNode2) {
                if (iLinkNode1 == iLinkNode2 || iLinkNode2 == nClassNode) continue;
                double fScore = this.calcScoreWithExtraParent(iLinkNode1, iLinkNode2);
                if (nBestLinkNode1 != -1 && !(fScore > fBestDeltaScore)) continue;
                fBestDeltaScore = fScore;
                nBestLinkNode1 = iLinkNode2;
                nBestLinkNode2 = iLinkNode1;
            }
        }
        link1[0] = nBestLinkNode1;
        link2[0] = nBestLinkNode2;
        linked[nBestLinkNode1] = true;
        linked[nBestLinkNode2] = true;
        for (int iLink = 1; iLink < nNrOfAtts - 2; ++iLink) {
            nBestLinkNode1 = -1;
            for (iLinkNode1 = 0; iLinkNode1 < nNrOfAtts; ++iLinkNode1) {
                if (iLinkNode1 == nClassNode) continue;
                for (int iLinkNode2 = 0; iLinkNode2 < nNrOfAtts; ++iLinkNode2) {
                    if (iLinkNode1 == iLinkNode2 || iLinkNode2 == nClassNode || !linked[iLinkNode1] && !linked[iLinkNode2] || linked[iLinkNode1] && linked[iLinkNode2]) continue;
                    double fScore = this.calcScoreWithExtraParent(iLinkNode1, iLinkNode2);
                    if (nBestLinkNode1 != -1 && !(fScore > fBestDeltaScore)) continue;
                    fBestDeltaScore = fScore;
                    nBestLinkNode1 = iLinkNode2;
                    nBestLinkNode2 = iLinkNode1;
                }
            }
            link1[iLink] = nBestLinkNode1;
            link2[iLink] = nBestLinkNode2;
            linked[nBestLinkNode1] = true;
            linked[nBestLinkNode2] = true;
        }
        boolean[] hasParent = new boolean[nNrOfAtts];
        for (int iLink = 0; iLink < nNrOfAtts - 2; ++iLink) {
            if (!hasParent[link1[iLink]]) {
                bayesNet.getParentSet(link1[iLink]).addParent(link2[iLink], instances);
                hasParent[link1[iLink]] = true;
                continue;
            }
            if (hasParent[link2[iLink]]) {
                throw new Exception("Bug condition found: too many arrows");
            }
            bayesNet.getParentSet(link2[iLink]).addParent(link1[iLink], instances);
            hasParent[link2[iLink]] = true;
        }
    }

    @Override
    public Enumeration listOptions() {
        return super.listOptions();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        return super.getOptions();
    }

    @Override
    public String globalInfo() {
        return "This Bayes Network learning algorithm determines the maximum weight spanning tree and returns a Naive Bayes network augmented with a tree.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8048 $");
    }
}

