/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import java.util.Random;
import weka.classifiers.Classifier;
import weka.classifiers.evaluation.NominalPrediction;
import weka.classifiers.evaluation.NumericPrediction;
import weka.classifiers.evaluation.Prediction;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class EvaluationUtils
implements RevisionHandler {
    private int m_Seed = 1;

    public void setSeed(int seed) {
        this.m_Seed = seed;
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public FastVector getCVPredictions(Classifier classifier, Instances data, int numFolds) throws Exception {
        FastVector predictions = new FastVector();
        Instances runInstances = new Instances(data);
        Random random = new Random(this.m_Seed);
        runInstances.randomize(random);
        if (runInstances.classAttribute().isNominal() && numFolds > 1) {
            runInstances.stratify(numFolds);
        }
        boolean inst = false;
        for (int fold = 0; fold < numFolds; ++fold) {
            Instances train = runInstances.trainCV(numFolds, fold, random);
            Instances test = runInstances.testCV(numFolds, fold);
            FastVector foldPred = this.getTrainTestPredictions(classifier, train, test);
            predictions.appendElements(foldPred);
        }
        return predictions;
    }

    public FastVector getTrainTestPredictions(Classifier classifier, Instances train, Instances test) throws Exception {
        classifier.buildClassifier(train);
        return this.getTestPredictions(classifier, test);
    }

    public FastVector getTestPredictions(Classifier classifier, Instances test) throws Exception {
        FastVector<Prediction> predictions = new FastVector<Prediction>();
        for (int i = 0; i < test.numInstances(); ++i) {
            if (test.instance(i).classIsMissing()) continue;
            predictions.addElement(this.getPrediction(classifier, test.instance(i)));
        }
        return predictions;
    }

    public Prediction getPrediction(Classifier classifier, Instance test) throws Exception {
        double actual = test.classValue();
        double[] dist = classifier.distributionForInstance(test);
        if (test.classAttribute().isNominal()) {
            return new NominalPrediction(actual, dist, test.weight());
        }
        return new NumericPrediction(actual, dist[0], test.weight());
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8048 $");
    }
}

