/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import weka.classifiers.evaluation.ConfusionMatrix;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class TwoClassStats
implements RevisionHandler {
    private static final String[] CATEGORY_NAMES = new String[]{"negative", "positive"};
    private double m_TruePos;
    private double m_FalsePos;
    private double m_TrueNeg;
    private double m_FalseNeg;

    public TwoClassStats(double tp, double fp, double tn, double fn) {
        this.setTruePositive(tp);
        this.setFalsePositive(fp);
        this.setTrueNegative(tn);
        this.setFalseNegative(fn);
    }

    public void setTruePositive(double tp) {
        this.m_TruePos = tp;
    }

    public void setFalsePositive(double fp) {
        this.m_FalsePos = fp;
    }

    public void setTrueNegative(double tn) {
        this.m_TrueNeg = tn;
    }

    public void setFalseNegative(double fn) {
        this.m_FalseNeg = fn;
    }

    public double getTruePositive() {
        return this.m_TruePos;
    }

    public double getFalsePositive() {
        return this.m_FalsePos;
    }

    public double getTrueNegative() {
        return this.m_TrueNeg;
    }

    public double getFalseNegative() {
        return this.m_FalseNeg;
    }

    public double getTruePositiveRate() {
        if (0.0 == this.m_TruePos + this.m_FalseNeg) {
            return 0.0;
        }
        return this.m_TruePos / (this.m_TruePos + this.m_FalseNeg);
    }

    public double getFalsePositiveRate() {
        if (0.0 == this.m_FalsePos + this.m_TrueNeg) {
            return 0.0;
        }
        return this.m_FalsePos / (this.m_FalsePos + this.m_TrueNeg);
    }

    public double getPrecision() {
        if (0.0 == this.m_TruePos + this.m_FalsePos) {
            return 0.0;
        }
        return this.m_TruePos / (this.m_TruePos + this.m_FalsePos);
    }

    public double getRecall() {
        return this.getTruePositiveRate();
    }

    public double getFMeasure() {
        double recall;
        double precision = this.getPrecision();
        if (precision + (recall = this.getRecall()) == 0.0) {
            return 0.0;
        }
        return 2.0 * precision * recall / (precision + recall);
    }

    public double getFallout() {
        if (0.0 == this.m_TruePos + this.m_FalsePos) {
            return 0.0;
        }
        return this.m_FalsePos / (this.m_TruePos + this.m_FalsePos);
    }

    public ConfusionMatrix getConfusionMatrix() {
        ConfusionMatrix cm = new ConfusionMatrix(CATEGORY_NAMES);
        cm.setElement(0, 0, this.m_TrueNeg);
        cm.setElement(0, 1, this.m_FalsePos);
        cm.setElement(1, 0, this.m_FalseNeg);
        cm.setElement(1, 1, this.m_TruePos);
        return cm;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append(this.getTruePositive()).append(' ');
        res.append(this.getFalseNegative()).append(' ');
        res.append(this.getTrueNegative()).append(' ');
        res.append(this.getFalsePositive()).append(' ');
        res.append(this.getFalsePositiveRate()).append(' ');
        res.append(this.getTruePositiveRate()).append(' ');
        res.append(this.getPrecision()).append(' ');
        res.append(this.getRecall()).append(' ');
        res.append(this.getFMeasure()).append(' ');
        res.append(this.getFallout()).append(' ');
        return res.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8048 $");
    }
}

