/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.File;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import weka.core.ClassCache;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class ClassDiscovery
implements RevisionHandler {
    public static final boolean VERBOSE = false;
    protected static Hashtable<String, Vector<String>> m_Cache;
    protected static ClassCache m_ClassCache;

    public static boolean isSubclass(String superclass, String otherclass) {
        try {
            return ClassDiscovery.isSubclass(Class.forName(superclass), Class.forName(otherclass));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isSubclass(Class superclass, Class otherclass) {
        boolean result = false;
        Class currentclass = otherclass;
        do {
            result = currentclass.equals(superclass);
            if (currentclass.equals(Object.class)) break;
            if (result) continue;
            currentclass = currentclass.getSuperclass();
        } while (!result);
        return result;
    }

    public static boolean hasInterface(String intf, String cls) {
        try {
            return ClassDiscovery.hasInterface(Class.forName(intf), Class.forName(cls));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasInterface(Class intf, Class cls) {
        boolean result = false;
        Class currentclass = cls;
        block0: do {
            Class<?>[] intfs = currentclass.getInterfaces();
            for (int i = 0; i < intfs.length; ++i) {
                if (!intfs[i].equals(intf)) continue;
                result = true;
                continue block0;
            }
        } while ((result || (currentclass = currentclass.getSuperclass()) != null && !currentclass.equals(Object.class)) && !result);
        return result;
    }

    protected static URL getURL(String classpathPart, String pkgname) {
        String urlStr;
        URL result;
        block8: {
            result = null;
            urlStr = null;
            try {
                File classpathFile = new File(classpathPart);
                if (classpathFile.isDirectory()) {
                    File file = new File(classpathPart + pkgname);
                    if (file.exists()) {
                        urlStr = "file:" + classpathPart + pkgname;
                    }
                    break block8;
                }
                JarFile jarfile = new JarFile(classpathPart);
                Enumeration<JarEntry> enm = jarfile.entries();
                String pkgnameTmp = pkgname.substring(1);
                while (enm.hasMoreElements()) {
                    if (!((Object)enm.nextElement()).toString().startsWith(pkgnameTmp)) continue;
                    urlStr = "jar:file:" + classpathPart + "!" + pkgname;
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (urlStr != null) {
            try {
                result = new URL(urlStr);
            }
            catch (Exception e) {
                System.err.println("Trying to create URL from '" + urlStr + "' generates this exception:\n" + e);
                result = null;
            }
        }
        return result;
    }

    public static Vector<String> find(String classname, String[] pkgnames) {
        Vector<String> result = new Vector<String>();
        try {
            Class<?> cls = Class.forName(classname);
            result = ClassDiscovery.find(cls, pkgnames);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Vector<String> find(String classname, String pkgname) {
        Vector<String> result = new Vector<String>();
        try {
            Class<?> cls = Class.forName(classname);
            result = ClassDiscovery.find(cls, pkgname);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Vector<String> find(Class cls, String[] pkgnames) {
        Vector<String> result = new Vector<String>();
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < pkgnames.length; ++i) {
            names.addAll(ClassDiscovery.find(cls, pkgnames[i]));
        }
        result.addAll(names);
        Collections.sort(result, new StringCompare());
        return result;
    }

    public static ArrayList<String> find(String matchText) {
        return m_ClassCache.find(matchText);
    }

    public static Vector<String> find(Class cls, String pkgname) {
        Vector<String> result = ClassDiscovery.getCache(cls, pkgname);
        if (result == null) {
            result = new Vector();
            if (m_ClassCache.getClassnames(pkgname) != null) {
                result.addAll(m_ClassCache.getClassnames(pkgname));
            }
            int i = 0;
            while (i < result.size()) {
                try {
                    Class<?> clsNew = Class.forName(result.get(i));
                    if (Modifier.isAbstract(clsNew.getModifiers())) {
                        m_ClassCache.remove(result.get(i));
                        result.remove(i);
                        continue;
                    }
                    if (cls.isInterface() && !ClassDiscovery.hasInterface(cls, clsNew)) {
                        result.remove(i);
                        continue;
                    }
                    if (!cls.isInterface() && !ClassDiscovery.isSubclass(cls, clsNew)) {
                        result.remove(i);
                        continue;
                    }
                    ++i;
                }
                catch (Exception e) {
                    System.out.println("Accessing class '" + result.get(i) + "' resulted in error:");
                    e.printStackTrace();
                }
            }
            Collections.sort(result, new StringCompare());
            ClassDiscovery.addCache(cls, pkgname, result);
        }
        return result;
    }

    protected static HashSet<String> getSubDirectories(String prefix, File dir, HashSet<String> list) {
        File[] files;
        String newPrefix = prefix == null ? "" : (prefix.length() == 0 ? dir.getName() : prefix + "." + dir.getName());
        if (newPrefix.length() != 0) {
            list.add(newPrefix);
        }
        if ((files = dir.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) continue;
                list = ClassDiscovery.getSubDirectories(newPrefix, files[i], list);
            }
        }
        return list;
    }

    public static Vector<String> findPackages() {
        ClassDiscovery.initCache();
        Vector<String> result = new Vector<String>();
        Enumeration<String> packages = m_ClassCache.packages();
        while (packages.hasMoreElements()) {
            result.add(packages.nextElement());
        }
        Collections.sort(result, new StringCompare());
        return result;
    }

    protected static void initCache() {
        if (m_Cache == null) {
            m_Cache = new Hashtable();
        }
        if (m_ClassCache == null) {
            m_ClassCache = new ClassCache();
        }
    }

    protected static void addCache(Class cls, String pkgname, Vector<String> classnames) {
        ClassDiscovery.initCache();
        m_Cache.put(cls.getName() + "-" + pkgname, classnames);
    }

    protected static Vector<String> getCache(Class cls, String pkgname) {
        ClassDiscovery.initCache();
        return m_Cache.get(cls.getName() + "-" + pkgname);
    }

    public static void clearCache() {
        ClassDiscovery.initCache();
        m_Cache.clear();
    }

    public static void clearClassCache() {
        ClassDiscovery.clearCache();
        m_ClassCache = new ClassCache();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8048 $");
    }

    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("packages")) {
            Vector<String> list = ClassDiscovery.findPackages();
            for (int i = 0; i < list.size(); ++i) {
                System.out.println(list.get(i));
            }
        } else if (args.length == 2) {
            Vector<String> packages = new Vector<String>();
            StringTokenizer tok = new StringTokenizer(args[1], ",");
            while (tok.hasMoreTokens()) {
                packages.add(tok.nextToken());
            }
            Vector<String> list = ClassDiscovery.find(args[0], packages.toArray(new String[packages.size()]));
            System.out.println("Searching for '" + args[0] + "' in '" + args[1] + "':\n" + "  " + list.size() + " found.");
            for (int i = 0; i < list.size(); ++i) {
                System.out.println("  " + (i + 1) + ". " + list.get(i));
            }
        } else {
            System.out.println("\nUsage:");
            System.out.println(ClassDiscovery.class.getName() + " packages");
            System.out.println("\tlists all packages in the classpath");
            System.out.println(ClassDiscovery.class.getName() + " <classname> <packagename(s)>");
            System.out.println("\tlists classes derived from/implementing 'classname' that");
            System.out.println("\tcan be found in 'packagename(s)' (comma-separated list");
            System.out.println();
            System.exit(1);
        }
    }

    public static class StringCompare
    implements Comparator,
    RevisionHandler {
        private String fillUp(String s, int len) {
            while (s.length() < len) {
                s = s + " ";
            }
            return s;
        }

        private int charGroup(char c) {
            int result = 0;
            if (c >= 'a' && c <= 'z') {
                result = 2;
            } else if (c >= '0' && c <= '9') {
                result = 1;
            }
            return result;
        }

        public int compare(Object o1, Object o2) {
            int result = 0;
            String s1 = o1.toString().toLowerCase();
            String s2 = o2.toString().toLowerCase();
            s1 = this.fillUp(s1, s2.length());
            s2 = this.fillUp(s2, s1.length());
            for (int i = 0; i < s1.length(); ++i) {
                if (s1.charAt(i) != s2.charAt(i)) {
                    int v2;
                    int v1 = this.charGroup(s1.charAt(i));
                    if (v1 != (v2 = this.charGroup(s2.charAt(i)))) {
                        if (v1 < v2) {
                            result = -1;
                            break;
                        }
                        result = 1;
                        break;
                    }
                    if (s1.charAt(i) < s2.charAt(i)) {
                        result = -1;
                        break;
                    }
                    result = 1;
                    break;
                }
                result = 0;
            }
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof StringCompare;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8048 $");
        }
    }
}

