/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.File;
import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.converters.AbstractLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.DatabaseConnection;
import weka.core.converters.DatabaseConverter;
import weka.core.converters.IncrementalConverter;
import weka.experiment.InstanceQuery;

public class DatabaseLoader
extends AbstractLoader
implements BatchConverter,
IncrementalConverter,
DatabaseConverter,
OptionHandler,
EnvironmentHandler {
    static final long serialVersionUID = -7936159015338318659L;
    protected Instances m_structure;
    protected Instances m_datasetPseudoInc;
    protected Instances m_oldStructure;
    protected DatabaseConnection m_DataBaseConnection;
    protected String m_query = "Select * from Results0";
    protected boolean m_pseudoIncremental;
    protected boolean m_checkForTable;
    protected int m_nominalToStringLimit;
    protected int m_rowCount;
    protected int m_counter;
    protected int m_choice;
    protected boolean m_firstTime;
    protected boolean m_inc;
    protected ArrayList<String> m_orderBy;
    protected Hashtable<String, Double>[] m_nominalIndexes;
    protected ArrayList<String>[] m_nominalStrings;
    protected String m_idColumn;
    protected String m_URL = null;
    protected String m_User = "";
    protected String m_Password = "";
    protected String m_Keys = "";
    protected File m_CustomPropsFile = null;
    protected boolean m_CreateSparseData = false;
    protected transient Environment m_env;

    public DatabaseLoader() throws Exception {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Reads Instances from a Database. Can read a database in batch or incremental mode.\nIn inremental mode MySQL and HSQLDB are supported.\nFor all other DBMS set a pseudoincremental mode is used:\nIn pseudo incremental mode the instances are read into main memory all at once and then incrementally provided to the user.\nFor incremental loading the rows in the database table have to be ordered uniquely.\nThe reason for this is that every time only a single row is fetched by extending the user query by a LIMIT clause.\nIf this extension is impossible instances will be loaded pseudoincrementally. To ensure that every row is fetched exaclty once, they have to ordered.\nTherefore a (primary) key is necessary.This approach is chosen, instead of using JDBC driver facilities, because the latter one differ betweeen different drivers.\nIf you use the DatabaseSaver and save instances by generating automatically a primary key (its name is defined in DtabaseUtils), this primary key will be used for ordering but will not be part of the output. The user defined SQL query to extract the instances should not contain LIMIT and ORDER BY clauses (see -Q option).\nIn addition, for incremental loading,  you can define in the DatabaseUtils file how many distinct values a nominal attribute is allowed to have. If this number is exceeded, the column will become a string attribute.\nIn batch mode no string attributes will be created.";
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
        try {
            this.m_DataBaseConnection = this.newDatabaseConnection();
            this.setUrl(this.m_URL);
            this.setUser(this.m_User);
            this.setPassword(this.m_Password);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkEnv() {
        if (this.m_env == null) {
            this.m_env = Environment.getSystemWide();
        }
    }

    protected DatabaseConnection newDatabaseConnection() throws Exception {
        DatabaseConnection result;
        this.checkEnv();
        if (this.m_CustomPropsFile != null) {
            File pFile = new File(this.m_CustomPropsFile.getPath());
            String pPath = this.m_CustomPropsFile.getPath();
            try {
                pPath = this.m_env.substitute(pPath);
                pFile = new File(pPath);
            }
            catch (Exception ex) {
                // empty catch block
            }
            result = new DatabaseConnection(pFile);
        } else {
            result = new DatabaseConnection();
        }
        this.m_pseudoIncremental = false;
        this.m_checkForTable = true;
        String props = result.getProperties().getProperty("nominalToStringLimit");
        this.m_nominalToStringLimit = Integer.parseInt(props);
        this.m_idColumn = result.getProperties().getProperty("idColumn");
        if (result.getProperties().getProperty("checkForTable", "").equalsIgnoreCase("FALSE")) {
            this.m_checkForTable = false;
        }
        return result;
    }

    public void resetOptions() {
        this.resetStructure();
        try {
            if (this.m_DataBaseConnection != null && this.m_DataBaseConnection.isConnected()) {
                this.m_DataBaseConnection.disconnectFromDatabase();
            }
            this.m_DataBaseConnection = this.newDatabaseConnection();
        }
        catch (Exception ex) {
            this.printException(ex);
        }
        this.m_URL = this.m_DataBaseConnection.getDatabaseURL();
        if (this.m_URL == null) {
            this.m_URL = "none set!";
        }
        this.m_User = this.m_DataBaseConnection.getUsername();
        if (this.m_User == null) {
            this.m_User = "";
        }
        this.m_Password = this.m_DataBaseConnection.getPassword();
        if (this.m_Password == null) {
            this.m_Password = "";
        }
        this.m_orderBy = new ArrayList();
    }

    @Override
    public void reset() {
        this.resetStructure();
        try {
            if (this.m_DataBaseConnection != null && this.m_DataBaseConnection.isConnected()) {
                this.m_DataBaseConnection.disconnectFromDatabase();
            }
            this.m_DataBaseConnection = this.newDatabaseConnection();
        }
        catch (Exception ex) {
            this.printException(ex);
        }
        if (this.m_URL != null) {
            this.setUrl(this.m_URL);
        }
        if (this.m_User != null) {
            this.setUser(this.m_User);
        }
        if (this.m_Password != null) {
            this.setPassword(this.m_Password);
        }
        this.m_orderBy = new ArrayList();
        if (this.m_Keys != null) {
            String k = this.m_Keys;
            try {
                k = this.m_env.substitute(k);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setKeys(k);
        }
        this.m_inc = false;
    }

    public void resetStructure() {
        this.m_structure = null;
        this.m_datasetPseudoInc = null;
        this.m_oldStructure = null;
        this.m_rowCount = 0;
        this.m_counter = 0;
        this.m_choice = 0;
        this.m_firstTime = true;
        this.setRetrieval(0);
    }

    public void setQuery(String q) {
        q = q.replaceAll("[fF][rR][oO][mM]", "FROM");
        this.m_query = q = q.replaceFirst("[sS][eE][lL][eE][cC][tT]", "SELECT");
    }

    public String getQuery() {
        return this.m_query;
    }

    public String queryTipText() {
        return "The query that should load the instances.\n The query has to be of the form SELECT <column-list>|* FROM <table> [WHERE <conditions>]";
    }

    public void setKeys(String keys) {
        this.m_Keys = keys;
        this.m_orderBy.clear();
        StringTokenizer st = new StringTokenizer(keys, ",");
        while (st.hasMoreTokens()) {
            String column = st.nextToken();
            column = column.replaceAll(" ", "");
            this.m_orderBy.add(column);
        }
    }

    public String getKeys() {
        StringBuffer key = new StringBuffer();
        for (int i = 0; i < this.m_orderBy.size(); ++i) {
            key.append(this.m_orderBy.get(i));
            if (i == this.m_orderBy.size() - 1) continue;
            key.append(", ");
        }
        return key.toString();
    }

    public String keysTipText() {
        return "For incremental loading a unique identiefer has to be specified.\nIf the query includes all columns of a table (SELECT *...) a primary key\ncan be detected automatically depending on the JDBC driver. If that is not possible\nspecify the key columns here in a comma separated list.";
    }

    public void setCustomPropsFile(File value) {
        this.m_CustomPropsFile = value;
    }

    public File getCustomPropsFile() {
        return this.m_CustomPropsFile;
    }

    public String customPropsFileTipText() {
        return "The custom properties that the user can use to override the default ones.";
    }

    @Override
    public void setUrl(String url) {
        this.checkEnv();
        String dbU = this.m_URL = url;
        try {
            dbU = this.m_env.substitute(dbU);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_DataBaseConnection.setDatabaseURL(dbU);
    }

    @Override
    public String getUrl() {
        return this.m_URL;
    }

    public String urlTipText() {
        return "The URL of the database";
    }

    @Override
    public void setUser(String user) {
        this.checkEnv();
        this.m_User = user;
        String userCopy = user;
        try {
            userCopy = this.m_env.substitute(userCopy);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_DataBaseConnection.setUsername(userCopy);
    }

    @Override
    public String getUser() {
        return this.m_User;
    }

    public String userTipText() {
        return "The user name for the database";
    }

    @Override
    public void setPassword(String password) {
        this.checkEnv();
        this.m_Password = password;
        String passCopy = password;
        try {
            passCopy = this.m_env.substitute(passCopy);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_DataBaseConnection.setPassword(password);
    }

    public String getPassword() {
        return this.m_Password;
    }

    public String passwordTipText() {
        return "The database password";
    }

    public String sparseDataTipText() {
        return "Encode data as sparse instances.";
    }

    public void setSparseData(boolean s) {
        this.m_CreateSparseData = s;
    }

    public boolean getSparseData() {
        return this.m_CreateSparseData;
    }

    public void setSource(String url, String userName, String password) {
        try {
            this.m_DataBaseConnection = this.newDatabaseConnection();
            this.setUrl(url);
            this.setUser(userName);
            this.setPassword(password);
        }
        catch (Exception ex) {
            this.printException(ex);
        }
    }

    public void setSource(String url) {
        try {
            this.m_DataBaseConnection = this.newDatabaseConnection();
            this.setUrl(url);
            this.m_User = this.m_DataBaseConnection.getUsername();
            this.m_Password = this.m_DataBaseConnection.getPassword();
        }
        catch (Exception ex) {
            this.printException(ex);
        }
    }

    public void setSource() throws Exception {
        this.m_DataBaseConnection = this.newDatabaseConnection();
        this.m_URL = this.m_DataBaseConnection.getDatabaseURL();
        this.m_User = this.m_DataBaseConnection.getUsername();
        this.m_Password = this.m_DataBaseConnection.getPassword();
    }

    public void connectToDatabase() {
        try {
            if (!this.m_DataBaseConnection.isConnected()) {
                this.m_DataBaseConnection.connectToDatabase();
            }
        }
        catch (Exception ex) {
            this.printException(ex);
        }
    }

    private String endOfQuery(boolean onlyTableName) {
        int beginIndex = this.m_query.indexOf("FROM ") + 5;
        while (this.m_query.charAt(beginIndex) == ' ') {
            ++beginIndex;
        }
        int endIndex = this.m_query.indexOf(" ", beginIndex);
        String table = endIndex != -1 && onlyTableName ? this.m_query.substring(beginIndex, endIndex) : this.m_query.substring(beginIndex);
        if (this.m_DataBaseConnection.getUpperCase()) {
            table = table.toUpperCase();
        }
        return table;
    }

    private boolean checkForKey() throws Exception {
        String query = this.m_query;
        if (!(query = query.replaceAll(" +", " ")).startsWith("SELECT *")) {
            return false;
        }
        this.m_orderBy.clear();
        if (!this.m_DataBaseConnection.isConnected()) {
            this.m_DataBaseConnection.connectToDatabase();
        }
        DatabaseMetaData dmd = this.m_DataBaseConnection.getMetaData();
        String table = this.endOfQuery(true);
        ResultSet rs = dmd.getPrimaryKeys(null, null, table);
        while (rs.next()) {
            this.m_orderBy.add(rs.getString(4));
        }
        rs.close();
        if (this.m_orderBy.size() != 0) {
            return true;
        }
        rs = dmd.getBestRowIdentifier(null, null, table, 2, false);
        ResultSetMetaData rmd = rs.getMetaData();
        int help = 0;
        while (rs.next()) {
            this.m_orderBy.add(rs.getString(2));
            ++help;
        }
        rs.close();
        if (help == rmd.getColumnCount()) {
            this.m_orderBy.clear();
        }
        return this.m_orderBy.size() != 0;
    }

    private void stringToNominal(ResultSet rs, int i) throws Exception {
        while (rs.next()) {
            Double index;
            String str = rs.getString(1);
            if (rs.wasNull() || (index = this.m_nominalIndexes[i - 1].get(str)) != null) continue;
            index = new Double(this.m_nominalStrings[i - 1].size());
            this.m_nominalIndexes[i - 1].put(str, index);
            this.m_nominalStrings[i - 1].add(str);
        }
    }

    private String limitQuery(String query, int offset, int choice) {
        StringBuffer order = new StringBuffer();
        String orderByString = "";
        if (this.m_orderBy.size() != 0) {
            order.append(" ORDER BY ");
            for (int i = 0; i < this.m_orderBy.size() - 1; ++i) {
                if (this.m_DataBaseConnection.getUpperCase()) {
                    order.append(this.m_orderBy.get(i).toUpperCase());
                } else {
                    order.append(this.m_orderBy.get(i));
                }
                order.append(", ");
            }
            if (this.m_DataBaseConnection.getUpperCase()) {
                order.append(this.m_orderBy.get(this.m_orderBy.size() - 1).toUpperCase());
            } else {
                order.append(this.m_orderBy.get(this.m_orderBy.size() - 1));
            }
            orderByString = order.toString();
        }
        if (choice == 0) {
            String limitedQuery = query.replaceFirst("SELECT", "SELECT LIMIT " + offset + " 1");
            limitedQuery = limitedQuery.concat(orderByString);
            return limitedQuery;
        }
        if (choice == 1) {
            String limitedQuery = query.concat(orderByString + " LIMIT 1 OFFSET " + offset);
            return limitedQuery;
        }
        String limitedQuery = query.concat(orderByString + " LIMIT " + offset + ", 1");
        return limitedQuery;
    }

    private int getRowCount() throws Exception {
        String query = "SELECT COUNT(*) FROM " + this.endOfQuery(false);
        if (!this.m_DataBaseConnection.execute(query)) {
            throw new Exception("Cannot count results tuples.");
        }
        ResultSet rs = this.m_DataBaseConnection.getResultSet();
        rs.next();
        int i = rs.getInt(1);
        rs.close();
        return i;
    }

    @Override
    public Instances getStructure() throws IOException {
        block47: {
            if (this.m_DataBaseConnection == null) {
                throw new IOException("No source database has been specified");
            }
            this.connectToDatabase();
            try {
                if (this.m_pseudoIncremental && this.m_structure == null) {
                    if (this.getRetrieval() == 1) {
                        throw new IOException("Cannot mix getting instances in both incremental and batch modes");
                    }
                    this.setRetrieval(0);
                    this.m_datasetPseudoInc = this.getDataSet();
                    this.m_structure = new Instances(this.m_datasetPseudoInc, 0);
                    this.setRetrieval(0);
                    return this.m_structure;
                }
                if (this.m_structure == null) {
                    if (this.m_checkForTable && !this.m_DataBaseConnection.tableExists(this.endOfQuery(true))) {
                        throw new IOException("Table does not exist according to metadata from JDBC driver. If you are convinced the table exists, set 'checkForTable' to 'False' in your DatabaseUtils.props file and try again.");
                    }
                    int choice = 0;
                    boolean rightChoice = false;
                    while (!rightChoice) {
                        try {
                            String limitQ = this.limitQuery(this.m_query, 0, choice);
                            if (!this.m_DataBaseConnection.execute(limitQ)) {
                                throw new IOException("Query didn't produce results");
                            }
                            this.m_choice = choice;
                            rightChoice = true;
                        }
                        catch (SQLException ex) {
                            if (++choice != 3) continue;
                            System.out.println("Incremental loading not supported for that DBMS. Pseudoincremental mode is used if you use incremental loading.\nAll rows are loaded into memory once and retrieved incrementally from memory instead of from the database.");
                            this.m_pseudoIncremental = true;
                            break block47;
                        }
                    }
                    String end = this.endOfQuery(false);
                    ResultSet rs = this.m_DataBaseConnection.getResultSet();
                    ResultSetMetaData md = rs.getMetaData();
                    int numAttributes = md.getColumnCount();
                    int[] attributeTypes = new int[numAttributes];
                    this.m_nominalIndexes = (Hashtable[])Utils.cast(new Hashtable[numAttributes]);
                    this.m_nominalStrings = (ArrayList[])Utils.cast(new ArrayList[numAttributes]);
                    block24: for (int i = 1; i <= numAttributes; ++i) {
                        switch (this.m_DataBaseConnection.translateDBColumnType(md.getColumnTypeName(i))) {
                            case 0: {
                                ResultSet rs1;
                                String columnName = md.getColumnLabel(i);
                                if (this.m_DataBaseConnection.getUpperCase()) {
                                    columnName = columnName.toUpperCase();
                                }
                                this.m_nominalIndexes[i - 1] = new Hashtable();
                                this.m_nominalStrings[i - 1] = new ArrayList();
                                if (this.getRetrieval() != 2) {
                                    attributeTypes[i - 1] = 2;
                                    continue block24;
                                }
                                String query = "SELECT COUNT(DISTINCT( " + columnName + " )) FROM " + end;
                                if (this.m_DataBaseConnection.execute(query)) {
                                    rs1 = this.m_DataBaseConnection.getResultSet();
                                    rs1.next();
                                    int count = rs1.getInt(1);
                                    rs1.close();
                                    if (count > this.m_nominalToStringLimit || !this.m_DataBaseConnection.execute("SELECT DISTINCT ( " + columnName + " ) FROM " + end + " ORDER BY " + columnName)) {
                                        attributeTypes[i - 1] = 2;
                                        continue block24;
                                    }
                                } else {
                                    attributeTypes[i - 1] = 2;
                                    continue block24;
                                }
                                rs1 = this.m_DataBaseConnection.getResultSet();
                                attributeTypes[i - 1] = 1;
                                this.stringToNominal(rs1, i);
                                rs1.close();
                                continue block24;
                            }
                            case 9: {
                                ResultSet rs1;
                                String columnName = md.getColumnLabel(i);
                                if (this.m_DataBaseConnection.getUpperCase()) {
                                    columnName = columnName.toUpperCase();
                                }
                                this.m_nominalIndexes[i - 1] = new Hashtable();
                                this.m_nominalStrings[i - 1] = new ArrayList();
                                if (this.getRetrieval() != 2) {
                                    attributeTypes[i - 1] = 2;
                                    continue block24;
                                }
                                String query = "SELECT COUNT(DISTINCT( " + columnName + " )) FROM " + end;
                                if (this.m_DataBaseConnection.execute(query)) {
                                    rs1 = this.m_DataBaseConnection.getResultSet();
                                    this.stringToNominal(rs1, i);
                                    rs1.close();
                                }
                                attributeTypes[i - 1] = 2;
                                continue block24;
                            }
                            case 1: {
                                attributeTypes[i - 1] = 1;
                                this.m_nominalIndexes[i - 1] = new Hashtable();
                                this.m_nominalIndexes[i - 1].put("false", new Double(0.0));
                                this.m_nominalIndexes[i - 1].put("true", new Double(1.0));
                                this.m_nominalStrings[i - 1] = new ArrayList();
                                this.m_nominalStrings[i - 1].add("false");
                                this.m_nominalStrings[i - 1].add("true");
                                continue block24;
                            }
                            case 2: {
                                attributeTypes[i - 1] = 0;
                                continue block24;
                            }
                            case 3: {
                                attributeTypes[i - 1] = 0;
                                continue block24;
                            }
                            case 4: {
                                attributeTypes[i - 1] = 0;
                                continue block24;
                            }
                            case 5: {
                                attributeTypes[i - 1] = 0;
                                continue block24;
                            }
                            case 6: {
                                attributeTypes[i - 1] = 0;
                                continue block24;
                            }
                            case 7: {
                                attributeTypes[i - 1] = 0;
                                continue block24;
                            }
                            case 8: {
                                attributeTypes[i - 1] = 3;
                                continue block24;
                            }
                            case 10: {
                                attributeTypes[i - 1] = 3;
                                continue block24;
                            }
                            default: {
                                attributeTypes[i - 1] = 2;
                            }
                        }
                    }
                    ArrayList<Attribute> attribInfo = new ArrayList<Attribute>();
                    block25: for (int i = 0; i < numAttributes; ++i) {
                        String attribName = md.getColumnLabel(i + 1);
                        switch (attributeTypes[i]) {
                            case 1: {
                                attribInfo.add(new Attribute(attribName, this.m_nominalStrings[i]));
                                continue block25;
                            }
                            case 0: {
                                attribInfo.add(new Attribute(attribName));
                                continue block25;
                            }
                            case 2: {
                                Attribute att = new Attribute(attribName, (List<String>)null);
                                for (int n = 0; n < this.m_nominalStrings[i].size(); ++n) {
                                    att.addStringValue(this.m_nominalStrings[i].get(n));
                                }
                                attribInfo.add(att);
                                continue block25;
                            }
                            case 3: {
                                attribInfo.add(new Attribute(attribName, (String)null));
                                continue block25;
                            }
                            default: {
                                throw new IOException("Unknown attribute type");
                            }
                        }
                    }
                    this.m_structure = new Instances(this.endOfQuery(true), attribInfo, 0);
                    if (this.m_DataBaseConnection.getUpperCase()) {
                        this.m_idColumn = this.m_idColumn.toUpperCase();
                    }
                    if (this.m_structure.attribute(0).name().equals(this.m_idColumn)) {
                        this.m_oldStructure = new Instances(this.m_structure, 0);
                        this.m_oldStructure.deleteAttributeAt(0);
                    } else {
                        this.m_oldStructure = new Instances(this.m_structure, 0);
                    }
                    if (this.m_DataBaseConnection.getResultSet() != null) {
                        rs.close();
                    }
                } else if (this.m_oldStructure == null) {
                    this.m_oldStructure = new Instances(this.m_structure, 0);
                }
                this.m_DataBaseConnection.disconnectFromDatabase();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.printException(ex);
            }
        }
        return this.m_oldStructure;
    }

    @Override
    public Instances getDataSet() throws IOException {
        Instances result;
        block15: {
            if (this.m_DataBaseConnection == null) {
                throw new IOException("No source database has been specified");
            }
            if (this.getRetrieval() == 2) {
                throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
            }
            this.setRetrieval(1);
            result = null;
            this.checkEnv();
            try {
                InstanceQuery iq = new InstanceQuery();
                iq.initialize(this.m_CustomPropsFile);
                String realURL = this.m_URL;
                try {
                    realURL = this.m_env.substitute(realURL);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                iq.setDatabaseURL(realURL);
                String realUser = this.m_User;
                try {
                    realUser = this.m_env.substitute(realUser);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                iq.setUsername(realUser);
                String realPass = this.m_Password;
                try {
                    realPass = this.m_env.substitute(realPass);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                iq.setPassword(realPass);
                String realQuery = this.m_query;
                try {
                    realQuery = this.m_env.substitute(realQuery);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                iq.setQuery(realQuery);
                iq.setSparseData(this.m_CreateSparseData);
                result = iq.retrieveInstances();
                if (this.m_DataBaseConnection.getUpperCase()) {
                    this.m_idColumn = this.m_idColumn.toUpperCase();
                }
                if (result.attribute(0).name().equals(this.m_idColumn)) {
                    result.deleteAttributeAt(0);
                }
                this.m_structure = new Instances(result, 0);
                iq.disconnectFromDatabase();
            }
            catch (Exception ex) {
                this.printException(ex);
                StringBuffer text = new StringBuffer();
                if (!this.m_query.equals("Select * from Results0")) break block15;
                text.append("\n\nDatabaseLoader options:\n");
                Enumeration enumi = this.listOptions();
                while (enumi.hasMoreElements()) {
                    Option option = (Option)enumi.nextElement();
                    text.append(option.synopsis() + '\n');
                    text.append(option.description() + '\n');
                }
                System.out.println(text);
            }
        }
        return result;
    }

    private Instance readInstance(ResultSet rs) throws Exception {
        ResultSetMetaData md = rs.getMetaData();
        int numAttributes = md.getColumnCount();
        double[] vals = new double[numAttributes];
        this.m_structure.delete();
        block13: for (int i = 1; i <= numAttributes; ++i) {
            switch (this.m_DataBaseConnection.translateDBColumnType(md.getColumnTypeName(i))) {
                case 0: {
                    String str = rs.getString(i);
                    if (rs.wasNull()) {
                        vals[i - 1] = Utils.missingValue();
                        continue block13;
                    }
                    Double index = this.m_nominalIndexes[i - 1].get(str);
                    if (index == null) {
                        index = new Double(this.m_structure.attribute(i - 1).addStringValue(str));
                    }
                    vals[i - 1] = index;
                    continue block13;
                }
                case 9: {
                    String str = rs.getString(i);
                    if (rs.wasNull()) {
                        vals[i - 1] = Utils.missingValue();
                        continue block13;
                    }
                    Double index = this.m_nominalIndexes[i - 1].get(str);
                    if (index == null) {
                        index = new Double(this.m_structure.attribute(i - 1).addStringValue(str));
                    }
                    vals[i - 1] = index;
                    continue block13;
                }
                case 1: {
                    boolean boo = rs.getBoolean(i);
                    if (rs.wasNull()) {
                        vals[i - 1] = Utils.missingValue();
                        continue block13;
                    }
                    vals[i - 1] = boo ? 1.0 : 0.0;
                    continue block13;
                }
                case 2: {
                    double dd = rs.getDouble(i);
                    if (rs.wasNull()) {
                        vals[i - 1] = Utils.missingValue();
                        continue block13;
                    }
                    vals[i - 1] = dd;
                    continue block13;
                }
                case 3: {
                    byte by = rs.getByte(i);
                    if (rs.wasNull()) {
                        vals[i - 1] = Utils.missingValue();
                        continue block13;
                    }
                    vals[i - 1] = by;
                    continue block13;
                }
                case 4: {
                    short sh = rs.getShort(i);
                    if (rs.wasNull()) {
                        vals[i - 1] = Utils.missingValue();
                        continue block13;
                    }
                    vals[i - 1] = sh;
                    continue block13;
                }
                case 5: {
                    int in = rs.getInt(i);
                    if (rs.wasNull()) {
                        vals[i - 1] = Utils.missingValue();
                        continue block13;
                    }
                    vals[i - 1] = in;
                    continue block13;
                }
                case 6: {
                    long lo = rs.getLong(i);
                    if (rs.wasNull()) {
                        vals[i - 1] = Utils.missingValue();
                        continue block13;
                    }
                    vals[i - 1] = lo;
                    continue block13;
                }
                case 7: {
                    float fl = rs.getFloat(i);
                    if (rs.wasNull()) {
                        vals[i - 1] = Utils.missingValue();
                        continue block13;
                    }
                    vals[i - 1] = fl;
                    continue block13;
                }
                case 8: {
                    Date date = rs.getDate(i);
                    if (rs.wasNull()) {
                        vals[i - 1] = Utils.missingValue();
                        continue block13;
                    }
                    vals[i - 1] = date.getTime();
                    continue block13;
                }
                case 10: {
                    Time time = rs.getTime(i);
                    if (rs.wasNull()) {
                        vals[i - 1] = Utils.missingValue();
                        continue block13;
                    }
                    vals[i - 1] = time.getTime();
                    continue block13;
                }
                default: {
                    vals[i - 1] = Utils.missingValue();
                }
            }
        }
        Instance inst = this.m_CreateSparseData ? new SparseInstance(1.0, vals) : new DenseInstance(1.0, vals);
        if (this.m_DataBaseConnection.getUpperCase()) {
            this.m_idColumn = this.m_idColumn.toUpperCase();
        }
        if (this.m_structure.attribute(0).name().equals(this.m_idColumn)) {
            inst.deleteAttributeAt(0);
            this.m_oldStructure.add(inst);
            inst = this.m_oldStructure.instance(0);
            this.m_oldStructure.delete(0);
        } else {
            this.m_structure.add(inst);
            inst = this.m_structure.instance(0);
            this.m_structure.delete(0);
        }
        return inst;
    }

    @Override
    public Instance getNextInstance(Instances structure) throws IOException {
        this.m_structure = structure;
        if (this.m_DataBaseConnection == null) {
            throw new IOException("No source database has been specified");
        }
        if (this.getRetrieval() == 1) {
            throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
        }
        if (this.m_pseudoIncremental) {
            this.setRetrieval(2);
            if (this.m_datasetPseudoInc.numInstances() > 0) {
                Instance current = this.m_datasetPseudoInc.instance(0);
                this.m_datasetPseudoInc.delete(0);
                return current;
            }
            this.resetStructure();
            return null;
        }
        this.setRetrieval(2);
        try {
            if (!this.m_DataBaseConnection.isConnected()) {
                this.connectToDatabase();
            }
            if (this.m_firstTime && this.m_orderBy.size() == 0 && !this.checkForKey()) {
                throw new Exception("A unique order cannot be detected automatically.\nYou have to use SELECT * in your query to enable this feature.\nMaybe JDBC driver is not able to detect key.\nDefine primary key in your database or use -P option (command line) or enter key columns in the GUI.");
            }
            if (this.m_firstTime) {
                this.m_firstTime = false;
                this.m_rowCount = this.getRowCount();
            }
            if (this.m_counter < this.m_rowCount) {
                if (!this.m_DataBaseConnection.execute(this.limitQuery(this.m_query, this.m_counter, this.m_choice))) {
                    throw new Exception("Tuple could not be retrieved.");
                }
                ++this.m_counter;
                ResultSet rs = this.m_DataBaseConnection.getResultSet();
                rs.next();
                Instance current = this.readInstance(rs);
                rs.close();
                return current;
            }
            this.m_DataBaseConnection.disconnectFromDatabase();
            this.resetStructure();
            return null;
        }
        catch (Exception ex) {
            this.printException(ex);
            return null;
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        if (this.getUrl() != null && this.getUrl().length() != 0) {
            options.add("-url");
            options.add(this.getUrl());
        }
        if (this.getUser() != null && this.getUser().length() != 0) {
            options.add("-user");
            options.add(this.getUser());
        }
        if (this.getPassword() != null && this.getPassword().length() != 0) {
            options.add("-password");
            options.add(this.getPassword());
        }
        options.add("-Q");
        options.add(this.getQuery());
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.m_orderBy.size(); ++i) {
            if (i > 0) {
                text.append(", ");
            }
            text.append(this.m_orderBy.get(i));
        }
        options.add("-P");
        options.add(text.toString());
        if (this.m_inc) {
            options.add("-I");
        }
        if (this.m_CustomPropsFile != null && !this.m_CustomPropsFile.isDirectory()) {
            options.add("-custom-props");
            options.add(this.m_CustomPropsFile.toString());
        }
        return options.toArray(new String[options.size()]);
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.add(new Option("\tThe JDBC URL to connect to.\n\t(default: from DatabaseUtils.props file)", "url", 1, "-url <JDBC URL>"));
        newVector.add(new Option("\tThe user to connect with to the database.\n\t(default: none)", "user", 1, "-user <name>"));
        newVector.add(new Option("\tThe password to connect with to the database.\n\t(default: none)", "password", 1, "-password <password>"));
        newVector.add(new Option("\tSQL query of the form\n\t\tSELECT <list of columns>|* FROM <table> [WHERE]\n\tto execute.\n\t(default: Select * From Results0)", "Q", 1, "-Q <query>"));
        newVector.add(new Option("\tList of column names uniquely defining a DB row\n\t(separated by ', ').\n\tUsed for incremental loading.\n\tIf not specified, the key will be determined automatically,\n\tif possible with the used JDBC driver.\n\tThe auto ID column created by the DatabaseSaver won't be loaded.", "P", 1, "-P <list of column names>"));
        newVector.add(new Option("\tSets incremental loading", "I", 0, "-I"));
        newVector.addElement(new Option("\tReturn sparse rather than normal instances.", "S", 0, "-S"));
        newVector.add(new Option("\tThe custom properties file to use instead of default ones,\n\tcontaining the database parameters.\n\t(default: none)", "custom-props", 1, "-custom-props <file>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String optionString = Utils.getOption('Q', options);
        String keyString = Utils.getOption('P', options);
        this.reset();
        String tmpStr = Utils.getOption("url", options);
        if (tmpStr.length() != 0) {
            this.setUrl(tmpStr);
        }
        if ((tmpStr = Utils.getOption("user", options)).length() != 0) {
            this.setUser(tmpStr);
        }
        if ((tmpStr = Utils.getOption("password", options)).length() != 0) {
            this.setPassword(tmpStr);
        }
        if (optionString.length() != 0) {
            this.setQuery(optionString);
        }
        this.m_orderBy.clear();
        this.m_inc = Utils.getFlag('I', options);
        if (this.m_inc) {
            StringTokenizer st = new StringTokenizer(keyString, ",");
            while (st.hasMoreTokens()) {
                String column = st.nextToken();
                column = column.replaceAll(" ", "");
                this.m_orderBy.add(column);
            }
        }
        if ((tmpStr = Utils.getOption("custom-props", options)).length() == 0) {
            this.setCustomPropsFile(null);
        } else {
            this.setCustomPropsFile(new File(tmpStr));
        }
    }

    private void printException(Exception ex) {
        System.out.println("\n--- Exception caught ---\n");
        while (ex != null) {
            System.out.println("Message:   " + ex.getMessage());
            if (ex instanceof SQLException) {
                System.out.println("SQLState:  " + ((SQLException)ex).getSQLState());
                System.out.println("ErrorCode: " + ((SQLException)ex).getErrorCode());
                ex = ((SQLException)ex).getNextException();
            } else {
                ex = null;
            }
            System.out.println("");
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9099 $");
    }

    public static void main(String[] options) {
        try {
            DatabaseLoader atf = new DatabaseLoader();
            atf.setOptions(options);
            atf.setSource(atf.getUrl(), atf.getUser(), atf.getPassword());
            if (!atf.m_inc) {
                System.out.println(atf.getDataSet());
            } else {
                Instance temp;
                Instances structure = atf.getStructure();
                System.out.println(structure);
                do {
                    if ((temp = atf.getNextInstance(structure)) == null) continue;
                    System.out.println(temp);
                } while (temp != null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\n" + e.getMessage());
        }
    }
}

