/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.neighboursearch.NearestNeighbourSearch;
import weka.core.neighboursearch.TreePerformanceStats;
import weka.core.neighboursearch.balltrees.BallNode;
import weka.core.neighboursearch.balltrees.BallTreeConstructor;
import weka.core.neighboursearch.balltrees.TopDownConstructor;

public class BallTree
extends NearestNeighbourSearch
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 728763855952698328L;
    protected int[] m_InstList;
    protected int m_MaxInstancesInLeaf = 40;
    protected TreePerformanceStats m_TreeStats = null;
    protected BallNode m_Root;
    protected BallTreeConstructor m_TreeConstructor = new TopDownConstructor();
    protected double[] m_Distances;

    public BallTree() {
        if (this.getMeasurePerformance()) {
            this.m_TreeStats = new TreePerformanceStats();
            this.m_Stats = this.m_TreeStats;
        }
    }

    public BallTree(Instances insts) {
        super(insts);
        if (this.getMeasurePerformance()) {
            this.m_TreeStats = new TreePerformanceStats();
            this.m_Stats = this.m_TreeStats;
        }
    }

    @Override
    public String globalInfo() {
        return "Class implementing the BallTree/Metric Tree algorithm for nearest neighbour search.\nThe connection to dataset is only a reference. For the tree structure the indexes are stored in an array.\nSee the implementing classes of different construction methods of the trees for details on its construction.\n\nFor more information see also:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.TECHREPORT);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Stephen M. Omohundro");
        result.setValue(TechnicalInformation.Field.YEAR, "1989");
        result.setValue(TechnicalInformation.Field.TITLE, "Five Balltree Construction Algorithms");
        result.setValue(TechnicalInformation.Field.MONTH, "December");
        result.setValue(TechnicalInformation.Field.NUMBER, "TR-89-063");
        result.setValue(TechnicalInformation.Field.INSTITUTION, "International Computer Science Institute");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.ARTICLE);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Jeffrey K. Uhlmann");
        additional.setValue(TechnicalInformation.Field.TITLE, "Satisfying general proximity/similarity queries with metric trees");
        additional.setValue(TechnicalInformation.Field.JOURNAL, "Information Processing Letters");
        additional.setValue(TechnicalInformation.Field.MONTH, "November");
        additional.setValue(TechnicalInformation.Field.YEAR, "1991");
        additional.setValue(TechnicalInformation.Field.NUMBER, "4");
        additional.setValue(TechnicalInformation.Field.VOLUME, "40");
        additional.setValue(TechnicalInformation.Field.PAGES, "175-179");
        return result;
    }

    protected void buildTree() throws Exception {
        if (this.m_Instances == null) {
            throw new Exception("No instances supplied yet. Have to call setInstances(instances) with a set of Instances first.");
        }
        this.m_InstList = new int[this.m_Instances.numInstances()];
        for (int i = 0; i < this.m_InstList.length; ++i) {
            this.m_InstList[i] = i;
        }
        this.m_DistanceFunction.setInstances(this.m_Instances);
        this.m_TreeConstructor.setInstances(this.m_Instances);
        this.m_TreeConstructor.setInstanceList(this.m_InstList);
        this.m_TreeConstructor.setEuclideanDistanceFunction((EuclideanDistance)this.m_DistanceFunction);
        this.m_Root = this.m_TreeConstructor.buildTree();
    }

    @Override
    public Instances kNearestNeighbours(Instance target, int k) throws Exception {
        NearestNeighbourSearch.MyHeapElement h;
        NearestNeighbourSearch.MyHeap heap = new NearestNeighbourSearch.MyHeap(this, k);
        if (this.m_Stats != null) {
            this.m_Stats.searchStart();
        }
        this.nearestNeighbours(heap, this.m_Root, target, k);
        if (this.m_Stats != null) {
            this.m_Stats.searchFinish();
        }
        Instances neighbours = new Instances(this.m_Instances, heap.totalSize());
        this.m_Distances = new double[heap.totalSize()];
        int[] indices = new int[heap.totalSize()];
        int i = 1;
        while (heap.noOfKthNearest() > 0) {
            h = heap.getKthNearest();
            indices[indices.length - i] = h.index;
            this.m_Distances[indices.length - i] = h.distance;
            ++i;
        }
        while (heap.size() > 0) {
            h = heap.get();
            indices[indices.length - i] = h.index;
            this.m_Distances[indices.length - i] = h.distance;
            ++i;
        }
        this.m_DistanceFunction.postProcessDistances(this.m_Distances);
        for (i = 0; i < indices.length; ++i) {
            neighbours.add(this.m_Instances.instance(indices[i]));
        }
        return neighbours;
    }

    protected void nearestNeighbours(NearestNeighbourSearch.MyHeap heap, BallNode node, Instance target, int k) throws Exception {
        double distance = Double.NEGATIVE_INFINITY;
        if (heap.totalSize() >= k) {
            distance = this.m_DistanceFunction.distance(target, node.getPivot());
        }
        if (distance > -1.0E-6 && Math.sqrt(heap.peek().distance) < distance - node.getRadius()) {
            return;
        }
        if (node.m_Left != null && node.m_Right != null) {
            if (this.m_TreeStats != null) {
                this.m_TreeStats.incrIntNodeCount();
            }
            double leftPivotDist = Math.sqrt(this.m_DistanceFunction.distance(target, node.m_Left.getPivot(), Double.POSITIVE_INFINITY));
            double rightPivotDist = Math.sqrt(this.m_DistanceFunction.distance(target, node.m_Right.getPivot(), Double.POSITIVE_INFINITY));
            double leftBallDist = leftPivotDist - node.m_Left.getRadius();
            double rightBallDist = rightPivotDist - node.m_Right.getRadius();
            if (leftBallDist < 0.0 && rightBallDist < 0.0) {
                if (leftPivotDist < rightPivotDist) {
                    this.nearestNeighbours(heap, node.m_Left, target, k);
                    this.nearestNeighbours(heap, node.m_Right, target, k);
                } else {
                    this.nearestNeighbours(heap, node.m_Right, target, k);
                    this.nearestNeighbours(heap, node.m_Left, target, k);
                }
            } else if (leftBallDist < rightBallDist) {
                this.nearestNeighbours(heap, node.m_Left, target, k);
                this.nearestNeighbours(heap, node.m_Right, target, k);
            } else {
                this.nearestNeighbours(heap, node.m_Right, target, k);
                this.nearestNeighbours(heap, node.m_Left, target, k);
            }
        } else {
            if (node.m_Left != null || node.m_Right != null) {
                throw new Exception("Error: Only one leaf of the built ball tree is assigned. Please check code.");
            }
            if (node.m_Left == null && node.m_Right == null) {
                if (this.m_TreeStats != null) {
                    this.m_TreeStats.updatePointCount(node.numInstances());
                    this.m_TreeStats.incrLeafCount();
                }
                for (int i = node.m_Start; i <= node.m_End; ++i) {
                    if (target == this.m_Instances.instance(this.m_InstList[i])) continue;
                    if (heap.totalSize() < k) {
                        distance = this.m_DistanceFunction.distance(target, this.m_Instances.instance(this.m_InstList[i]), Double.POSITIVE_INFINITY, this.m_Stats);
                        heap.put(this.m_InstList[i], distance);
                        continue;
                    }
                    NearestNeighbourSearch.MyHeapElement head = heap.peek();
                    distance = this.m_DistanceFunction.distance(target, this.m_Instances.instance(this.m_InstList[i]), head.distance, this.m_Stats);
                    if (distance < head.distance) {
                        heap.putBySubstitute(this.m_InstList[i], distance);
                        continue;
                    }
                    if (distance != head.distance) continue;
                    heap.putKthNearest(this.m_InstList[i], distance);
                }
            }
        }
    }

    @Override
    public Instance nearestNeighbour(Instance target) throws Exception {
        return this.kNearestNeighbours(target, 1).instance(0);
    }

    @Override
    public double[] getDistances() throws Exception {
        if (this.m_Distances == null) {
            throw new Exception("No distances available. Please call either kNearestNeighbours or nearestNeighbours first.");
        }
        return this.m_Distances;
    }

    @Override
    public void update(Instance ins) throws Exception {
        this.addInstanceInfo(ins);
        this.m_InstList = this.m_TreeConstructor.addInstance(this.m_Root, ins);
    }

    @Override
    public void addInstanceInfo(Instance ins) {
        if (this.m_Instances != null) {
            this.m_DistanceFunction.update(ins);
        }
    }

    @Override
    public void setInstances(Instances insts) throws Exception {
        super.setInstances(insts);
        this.buildTree();
    }

    public String ballTreeConstructorTipText() {
        return "The tree constructor being used.";
    }

    public BallTreeConstructor getBallTreeConstructor() {
        return this.m_TreeConstructor;
    }

    public void setBallTreeConstructor(BallTreeConstructor constructor) {
        this.m_TreeConstructor = constructor;
    }

    public double measureTreeSize() {
        return this.m_TreeConstructor.getNumNodes();
    }

    public double measureNumLeaves() {
        return this.m_TreeConstructor.getNumLeaves();
    }

    public double measureMaxDepth() {
        return this.m_TreeConstructor.getMaxDepth();
    }

    @Override
    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>();
        newVector.addElement("measureTreeSize");
        newVector.addElement("measureNumLeaves");
        newVector.addElement("measureMaxDepth");
        if (this.m_Stats != null) {
            Enumeration e = this.m_Stats.enumerateMeasures();
            while (e.hasMoreElements()) {
                newVector.addElement((String)e.nextElement());
            }
        }
        return newVector.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.compareToIgnoreCase("measureMaxDepth") == 0) {
            return this.measureMaxDepth();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureTreeSize") == 0) {
            return this.measureTreeSize();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureNumLeaves") == 0) {
            return this.measureNumLeaves();
        }
        if (this.m_Stats != null) {
            return this.m_Stats.getMeasure(additionalMeasureName);
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (BallTree)");
    }

    @Override
    public void setMeasurePerformance(boolean measurePerformance) {
        this.m_MeasurePerformance = measurePerformance;
        if (this.m_MeasurePerformance) {
            if (this.m_Stats == null) {
                this.m_TreeStats = new TreePerformanceStats();
                this.m_Stats = this.m_TreeStats;
            }
        } else {
            this.m_TreeStats = null;
            this.m_Stats = null;
        }
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tThe construction method to employ. Either TopDown or BottomUp\n\t(default: weka.core.TopDownConstructor)", "C", 1, "-C <classname and options>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String optionString = Utils.getOption('C', options);
        if (optionString.length() != 0) {
            String[] constructorSpec = Utils.splitOptions(optionString);
            if (constructorSpec.length == 0) {
                throw new Exception("Invalid BallTreeConstructor specification string.");
            }
            String className = constructorSpec[0];
            constructorSpec[0] = "";
            this.setBallTreeConstructor((BallTreeConstructor)Utils.forName(BallTreeConstructor.class, className, constructorSpec));
        } else {
            this.setBallTreeConstructor(new TopDownConstructor());
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-C");
        result.add((this.m_TreeConstructor.getClass().getName() + " " + Utils.joinOptions(this.m_TreeConstructor.getOptions())).trim());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8048 $");
    }
}

