/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators.classifiers.regression;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.datagenerators.RegressionGenerator;

public class MexicanHat
extends RegressionGenerator {
    static final long serialVersionUID = 4577016375261512975L;
    protected double m_Amplitude;
    protected double m_MinRange;
    protected double m_MaxRange;
    protected double m_NoiseRate;
    protected double m_NoiseVariance;
    protected Random m_NoiseRandom = null;

    public MexicanHat() {
        this.setAmplitude(this.defaultAmplitude());
        this.setMinRange(this.defaultMinRange());
        this.setMaxRange(this.defaultMaxRange());
        this.setNoiseRate(this.defaultNoiseRate());
        this.setNoiseVariance(this.defaultNoiseVariance());
    }

    public String globalInfo() {
        return "A data generator for the simple 'Mexian Hat' function:\n   y = sin|x| / |x|\nIn addition to this simple function, the amplitude can be changed and gaussian noise can be added.";
    }

    @Override
    public Enumeration listOptions() {
        Vector result = this.enumToVector(super.listOptions());
        result.addElement(new Option("\tThe amplitude multiplier (default " + this.defaultAmplitude() + ").", "A", 1, "-A <num>"));
        result.addElement(new Option("\tThe range x is randomly drawn from (default " + this.defaultMinRange() + ".." + this.defaultMaxRange() + ").", "R", 1, "-R <num>..<num>"));
        result.addElement(new Option("\tThe noise rate (default " + this.defaultNoiseRate() + ").", "N", 1, "-N <num>"));
        result.addElement(new Option("\tThe noise variance (default " + this.defaultNoiseVariance() + ").", "V", 1, "-V <num>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption('A', options);
        if (tmpStr.length() != 0) {
            this.setAmplitude(Double.parseDouble(tmpStr));
        } else {
            this.setAmplitude(this.defaultAmplitude());
        }
        tmpStr = Utils.getOption('R', options);
        if (tmpStr.length() != 0) {
            this.setRange(tmpStr);
        } else {
            this.setRange(this.defaultMinRange() + ".." + this.defaultMaxRange());
        }
        tmpStr = Utils.getOption('N', options);
        if (tmpStr.length() != 0) {
            this.setNoiseRate(Double.parseDouble(tmpStr));
        } else {
            this.setNoiseRate(this.defaultNoiseRate());
        }
        tmpStr = Utils.getOption('V', options);
        if (tmpStr.length() != 0) {
            this.setNoiseVariance(Double.parseDouble(tmpStr));
        } else {
            this.setNoiseVariance(this.defaultNoiseVariance());
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = this.removeBlacklist(super.getOptions());
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-A");
        result.add("" + this.getAmplitude());
        result.add("-R");
        result.add("" + this.getRange());
        result.add("-N");
        result.add("" + this.getNoiseRate());
        result.add("-V");
        result.add("" + this.getNoiseVariance());
        return result.toArray(new String[result.size()]);
    }

    protected double defaultAmplitude() {
        return 1.0;
    }

    public double getAmplitude() {
        return this.m_Amplitude;
    }

    public void setAmplitude(double value) {
        this.m_Amplitude = value;
    }

    public String amplitudeTipText() {
        return "The amplitude of the mexican hat.";
    }

    protected void setRange(String fromTo) {
        int i = fromTo.indexOf("..");
        String from = fromTo.substring(0, i);
        this.setMinRange(Double.valueOf(from));
        String to = fromTo.substring(i + 2, fromTo.length());
        this.setMaxRange(Double.valueOf(to));
    }

    protected String getRange() {
        String fromTo = "" + Utils.doubleToString(this.getMinRange(), 2) + ".." + Utils.doubleToString(this.getMaxRange(), 2);
        return fromTo;
    }

    protected String rangeTipText() {
        return "The upper and lower boundary for the range x is drawn from randomly.";
    }

    protected double defaultMinRange() {
        return -10.0;
    }

    public void setMinRange(double value) {
        this.m_MinRange = value;
    }

    public double getMinRange() {
        return this.m_MinRange;
    }

    public String minRangeTipText() {
        return "The lower boundary for the range x is drawn from randomly.";
    }

    protected double defaultMaxRange() {
        return 10.0;
    }

    public void setMaxRange(double value) {
        this.m_MaxRange = value;
    }

    public double getMaxRange() {
        return this.m_MaxRange;
    }

    public String maxRangeTipText() {
        return "The upper boundary for the range x is drawn from randomly.";
    }

    protected double defaultNoiseRate() {
        return 0.0;
    }

    public double getNoiseRate() {
        return this.m_NoiseRate;
    }

    public void setNoiseRate(double value) {
        this.m_NoiseRate = value;
    }

    public String noiseRateTipText() {
        return "The gaussian noise rate to use.";
    }

    protected double defaultNoiseVariance() {
        return 1.0;
    }

    public double getNoiseVariance() {
        return this.m_NoiseVariance;
    }

    public void setNoiseVariance(double value) {
        if (!(value > 0.0)) {
            throw new IllegalArgumentException("Noise variance needs to be > 0 (provided: " + value + ")!");
        }
        this.m_NoiseVariance = value;
    }

    public String noiseVarianceTipText() {
        return "The noise variance to use.";
    }

    @Override
    public boolean getSingleModeFlag() throws Exception {
        return true;
    }

    @Override
    public Instances defineDataFormat() throws Exception {
        this.m_Random = new Random(this.getSeed());
        this.m_NoiseRandom = new Random(this.getSeed());
        this.setNumExamplesAct(this.getNumExamples());
        FastVector<Attribute> atts = new FastVector<Attribute>();
        atts.addElement(new Attribute("x"));
        atts.addElement(new Attribute("y"));
        this.m_DatasetFormat = new Instances(this.getRelationNameToUse(), atts, 0);
        return this.m_DatasetFormat;
    }

    @Override
    public Instance generateExample() throws Exception {
        DenseInstance result = null;
        Random rand = this.getRandom();
        if (this.m_DatasetFormat == null) {
            throw new Exception("Dataset format not defined.");
        }
        double[] atts = new double[this.m_DatasetFormat.numAttributes()];
        double x = rand.nextDouble();
        double y = Utils.eq(x = x * (this.getMaxRange() - this.getMinRange()) + this.getMinRange(), 0.0) ? this.getAmplitude() : this.getAmplitude() * StrictMath.sin(StrictMath.abs(x)) / StrictMath.abs(x);
        atts[0] = x;
        atts[1] = y += this.getAmplitude() * this.m_NoiseRandom.nextGaussian() * this.getNoiseRate() * this.getNoiseVariance();
        result = new DenseInstance(1.0, atts);
        result.setDataset(this.m_DatasetFormat);
        return result;
    }

    @Override
    public Instances generateExamples() throws Exception {
        Instances result = new Instances(this.m_DatasetFormat, 0);
        this.m_Random = new Random(this.getSeed());
        for (int i = 0; i < this.getNumExamplesAct(); ++i) {
            result.add(this.generateExample());
        }
        return result;
    }

    @Override
    public String generateStart() {
        return "";
    }

    @Override
    public String generateFinished() throws Exception {
        return "";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8048 $");
    }

    public static void main(String[] args) {
        MexicanHat.runDataGenerator(new MexicanHat(), args);
    }
}

