/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import weka.core.Capabilities;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.estimators.Estimator;
import weka.estimators.IncrementalEstimator;

public class DiscreteEstimator
extends Estimator
implements IncrementalEstimator {
    private static final long serialVersionUID = -5526486742612434779L;
    private double[] m_Counts;
    private double m_SumOfCounts;

    public DiscreteEstimator(int numSymbols, boolean laplace) {
        this.m_Counts = new double[numSymbols];
        this.m_SumOfCounts = 0.0;
        if (laplace) {
            for (int i = 0; i < numSymbols; ++i) {
                this.m_Counts[i] = 1.0;
            }
            this.m_SumOfCounts = numSymbols;
        }
    }

    public DiscreteEstimator(int nSymbols, double fPrior) {
        this.m_Counts = new double[nSymbols];
        for (int iSymbol = 0; iSymbol < nSymbols; ++iSymbol) {
            this.m_Counts[iSymbol] = fPrior;
        }
        this.m_SumOfCounts = fPrior * (double)nSymbols;
    }

    @Override
    public void addValue(double data, double weight) {
        int n = (int)data;
        this.m_Counts[n] = this.m_Counts[n] + weight;
        this.m_SumOfCounts += weight;
    }

    @Override
    public double getProbability(double data) {
        if (this.m_SumOfCounts == 0.0) {
            return 0.0;
        }
        return this.m_Counts[(int)data] / this.m_SumOfCounts;
    }

    public int getNumSymbols() {
        return this.m_Counts == null ? 0 : this.m_Counts.length;
    }

    public double getCount(double data) {
        if (this.m_SumOfCounts == 0.0) {
            return 0.0;
        }
        return this.m_Counts[(int)data];
    }

    public double getSumOfCounts() {
        return this.m_SumOfCounts;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("Discrete Estimator. Counts = ");
        if (this.m_SumOfCounts > 1.0) {
            for (int i = 0; i < this.m_Counts.length; ++i) {
                result.append(" ").append(Utils.doubleToString(this.m_Counts[i], 2));
            }
            result.append("  (Total = ").append(Utils.doubleToString(this.m_SumOfCounts, 2));
            result.append(")\n");
        } else {
            for (int i = 0; i < this.m_Counts.length; ++i) {
                result.append(" ").append(this.m_Counts[i]);
            }
            result.append("  (Total = ").append(this.m_SumOfCounts).append(")\n");
        }
        return result.toString();
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8048 $");
    }

    public static void main(String[] argv) {
        try {
            int current;
            if (argv.length == 0) {
                System.out.println("Please specify a set of instances.");
                return;
            }
            int max = current = Integer.parseInt(argv[0]);
            for (int i = 1; i < argv.length; ++i) {
                current = Integer.parseInt(argv[i]);
                if (current <= max) continue;
                max = current;
            }
            DiscreteEstimator newEst = new DiscreteEstimator(max + 1, true);
            for (int i = 0; i < argv.length; ++i) {
                current = Integer.parseInt(argv[i]);
                System.out.println(newEst);
                System.out.println("Prediction for " + current + " = " + newEst.getProbability(current));
                newEst.addValue(current, 1.0);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

