/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.SimpleStreamFilter;

public class ClassAssigner
extends SimpleStreamFilter {
    private static final long serialVersionUID = 1775780193887394115L;
    public static final int FIRST = 0;
    public static final int LAST = -2;
    public static final int UNSET = -1;
    protected int m_ClassIndex = -2;

    @Override
    public String globalInfo() {
        return "Filter that can set and unset the class index.";
    }

    @Override
    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        result.addElement(new Option("\tThe index of the class attribute. Index starts with 1, 'first'\n\tand 'last' are accepted, '0' unsets the class index.\n\t(default: last)", "C", 1, "-C <num|first|last|0>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption("C", options);
        if (tmpStr.length() != 0) {
            this.setClassIndex(tmpStr);
        } else {
            this.setClassIndex("last");
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-C");
        result.add(this.getClassIndex());
        return result.toArray(new String[result.size()]);
    }

    public String classIndexTipText() {
        return "The index of the class attribute, starts with 1, 'first' and 'last' are accepted as well, '0' unsets the class index.";
    }

    public void setClassIndex(String value) {
        if (value.equalsIgnoreCase("first")) {
            this.m_ClassIndex = 0;
        } else if (value.equalsIgnoreCase("last")) {
            this.m_ClassIndex = -2;
        } else if (value.equalsIgnoreCase("0")) {
            this.m_ClassIndex = -1;
        } else {
            try {
                this.m_ClassIndex = Integer.parseInt(value) - 1;
            }
            catch (Exception e) {
                System.err.println("Error parsing '" + value + "'!");
            }
        }
    }

    public String getClassIndex() {
        if (this.m_ClassIndex == 0) {
            return "first";
        }
        if (this.m_ClassIndex == -2) {
            return "last";
        }
        if (this.m_ClassIndex == -1) {
            return "0";
        }
        return "" + (this.m_ClassIndex + 1);
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        Instances result = new Instances(inputFormat, 0);
        if (this.m_ClassIndex == 0) {
            result.setClassIndex(0);
        } else if (this.m_ClassIndex == -2) {
            result.setClassIndex(result.numAttributes() - 1);
        } else if (this.m_ClassIndex == -1) {
            result.setClassIndex(-1);
        } else {
            result.setClassIndex(this.m_ClassIndex);
        }
        return result;
    }

    @Override
    protected Instance process(Instance instance) throws Exception {
        return instance;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8048 $");
    }

    public static void main(String[] args) {
        ClassAssigner.runFilter(new ClassAssigner(), args);
    }
}

