/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.AbstractInstance;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.matrix.EigenvalueDecomposition;
import weka.core.matrix.Matrix;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.Center;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.Remove;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public class PrincipalComponents
extends Filter
implements OptionHandler,
UnsupervisedFilter {
    private static final long serialVersionUID = -5649876869480249303L;
    protected Instances m_TrainInstances;
    protected Instances m_TrainCopy;
    protected Instances m_TransformedFormat;
    protected boolean m_HasClass;
    protected int m_ClassIndex;
    protected int m_NumAttribs;
    protected int m_NumInstances;
    protected double[][] m_Correlation;
    private boolean m_center = false;
    protected double[][] m_Eigenvectors;
    protected double[] m_Eigenvalues = null;
    protected int[] m_SortedEigens;
    protected double m_SumOfEigenValues = 0.0;
    protected ReplaceMissingValues m_ReplaceMissingFilter;
    protected NominalToBinary m_NominalToBinaryFilter;
    protected Remove m_AttributeFilter;
    protected Standardize m_standardizeFilter;
    protected Center m_centerFilter;
    protected int m_OutputNumAtts = -1;
    protected double m_CoverVariance = 0.95;
    protected int m_MaxAttrsInName = 5;
    protected int m_MaxAttributes = -1;

    public String globalInfo() {
        return "Performs a principal components analysis and transformation of the data.\nDimensionality reduction is accomplished by choosing enough eigenvectors to account for some percentage of the variance in the original data -- default 0.95 (95%).\nBased on code of the attribute selection scheme 'PrincipalComponents' by Mark Hall and Gabi Schmidberger.";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tCenter (rather than standardize) the\n\tdata and compute PCA using the covariance (rather\n\t than the correlation) matrix.", "C", 0, "-C"));
        result.addElement(new Option("\tRetain enough PC attributes to account\n\tfor this proportion of variance in the original data.\n\t(default: 0.95)", "R", 1, "-R <num>"));
        result.addElement(new Option("\tMaximum number of attributes to include in \n\ttransformed attribute names.\n\t(-1 = include all, default: 5)", "A", 1, "-A <num>"));
        result.addElement(new Option("\tMaximum number of PC attributes to retain.\n\t(-1 = include all, default: -1)", "M", 1, "-M <num>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('R', options);
        if (tmpStr.length() != 0) {
            this.setVarianceCovered(Double.parseDouble(tmpStr));
        } else {
            this.setVarianceCovered(0.95);
        }
        tmpStr = Utils.getOption('A', options);
        if (tmpStr.length() != 0) {
            this.setMaximumAttributeNames(Integer.parseInt(tmpStr));
        } else {
            this.setMaximumAttributeNames(5);
        }
        tmpStr = Utils.getOption('M', options);
        if (tmpStr.length() != 0) {
            this.setMaximumAttributes(Integer.parseInt(tmpStr));
        } else {
            this.setMaximumAttributes(-1);
        }
        this.setCenterData(Utils.getFlag('C', options));
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-R");
        result.add("" + this.getVarianceCovered());
        result.add("-A");
        result.add("" + this.getMaximumAttributeNames());
        result.add("-M");
        result.add("" + this.getMaximumAttributes());
        if (this.getCenterData()) {
            result.add("-C");
        }
        return result.toArray(new String[result.size()]);
    }

    public String centerDataTipText() {
        return "Center (rather than standardize) the data. PCA will be computed from the covariance (rather than correlation) matrix";
    }

    public void setCenterData(boolean center) {
        this.m_center = center;
    }

    public boolean getCenterData() {
        return this.m_center;
    }

    public String varianceCoveredTipText() {
        return "Retain enough PC attributes to account for this proportion of variance.";
    }

    public void setVarianceCovered(double value) {
        this.m_CoverVariance = value;
    }

    public double getVarianceCovered() {
        return this.m_CoverVariance;
    }

    public String maximumAttributeNamesTipText() {
        return "The maximum number of attributes to include in transformed attribute names.";
    }

    public void setMaximumAttributeNames(int value) {
        this.m_MaxAttrsInName = value;
    }

    public int getMaximumAttributeNames() {
        return this.m_MaxAttrsInName;
    }

    public String maximumAttributesTipText() {
        return "The maximum number of PC attributes to retain.";
    }

    public void setMaximumAttributes(int value) {
        this.m_MaxAttributes = value;
    }

    public int getMaximumAttributes() {
        return this.m_MaxAttributes;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        if (this.m_Eigenvalues == null) {
            return inputFormat;
        }
        int numAttsLowerBound = this.m_MaxAttributes > 0 ? this.m_NumAttribs - this.m_MaxAttributes : 0;
        if (numAttsLowerBound < 0) {
            numAttsLowerBound = 0;
        }
        double cumulative = 0.0;
        FastVector<Attribute> attributes = new FastVector<Attribute>();
        for (int i = this.m_NumAttribs - 1; i >= numAttsLowerBound; --i) {
            int[] coeff_inds;
            int num_attrs;
            int j;
            StringBuffer attName = new StringBuffer();
            double[] coeff_mags = new double[this.m_NumAttribs];
            for (j = 0; j < this.m_NumAttribs; ++j) {
                coeff_mags[j] = -Math.abs(this.m_Eigenvectors[j][this.m_SortedEigens[i]]);
            }
            int n = num_attrs = this.m_MaxAttrsInName > 0 ? Math.min(this.m_NumAttribs, this.m_MaxAttrsInName) : this.m_NumAttribs;
            if (this.m_NumAttribs > 0) {
                coeff_inds = Utils.sort(coeff_mags);
            } else {
                coeff_inds = new int[this.m_NumAttribs];
                for (j = 0; j < this.m_NumAttribs; ++j) {
                    coeff_inds[j] = j;
                }
            }
            for (j = 0; j < num_attrs; ++j) {
                double coeff_value = this.m_Eigenvectors[coeff_inds[j]][this.m_SortedEigens[i]];
                if (j > 0 && coeff_value >= 0.0) {
                    attName.append("+");
                }
                attName.append(Utils.doubleToString(coeff_value, 5, 3) + inputFormat.attribute(coeff_inds[j]).name());
            }
            if (num_attrs < this.m_NumAttribs) {
                attName.append("...");
            }
            attributes.addElement(new Attribute(attName.toString()));
            if ((cumulative += this.m_Eigenvalues[this.m_SortedEigens[i]]) / this.m_SumOfEigenValues >= this.m_CoverVariance) break;
        }
        if (this.m_HasClass) {
            attributes.addElement((Attribute)this.m_TrainCopy.classAttribute().copy());
        }
        Instances outputFormat = new Instances(this.m_TrainCopy.relationName() + "_principal components", attributes, 0);
        if (this.m_HasClass) {
            outputFormat.setClassIndex(outputFormat.numAttributes() - 1);
        }
        this.m_OutputNumAtts = outputFormat.numAttributes();
        return outputFormat;
    }

    protected void fillCovariance() throws Exception {
        if (!this.m_center) {
            this.fillCorrelation();
            return;
        }
        double[] att = new double[this.m_TrainInstances.numInstances()];
        this.m_centerFilter = new Center();
        this.m_centerFilter.setInputFormat(this.m_TrainInstances);
        this.m_TrainInstances = Filter.useFilter(this.m_TrainInstances, this.m_centerFilter);
        this.m_Correlation = new double[this.m_NumAttribs][this.m_NumAttribs];
        for (int i = 0; i < this.m_NumAttribs; ++i) {
            for (int j = 0; j < this.m_NumAttribs; ++j) {
                double cov = 0.0;
                for (int k = 0; k < this.m_NumInstances; ++k) {
                    if (i == j) {
                        cov += this.m_TrainInstances.instance(k).value(i) * this.m_TrainInstances.instance(k).value(i);
                        continue;
                    }
                    cov += this.m_TrainInstances.instance(k).value(i) * this.m_TrainInstances.instance(k).value(j);
                }
                this.m_Correlation[i][j] = cov /= (double)(this.m_TrainInstances.numInstances() - 1);
                this.m_Correlation[j][i] = cov;
            }
        }
    }

    protected void fillCorrelation() throws Exception {
        this.m_Correlation = new double[this.m_NumAttribs][this.m_NumAttribs];
        double[] att1 = new double[this.m_NumInstances];
        double[] att2 = new double[this.m_NumInstances];
        for (int i = 0; i < this.m_NumAttribs; ++i) {
            for (int j = 0; j < this.m_NumAttribs; ++j) {
                double corr;
                for (int k = 0; k < this.m_NumInstances; ++k) {
                    att1[k] = this.m_TrainInstances.instance(k).value(i);
                    att2[k] = this.m_TrainInstances.instance(k).value(j);
                }
                if (i == j) {
                    this.m_Correlation[i][j] = 1.0;
                    continue;
                }
                this.m_Correlation[i][j] = corr = Utils.correlation(att1, att2, this.m_NumInstances);
                this.m_Correlation[j][i] = corr;
            }
        }
        this.m_standardizeFilter = new Standardize();
        this.m_standardizeFilter.setInputFormat(this.m_TrainInstances);
        this.m_TrainInstances = Filter.useFilter(this.m_TrainInstances, this.m_standardizeFilter);
    }

    protected Instance convertInstance(Instance instance) throws Exception {
        int numAttsLowerBound;
        double[] newVals = new double[this.m_OutputNumAtts];
        Instance tempInst = (Instance)instance.copy();
        this.m_ReplaceMissingFilter.input(tempInst);
        this.m_ReplaceMissingFilter.batchFinished();
        tempInst = this.m_ReplaceMissingFilter.output();
        this.m_NominalToBinaryFilter.input(tempInst);
        this.m_NominalToBinaryFilter.batchFinished();
        tempInst = this.m_NominalToBinaryFilter.output();
        if (this.m_AttributeFilter != null) {
            this.m_AttributeFilter.input(tempInst);
            this.m_AttributeFilter.batchFinished();
            tempInst = this.m_AttributeFilter.output();
        }
        if (!this.m_center) {
            this.m_standardizeFilter.input(tempInst);
            this.m_standardizeFilter.batchFinished();
            tempInst = this.m_standardizeFilter.output();
        } else {
            this.m_centerFilter.input(tempInst);
            this.m_centerFilter.batchFinished();
            tempInst = this.m_centerFilter.output();
        }
        if (this.m_HasClass) {
            newVals[this.m_OutputNumAtts - 1] = instance.value(instance.classIndex());
        }
        if ((numAttsLowerBound = this.m_MaxAttributes > 0 ? this.m_NumAttribs - this.m_MaxAttributes : 0) < 0) {
            numAttsLowerBound = 0;
        }
        double cumulative = 0.0;
        for (int i = this.m_NumAttribs - 1; i >= numAttsLowerBound; --i) {
            double tempval = 0.0;
            for (int j = 0; j < this.m_NumAttribs; ++j) {
                tempval += this.m_Eigenvectors[j][this.m_SortedEigens[i]] * tempInst.value(j);
            }
            newVals[this.m_NumAttribs - i - 1] = tempval;
            if ((cumulative += this.m_Eigenvalues[this.m_SortedEigens[i]]) / this.m_SumOfEigenValues >= this.m_CoverVariance) break;
        }
        AbstractInstance result = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), newVals) : new DenseInstance(instance.weight(), newVals);
        return result;
    }

    protected void setup(Instances instances) throws Exception {
        int i;
        this.m_TrainInstances = new Instances(instances);
        this.m_TrainCopy = new Instances(this.m_TrainInstances, 0);
        this.m_ReplaceMissingFilter = new ReplaceMissingValues();
        this.m_ReplaceMissingFilter.setInputFormat(this.m_TrainInstances);
        this.m_TrainInstances = Filter.useFilter(this.m_TrainInstances, this.m_ReplaceMissingFilter);
        this.m_NominalToBinaryFilter = new NominalToBinary();
        this.m_NominalToBinaryFilter.setInputFormat(this.m_TrainInstances);
        this.m_TrainInstances = Filter.useFilter(this.m_TrainInstances, this.m_NominalToBinaryFilter);
        Vector<Integer> deleteCols = new Vector<Integer>();
        for (i = 0; i < this.m_TrainInstances.numAttributes(); ++i) {
            if (this.m_TrainInstances.numDistinctValues(i) > 1) continue;
            deleteCols.addElement(i);
        }
        if (this.m_TrainInstances.classIndex() >= 0) {
            this.m_HasClass = true;
            this.m_ClassIndex = this.m_TrainInstances.classIndex();
            deleteCols.addElement(new Integer(this.m_ClassIndex));
        }
        if (deleteCols.size() > 0) {
            this.m_AttributeFilter = new Remove();
            int[] todelete = new int[deleteCols.size()];
            for (i = 0; i < deleteCols.size(); ++i) {
                todelete[i] = (Integer)deleteCols.elementAt(i);
            }
            this.m_AttributeFilter.setAttributeIndicesArray(todelete);
            this.m_AttributeFilter.setInvertSelection(false);
            this.m_AttributeFilter.setInputFormat(this.m_TrainInstances);
            this.m_TrainInstances = Filter.useFilter(this.m_TrainInstances, this.m_AttributeFilter);
        }
        this.getCapabilities().testWithFail(this.m_TrainInstances);
        this.m_NumInstances = this.m_TrainInstances.numInstances();
        this.m_NumAttribs = this.m_TrainInstances.numAttributes();
        this.fillCovariance();
        Matrix corr = new Matrix(this.m_Correlation);
        EigenvalueDecomposition eig = corr.eig();
        Matrix V = eig.getV();
        double[][] v = new double[this.m_NumAttribs][this.m_NumAttribs];
        for (i = 0; i < v.length; ++i) {
            for (int j = 0; j < v[0].length; ++j) {
                v[i][j] = V.get(i, j);
            }
        }
        this.m_Eigenvectors = (double[][])v.clone();
        this.m_Eigenvalues = (double[])eig.getRealEigenvalues().clone();
        for (i = 0; i < this.m_Eigenvalues.length; ++i) {
            if (!(this.m_Eigenvalues[i] < 0.0)) continue;
            this.m_Eigenvalues[i] = 0.0;
        }
        this.m_SortedEigens = Utils.sort(this.m_Eigenvalues);
        this.m_SumOfEigenValues = Utils.sum(this.m_Eigenvalues);
        this.m_TransformedFormat = this.determineOutputFormat(this.m_TrainInstances);
        this.setOutputFormat(this.m_TransformedFormat);
        this.m_TrainInstances = null;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.m_Eigenvalues = null;
        this.m_OutputNumAtts = -1;
        this.m_AttributeFilter = null;
        this.m_NominalToBinaryFilter = null;
        this.m_SumOfEigenValues = 0.0;
        return false;
    }

    @Override
    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.isNewBatch()) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isFirstBatchDone()) {
            Instance inst = this.convertInstance(instance);
            inst.setDataset(this.getOutputFormat());
            this.push(inst);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    @Override
    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new NullPointerException("No input instance format defined");
        }
        Instances insts = this.getInputFormat();
        if (!this.isFirstBatchDone()) {
            this.setup(insts);
        }
        for (int i = 0; i < insts.numInstances(); ++i) {
            Instance inst = this.convertInstance(insts.instance(i));
            inst.setDataset(this.getOutputFormat());
            this.push(inst);
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8048 $");
    }

    public static void main(String[] args) {
        PrincipalComponents.runFilter(new PrincipalComponents(), args);
    }
}

