/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class NonSparseToSparse
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    static final long serialVersionUID = 4694489111366063852L;
    protected boolean m_encodeMissingAsZero = false;
    protected boolean m_insertDummyNominalFirstValue = false;

    public String globalInfo() {
        return "An instance filter that converts all incoming instances into sparse format.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.add(new Option("\tTreat missing values as zero.", "M", 0, "-M"));
        result.add(new Option("\tAdd a dummy first value for nominal attributes.", "F", 0, "-F"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.m_encodeMissingAsZero = Utils.getFlag('M', options);
        this.m_insertDummyNominalFirstValue = Utils.getFlag('F', options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.m_encodeMissingAsZero) {
            result.add("-M");
        }
        if (this.m_insertDummyNominalFirstValue) {
            result.add("-F");
        }
        return result.toArray(new String[result.size()]);
    }

    public void setTreatMissingValuesAsZero(boolean m) {
        this.m_encodeMissingAsZero = m;
    }

    public boolean getTreatMissingValuesAsZero() {
        return this.m_encodeMissingAsZero;
    }

    public String treatMissingValuesAsZeroTipText() {
        return "Treat missing values in the same way as zeros.";
    }

    public void setInsertDummyNominalFirstValue(boolean d) {
        this.m_insertDummyNominalFirstValue = d;
    }

    public boolean getInsertDummyNominalFirstValue() {
        return this.m_insertDummyNominalFirstValue;
    }

    public String insertDummyNominalFirstValueTipText() {
        return "Insert a dummy value before the first declared value for all nominal attributes. Useful when converting market basket data that has been encoded for Apriori to sparse format. Typically used in conjuction with treat missing values as zero.";
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        Instances instNew = instanceInfo;
        if (this.m_insertDummyNominalFirstValue) {
            FastVector<Attribute> atts = new FastVector<Attribute>();
            for (int i = 0; i < instanceInfo.numAttributes(); ++i) {
                if (instanceInfo.attribute(i).isNominal()) {
                    FastVector<String> labels = new FastVector<String>();
                    labels.addElement("_d");
                    for (int j = 0; j < instanceInfo.attribute(j).numValues(); ++j) {
                        labels.addElement(instanceInfo.attribute(i).value(j));
                    }
                    Attribute newAtt = new Attribute(instanceInfo.attribute(i).name(), labels);
                    newAtt.setWeight(instanceInfo.attribute(i).weight());
                    atts.addElement(newAtt);
                    continue;
                }
                atts.addElement(instanceInfo.attribute(i));
            }
            instNew = new Instances(instanceInfo.relationName(), atts, 0);
        }
        this.setOutputFormat(instNew);
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        int i;
        SparseInstance newInstance = null;
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_encodeMissingAsZero && !this.m_insertDummyNominalFirstValue) {
            Instance tempInst = (Instance)instance.copy();
            tempInst.setDataset(this.getInputFormat());
            for (i = 0; i < tempInst.numAttributes(); ++i) {
                if (!tempInst.isMissing(i)) continue;
                tempInst.setValue(i, 0.0);
            }
            instance = tempInst;
        }
        if (this.m_insertDummyNominalFirstValue) {
            double[] values = instance.toDoubleArray();
            for (i = 0; i < instance.numAttributes(); ++i) {
                if (instance.attribute(i).isNominal() && !Utils.isMissingValue(values[i])) {
                    int n = i;
                    values[n] = values[n] + 1.0;
                }
                if (!this.m_encodeMissingAsZero || !Utils.isMissingValue(values[i])) continue;
                values[i] = 0.0;
            }
            newInstance = new SparseInstance(instance.weight(), values);
            newInstance.setDataset(this.getOutputFormat());
            this.push(newInstance);
        } else {
            newInstance = new SparseInstance(instance);
            newInstance.setDataset(instance.dataset());
            this.push(newInstance);
        }
        return true;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8588 $");
    }

    public static void main(String[] argv) {
        NonSparseToSparse.runFilter(new NonSparseToSparse(), argv);
    }
}

