/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.Date;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordinatorCommand;
import org.apache.oozie.command.wf.KillCommand;
import org.apache.oozie.store.CoordinatorStore;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;

public class CoordKillCommand
extends CoordinatorCommand<Void> {
    private String jobId;
    private final XLog log = XLog.getLog(this.getClass());

    public CoordKillCommand(String id) {
        super("coord_kill", "coord_kill", 1, 1);
        this.jobId = ParamChecker.notEmpty(id, "id");
    }

    @Override
    protected Void call(CoordinatorStore store) throws StoreException, CommandException {
        try {
            CoordinatorJobBean coordJob = (CoordinatorJobBean)store.getEntityManager().find(CoordinatorJobBean.class, (Object)this.jobId);
            this.setLogInfo(coordJob);
            if (coordJob.getStatus() != Job.Status.SUCCEEDED || coordJob.getStatus() != Job.Status.FAILED) {
                coordJob.setEndTime(new Date());
                this.incrJobCounter(1);
                coordJob.setStatus(Job.Status.KILLED);
                List<CoordinatorActionBean> actionList = store.getActionsForCoordinatorJob(this.jobId, false);
                for (CoordinatorActionBean action : actionList) {
                    if (action.getStatus() == CoordinatorAction.Status.FAILED || action.getStatus() == CoordinatorAction.Status.TIMEDOUT || action.getStatus() == CoordinatorAction.Status.SUCCEEDED || action.getStatus() == CoordinatorAction.Status.KILLED) continue;
                    if (action.getExternalId() != null) {
                        this.queueCallable(new KillCommand(action.getExternalId()));
                    }
                    action.setStatus(CoordinatorAction.Status.KILLED);
                    store.updateCoordinatorAction(action);
                }
                store.updateCoordinatorJob(coordJob);
            } else {
                this.log.info("CoordKillCommand not killed - job either finished successfully or does not exist " + this.jobId);
            }
            return null;
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void execute(CoordinatorStore store) throws StoreException, CommandException {
        this.log.info("STARTED CoordKillCommand for jobId=" + this.jobId);
        try {
            if (this.lock(this.jobId)) {
                this.call(store);
            } else {
                this.queueCallable(new CoordKillCommand(this.jobId), 30000L);
                this.log.warn("CoordKillCommand lock was not acquired -  failed " + this.jobId + ". Requeing the same.");
            }
        }
        catch (InterruptedException e) {
            this.queueCallable(new CoordKillCommand(this.jobId), 30000L);
            this.log.warn("CoordKillCommand lock acquiring failed  with exception " + e.getMessage() + " for job id " + this.jobId + ". Requeing the same.");
        }
        finally {
            this.log.info("ENDED CoordKillCommand for jobId=" + this.jobId);
        }
        return null;
    }
}

