/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.Date;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.wf.ActionKillCommand;
import org.apache.oozie.command.wf.NotificationCommand;
import org.apache.oozie.command.wf.WorkflowCommand;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.store.WorkflowStore;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.db.SLADbOperations;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.LiteWorkflowInstance;

public class KillCommand
extends WorkflowCommand<Void> {
    private String id;
    private final XLog log = XLog.getLog(this.getClass());

    public KillCommand(String id) {
        super("kill", "kill", 1, 1);
        this.id = ParamChecker.notEmpty(id, "id");
    }

    @Override
    protected Void call(WorkflowStore store) throws StoreException, CommandException {
        try {
            this.log.info("In Workflow KillCommand.call() for jobId=" + this.id);
            WorkflowJobBean workflow = store.getWorkflow(this.id, false);
            this.setLogInfo(workflow);
            if (workflow.getStatus() == WorkflowJob.Status.PREP || workflow.getStatus() == WorkflowJob.Status.RUNNING || workflow.getStatus() == WorkflowJob.Status.SUSPENDED || workflow.getStatus() == WorkflowJob.Status.FAILED) {
                workflow.setEndTime(new Date());
                if (workflow.getStatus() != WorkflowJob.Status.FAILED) {
                    this.incrJobCounter(1);
                    workflow.setStatus(WorkflowJob.Status.KILLED);
                    SLADbOperations.writeStausEvent(workflow.getSlaXml(), workflow.getId(), store, SLAEvent.Status.KILLED, SLAEvent.SlaAppType.WORKFLOW_JOB);
                    workflow.getWorkflowInstance().kill();
                    WorkflowInstance wfInstance = workflow.getWorkflowInstance();
                    ((LiteWorkflowInstance)wfInstance).setStatus(WorkflowInstance.Status.KILLED);
                    workflow.setWorkflowInstance(wfInstance);
                }
                for (WorkflowActionBean action : store.getActionsForWorkflow(this.id, true)) {
                    if (action.getStatus() == WorkflowAction.Status.RUNNING || action.getStatus() == WorkflowAction.Status.DONE) {
                        action.setPending();
                        action.setStatus(WorkflowAction.Status.KILLED);
                        store.updateAction(action);
                        this.queueCallable(new ActionKillCommand(action.getId(), action.getType()));
                    }
                    if (action.getStatus() != WorkflowAction.Status.PREP && action.getStatus() != WorkflowAction.Status.START_RETRY && action.getStatus() != WorkflowAction.Status.START_MANUAL && action.getStatus() != WorkflowAction.Status.END_RETRY && action.getStatus() != WorkflowAction.Status.END_MANUAL) continue;
                    action.setStatus(WorkflowAction.Status.KILLED);
                    action.resetPending();
                    SLADbOperations.writeStausEvent(action.getSlaXml(), action.getId(), store, SLAEvent.Status.KILLED, SLAEvent.SlaAppType.WORKFLOW_ACTION);
                    store.updateAction(action);
                }
                store.updateWorkflow(workflow);
                this.queueCallable(new NotificationCommand(workflow));
            }
            return null;
        }
        catch (WorkflowException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    protected Void execute(WorkflowStore store) throws CommandException, StoreException {
        try {
            XLog.getLog(this.getClass()).debug("STARTED KillCommand for job " + this.id);
            if (this.lock(this.id)) {
                this.call(store);
            } else {
                this.queueCallable(new KillCommand(this.id), 30000L);
                XLog.getLog(this.getClass()).warn("KillCommand lock was not acquired - failed {0}", this.id);
            }
        }
        catch (InterruptedException e) {
            this.queueCallable(new KillCommand(this.id), 30000L);
            XLog.getLog(this.getClass()).warn("KillCommand lock was not acquired - interrupted exception failed {0}", this.id);
        }
        XLog.getLog(this.getClass()).debug("ENDED KillCommand for job " + this.id);
        return null;
    }
}

