/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3common;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.auth.profile.ProfilesConfigFile;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import java.io.File;
import java.util.Collection;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.pentaho.amazon.s3.S3Util;
import org.pentaho.s3common.S3CommonFileProvider;
import org.pentaho.s3common.S3CommonFileSystemConfigBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class S3CommonFileSystem
extends AbstractFileSystem {
    private String awsAccessKeyCache;
    private String awsSecretKeyCache;
    private AmazonS3 client;
    private static final Logger logger = LoggerFactory.getLogger(S3CommonFileSystem.class);

    protected S3CommonFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(S3CommonFileProvider.capabilities);
    }

    protected abstract FileObject createFile(AbstractFileName var1) throws Exception;

    public AmazonS3 getS3Client() {
        if (this.client == null && this.getFileSystemOptions() != null) {
            S3CommonFileSystemConfigBuilder s3CommonFileSystemConfigBuilder = new S3CommonFileSystemConfigBuilder(this.getFileSystemOptions());
            String accessKey = s3CommonFileSystemConfigBuilder.getAccessKey();
            String secretKey = s3CommonFileSystemConfigBuilder.getSecretKey();
            String sessionToken = s3CommonFileSystemConfigBuilder.getSessionToken();
            String region = s3CommonFileSystemConfigBuilder.getRegion();
            String credentialsFilePath = s3CommonFileSystemConfigBuilder.getCredentialsFile();
            String profileName = s3CommonFileSystemConfigBuilder.getProfileName();
            ProfileCredentialsProvider awsCredentialsProvider = null;
            Regions regions = Regions.DEFAULT_REGION;
            if (!S3Util.isEmpty(accessKey) && !S3Util.isEmpty(secretKey)) {
                Object awsCredentials = S3Util.isEmpty(sessionToken) ? new BasicAWSCredentials(accessKey, secretKey) : new BasicSessionCredentials(accessKey, secretKey, sessionToken);
                awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
                regions = S3Util.isEmpty(region) ? Regions.DEFAULT_REGION : Regions.fromName((String)region);
            } else if (!S3Util.isEmpty(credentialsFilePath)) {
                ProfilesConfigFile profilesConfigFile = new ProfilesConfigFile(credentialsFilePath);
                awsCredentialsProvider = new ProfileCredentialsProvider(profilesConfigFile, profileName);
            }
            this.client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().enableForceGlobalBucketAccess()).withRegion(regions)).withCredentials(awsCredentialsProvider)).build();
        }
        if (this.client == null || this.hasClientChangedCredentials()) {
            try {
                this.client = this.isRegionSet() ? (AmazonS3)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().enableForceGlobalBucketAccess()).build() : (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().enableForceGlobalBucketAccess()).withRegion(Regions.DEFAULT_REGION)).build();
                this.awsAccessKeyCache = System.getProperty("aws.accessKeyId");
                this.awsSecretKeyCache = System.getProperty("aws.secretKey");
            }
            catch (Throwable t) {
                logger.error("Could not get an S3Client", t);
            }
        }
        return this.client;
    }

    private boolean hasClientChangedCredentials() {
        return this.client != null && (S3Util.hasChanged(this.awsAccessKeyCache, System.getProperty("aws.accessKeyId")) || S3Util.hasChanged(this.awsSecretKeyCache, System.getProperty("aws.secretKey")));
    }

    private boolean isRegionSet() {
        if (System.getenv("AWS_REGION") != null || System.getenv("AWS_CONFIG_FILE") != null) {
            return true;
        }
        File awsConfigFolder = new File(System.getProperty("user.home") + File.separator + ".aws" + File.separator + "config");
        return awsConfigFolder.exists();
    }
}

