/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3common;

import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.vfs2.FileSystemOptions;
import org.pentaho.s3common.S3CommonFileSystem;
import org.pentaho.s3common.S3CommonWindowedSubstream;

public class S3CommonPipedOutputStream
extends PipedOutputStream {
    private static int PART_SIZE = 0x500000;
    private ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
    private boolean initialized = false;
    private boolean blockedUntilDone = true;
    private PipedInputStream pipedInputStream = new PipedInputStream();
    private S3AsyncTransferRunner s3AsyncTransferRunner;
    private S3CommonFileSystem fileSystem;
    private Future<Boolean> result = null;
    private String bucketId;
    private String key;

    public S3CommonPipedOutputStream(S3CommonFileSystem fileSystem, String bucketId, String key) throws IOException {
        try {
            this.pipedInputStream.connect(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.s3AsyncTransferRunner = new S3AsyncTransferRunner();
        this.bucketId = bucketId;
        this.key = key;
        this.fileSystem = fileSystem;
    }

    private void initializeWrite() {
        if (!this.initialized) {
            this.initialized = true;
            this.result = this.executor.submit(this.s3AsyncTransferRunner);
        }
    }

    public boolean isBlockedUntilDone() {
        return this.blockedUntilDone;
    }

    public void setBlockedUntilDone(boolean blockedUntilDone) {
        this.blockedUntilDone = blockedUntilDone;
    }

    @Override
    public void write(int b) throws IOException {
        this.initializeWrite();
        super.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.initializeWrite();
        super.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.initialized && this.isBlockedUntilDone()) {
            while (!this.result.isDone()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.executor.shutdown();
    }

    class S3AsyncTransferRunner
    implements Callable<Boolean> {
        S3AsyncTransferRunner() {
        }

        @Override
        public Boolean call() throws Exception {
            boolean returnVal = true;
            ArrayList<PartETag> partETags = new ArrayList<PartETag>();
            FileSystemOptions fsOpts = S3CommonPipedOutputStream.this.fileSystem.getFileSystemOptions();
            InitiateMultipartUploadRequest initRequest = new InitiateMultipartUploadRequest(S3CommonPipedOutputStream.this.bucketId, S3CommonPipedOutputStream.this.key);
            InitiateMultipartUploadResult initResponse = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream(PART_SIZE);
                 BufferedInputStream bis = new BufferedInputStream(S3CommonPipedOutputStream.this.pipedInputStream, PART_SIZE);){
                UploadPartRequest uploadRequest;
                S3CommonWindowedSubstream s3is;
                initResponse = S3CommonPipedOutputStream.this.fileSystem.getS3Client().initiateMultipartUpload(initRequest);
                byte[] tmpBuffer = new byte[PART_SIZE];
                int read = 0;
                long offset = 0L;
                int totalRead = 0;
                int partNum = 1;
                while ((read = bis.read(tmpBuffer)) >= 0) {
                    if (read > 0) {
                        baos.write(tmpBuffer, 0, read);
                        totalRead += read;
                    }
                    if (totalRead <= PART_SIZE) continue;
                    s3is = new S3CommonWindowedSubstream(baos.toByteArray());
                    uploadRequest = new UploadPartRequest().withBucketName(S3CommonPipedOutputStream.this.bucketId).withKey(S3CommonPipedOutputStream.this.key).withUploadId(initResponse.getUploadId()).withPartNumber(partNum++).withFileOffset(offset).withPartSize((long)totalRead).withInputStream((InputStream)s3is);
                    partETags.add(S3CommonPipedOutputStream.this.fileSystem.getS3Client().uploadPart(uploadRequest).getPartETag());
                    offset += (long)totalRead;
                    totalRead = 0;
                    baos.reset();
                }
                s3is = new S3CommonWindowedSubstream(baos.toByteArray());
                uploadRequest = new UploadPartRequest().withBucketName(S3CommonPipedOutputStream.this.bucketId).withKey(S3CommonPipedOutputStream.this.key).withUploadId(initResponse.getUploadId()).withPartNumber(partNum++).withFileOffset(offset).withPartSize((long)totalRead).withInputStream((InputStream)s3is).withLastPart(true);
                partETags.add(S3CommonPipedOutputStream.this.fileSystem.getS3Client().uploadPart(uploadRequest).getPartETag());
                CompleteMultipartUploadRequest compRequest = new CompleteMultipartUploadRequest(S3CommonPipedOutputStream.this.bucketId, S3CommonPipedOutputStream.this.key, initResponse.getUploadId(), partETags);
                S3CommonPipedOutputStream.this.fileSystem.getS3Client().completeMultipartUpload(compRequest);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (initResponse == null) {
                    S3CommonPipedOutputStream.this.close();
                } else {
                    S3CommonPipedOutputStream.this.fileSystem.getS3Client().abortMultipartUpload(new AbortMultipartUploadRequest(S3CommonPipedOutputStream.this.bucketId, S3CommonPipedOutputStream.this.key, initResponse.getUploadId()));
                }
                returnVal = false;
            }
            return returnVal;
        }
    }
}

