/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.big.data.bundles.impl.shim.hbase;

import com.pentaho.big.data.bundles.impl.shim.hbase.ByteConversionUtilImpl;
import com.pentaho.big.data.bundles.impl.shim.hbase.IOExceptionUtil;
import com.pentaho.big.data.bundles.impl.shim.hbase.connectionPool.HBaseConnectionHandle;
import com.pentaho.big.data.bundles.impl.shim.hbase.connectionPool.HBaseConnectionPool;
import com.pentaho.big.data.bundles.impl.shim.hbase.mapping.MappingFactoryImpl;
import com.pentaho.big.data.bundles.impl.shim.hbase.meta.HBaseValueMetaInterfaceFactoryImpl;
import com.pentaho.big.data.bundles.impl.shim.hbase.table.HBaseTableImpl;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.hadoop.shim.api.hbase.ByteConversionUtil;
import org.pentaho.hadoop.shim.api.hbase.HBaseConnection;
import org.pentaho.hadoop.shim.api.internal.hbase.HBaseBytesUtilShim;
import org.pentaho.hadoop.shim.spi.HBaseShim;

public class HBaseConnectionImpl
implements HBaseConnection {
    private final HBaseConnectionPool hBaseConnectionPool;
    private final HBaseBytesUtilShim hBaseBytesUtilShim;

    public HBaseConnectionImpl(HBaseShim hBaseShim, HBaseBytesUtilShim hBaseBytesUtilShim, Properties connectionProps, LogChannelInterface logChannelInterface) throws IOException {
        this(hBaseBytesUtilShim, new HBaseConnectionPool(hBaseShim, connectionProps, logChannelInterface));
    }

    public HBaseConnectionImpl(HBaseBytesUtilShim hBaseBytesUtilShim, HBaseConnectionPool hBaseConnectionPool) {
        this.hBaseBytesUtilShim = hBaseBytesUtilShim;
        this.hBaseConnectionPool = hBaseConnectionPool;
    }

    public HBaseTableImpl getTable(String tableName) throws IOException {
        return new HBaseTableImpl(this.hBaseConnectionPool, new HBaseValueMetaInterfaceFactoryImpl(this.hBaseBytesUtilShim), this.hBaseBytesUtilShim, tableName);
    }

    public void checkHBaseAvailable() throws IOException {
        try (HBaseConnectionHandle hBaseConnectionHandle = this.hBaseConnectionPool.getConnectionHandle();){
            hBaseConnectionHandle.getConnection().checkHBaseAvailable();
        }
        catch (Exception e) {
            throw IOExceptionUtil.wrapIfNecessary(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> listTableNames() throws IOException {
        try (HBaseConnectionHandle hBaseConnectionHandle = this.hBaseConnectionPool.getConnectionHandle();){
            List<String> list = hBaseConnectionHandle.getConnection().listTableNames();
            return list;
        }
        catch (Exception e) {
            throw IOExceptionUtil.wrapIfNecessary(e);
        }
    }

    public MappingFactoryImpl getMappingFactory() {
        return new MappingFactoryImpl(this.hBaseBytesUtilShim, this.getHBaseValueMetaInterfaceFactory());
    }

    public HBaseValueMetaInterfaceFactoryImpl getHBaseValueMetaInterfaceFactory() {
        return new HBaseValueMetaInterfaceFactoryImpl(this.hBaseBytesUtilShim);
    }

    public ByteConversionUtil getByteConversionUtil() {
        return new ByteConversionUtilImpl(this.hBaseBytesUtilShim);
    }

    public void close() throws IOException {
        this.hBaseConnectionPool.close();
    }
}

