/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.big.data.bundles.impl.shim.hbase;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.NavigableMap;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Result;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.hadoop.shim.api.internal.Configuration;
import org.pentaho.hadoop.shim.api.internal.hbase.ColumnFilter;
import org.pentaho.hadoop.shim.api.internal.hbase.HBaseBytesUtilShim;
import org.pentaho.hadoop.shim.api.internal.hbase.HBaseValueMeta;
import org.pentaho.hadoop.shim.spi.HBaseConnection;

public class HBaseConnectionWrapper
implements HBaseConnection {
    private final HBaseConnection delegate;
    private final HBaseConnection realImpl;
    private final Field resultSetRowField;

    public HBaseConnectionWrapper(HBaseConnection delegate) {
        this.delegate = delegate;
        this.realImpl = HBaseConnectionWrapper.findRealImpl(delegate);
        this.resultSetRowField = HBaseConnectionWrapper.getResultSetRowField(this.realImpl);
        this.resultSetRowField.setAccessible(true);
    }

    @Override
    public HBaseBytesUtilShim getBytesUtil() throws Exception {
        return this.delegate.getBytesUtil();
    }

    @Override
    public void configureConnection(Properties properties, List<String> list) throws Exception {
        this.delegate.configureConnection(properties, list);
    }

    @Override
    public void checkHBaseAvailable() throws Exception {
        this.delegate.checkHBaseAvailable();
    }

    @Override
    public List<String> listTableNames() throws Exception {
        return this.delegate.listTableNames();
    }

    @Override
    public boolean tableExists(String s) throws Exception {
        return this.delegate.tableExists(s);
    }

    @Override
    public boolean isTableDisabled(String s) throws Exception {
        return this.delegate.isTableDisabled(s);
    }

    @Override
    public boolean isTableAvailable(String s) throws Exception {
        return this.delegate.isTableAvailable(s);
    }

    @Override
    public void disableTable(String s) throws Exception {
        this.delegate.disableTable(s);
    }

    @Override
    public void enableTable(String s) throws Exception {
        this.delegate.enableTable(s);
    }

    @Override
    public void deleteTable(String s) throws Exception {
        this.delegate.deleteTable(s);
    }

    @Override
    public void executeTargetTableDelete(byte[] bytes) throws Exception {
        this.delegate.executeTargetTableDelete(bytes);
    }

    @Override
    public void createTable(String s, List<String> list, Properties properties) throws Exception {
        this.delegate.createTable(s, list, properties);
    }

    @Override
    public List<String> getTableFamiles(String s) throws Exception {
        return this.delegate.getTableFamiles(s);
    }

    @Override
    public void newSourceTable(String s) throws Exception {
        this.delegate.newSourceTable(s);
    }

    @Override
    public boolean sourceTableRowExists(byte[] bytes) throws Exception {
        return this.delegate.sourceTableRowExists(bytes);
    }

    @Override
    public void newSourceTableScan(byte[] bytes, byte[] bytes1, int i) throws Exception {
        this.delegate.newSourceTableScan(bytes, bytes1, i);
    }

    @Override
    public void newTargetTablePut(byte[] bytes, boolean b) throws Exception {
        this.delegate.newTargetTablePut(bytes, b);
    }

    @Override
    public boolean targetTableIsAutoFlush() throws Exception {
        return this.delegate.targetTableIsAutoFlush();
    }

    @Override
    public void executeTargetTablePut() throws Exception {
        this.delegate.executeTargetTablePut();
    }

    @Override
    public void flushCommitsTargetTable() throws Exception {
        this.delegate.flushCommitsTargetTable();
    }

    @Override
    public void addColumnToTargetPut(String s, String s1, boolean b, byte[] bytes) throws Exception {
        this.delegate.addColumnToTargetPut(s, s1, b, bytes);
    }

    @Override
    public void addColumnFilterToScan(ColumnFilter columnFilter, HBaseValueMeta hBaseValueMeta, VariableSpace variableSpace, boolean b) throws Exception {
        this.delegate.addColumnFilterToScan(columnFilter, hBaseValueMeta, variableSpace, b);
    }

    @Override
    public void addColumnToScan(String s, String s1, boolean b) throws Exception {
        this.delegate.addColumnToScan(s, s1, b);
    }

    @Override
    public void executeSourceTableScan() throws Exception {
        this.delegate.executeSourceTableScan();
    }

    @Override
    public boolean resultSetNextRow() throws Exception {
        return this.delegate.resultSetNextRow();
    }

    @Override
    public byte[] getRowKey(Object o) throws Exception {
        return this.delegate.getRowKey(o);
    }

    @Override
    public byte[] getResultSetCurrentRowKey() throws Exception {
        return this.delegate.getResultSetCurrentRowKey();
    }

    @Override
    public byte[] getRowColumnLatest(Object o, String s, String s1, boolean b) throws Exception {
        return this.delegate.getRowColumnLatest(o, s, s1, b);
    }

    @Override
    public boolean checkForHBaseRow(Object o) {
        return this.delegate.checkForHBaseRow(o);
    }

    @Override
    public byte[] getResultSetCurrentRowColumnLatest(String s, String s1, boolean b) throws Exception {
        return this.delegate.getResultSetCurrentRowColumnLatest(s, s1, b);
    }

    @Override
    public NavigableMap<byte[], byte[]> getRowFamilyMap(Object o, String s) throws Exception {
        return this.delegate.getRowFamilyMap(o, s);
    }

    @Override
    public NavigableMap<byte[], byte[]> getResultSetCurrentRowFamilyMap(String s) throws Exception {
        return this.delegate.getResultSetCurrentRowFamilyMap(s);
    }

    @Override
    public NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> getRowMap(Object o) throws Exception {
        return this.delegate.getRowMap(o);
    }

    @Override
    public NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> getResultSetCurrentRowMap() throws Exception {
        return this.delegate.getResultSetCurrentRowMap();
    }

    @Override
    public void closeSourceTable() throws Exception {
        this.delegate.closeSourceTable();
    }

    @Override
    public void closeSourceResultSet() throws Exception {
        this.delegate.closeSourceResultSet();
    }

    @Override
    public void newTargetTable(String s, Properties properties) throws Exception {
        this.delegate.newTargetTable(s, properties);
    }

    @Override
    public void closeTargetTable() throws Exception {
        this.delegate.closeTargetTable();
    }

    @Override
    public boolean isImmutableBytesWritable(Object o) {
        return this.delegate.isImmutableBytesWritable(o);
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }

    @Override
    public void obtainAuthTokenForJob(Configuration conf) throws Exception {
        this.delegate.obtainAuthTokenForJob(conf);
    }

    public Result getCurrentResult() {
        try {
            return (Result)this.resultSetRowField.get(this.realImpl);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @VisibleForTesting
    static Field getResultSetRowField(Object o) {
        return HBaseConnectionWrapper.getField(o.getClass(), "m_currentResultSetRow");
    }

    @VisibleForTesting
    static Field getField(Class<?> clazz, String fieldName) {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            try {
                return current.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    @VisibleForTesting
    static HBaseConnection findRealImpl(Object hBaseConnection) {
        Class<?> hBaseConnectionClass = hBaseConnection.getClass();
        if (Proxy.isProxyClass(hBaseConnectionClass)) {
            return HBaseConnectionWrapper.unwrapProxy(hBaseConnection);
        }
        if (hBaseConnection instanceof HBaseConnection) {
            Object delegate;
            if (HBaseConnectionWrapper.getResultSetRowField(hBaseConnection) != null) {
                return (HBaseConnection)hBaseConnection;
            }
            Field delegateField = HBaseConnectionWrapper.getField(hBaseConnectionClass, "delegate");
            if (delegateField != null && ((delegate = HBaseConnectionWrapper.getFieldValue(delegateField, hBaseConnection)) instanceof HBaseConnection || Proxy.isProxyClass(delegate.getClass()))) {
                return HBaseConnectionWrapper.findRealImpl(delegate);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static Object getFieldValue(Field field, Object object) {
        boolean setAccessible = !field.isAccessible();
        try {
            if (setAccessible) {
                field.setAccessible(true);
            }
            Object object2 = field.get(object);
            return object2;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        finally {
            if (setAccessible) {
                field.setAccessible(false);
            }
        }
        return null;
    }

    @VisibleForTesting
    static HBaseConnection unwrapProxy(Object proxy) {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(proxy);
        for (Class<?> clazz = invocationHandler.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                Object value = HBaseConnectionWrapper.getFieldValue(field, invocationHandler);
                if (!(value instanceof HBaseConnection)) continue;
                return HBaseConnectionWrapper.findRealImpl(value);
            }
        }
        return null;
    }

    @VisibleForTesting
    Field getResultSetRowField() {
        return this.resultSetRowField;
    }

    @VisibleForTesting
    HBaseConnection getRealImpl() {
        return this.realImpl;
    }
}

