/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.big.data.bundles.impl.shim.hive;

import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.pentaho.big.data.api.shims.LegacyShimLocator;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.jdbc.JdbcUrl;
import org.pentaho.hadoop.shim.api.jdbc.JdbcUrlParser;
import org.pentaho.hadoop.shim.common.DriverProxyInvocationChain;

public class HiveDriver
implements Driver {
    protected static final String SIMBA_SPECIFIC_URL_PARAMETER = "AuthMech=";
    public static final String SQL_STATE_NOT_SUPPORTED = "0A000";
    protected final Driver delegate;
    private final boolean defaultConfiguration;
    protected final JdbcUrlParser jdbcUrlParser;
    protected final String hadoopConfigurationId;

    public HiveDriver(JdbcUrlParser jdbcUrlParser, String className, String shimVersion) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        this(jdbcUrlParser, className, shimVersion, "hive2");
    }

    public HiveDriver(JdbcUrlParser jdbcUrlParser, String className, String shimVersion, String driverType) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Driver driverClass = null;
        boolean driverFound = false;
        try {
            driverClass = (Driver)Class.forName(className).newInstance();
            driverFound = true;
        }
        catch (ClassNotFoundException e) {
            driverClass = (Driver)Class.forName("org.apache.hive.jdbc.HiveDriver").newInstance();
        }
        this.hadoopConfigurationId = driverFound ? shimVersion : null;
        this.delegate = DriverProxyInvocationChain.getProxy(Driver.class, driverClass);
        this.defaultConfiguration = true;
        this.jdbcUrlParser = jdbcUrlParser;
    }

    public HiveDriver(Driver delegate, String hadoopConfigurationId, boolean defaultConfiguration, JdbcUrlParser jdbcUrlParser) {
        this.delegate = delegate;
        this.hadoopConfigurationId = hadoopConfigurationId;
        this.defaultConfiguration = defaultConfiguration;
        this.jdbcUrlParser = jdbcUrlParser;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        NamedCluster namedCluster;
        JdbcUrl jdbcUrl;
        if (!this.checkBeforeAccepting(url)) {
            return null;
        }
        Driver driver = this.checkBeforeCallActiveDriver(url);
        try {
            jdbcUrl = this.jdbcUrlParser.parse(url);
        }
        catch (URISyntaxException e1) {
            throw new SQLException("Unable to parse jdbc url: " + url, e1);
        }
        try {
            namedCluster = jdbcUrl.getNamedCluster();
        }
        catch (Exception e) {
            return null;
        }
        if (!this.acceptsURL(url, driver, namedCluster)) {
            return null;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Connection hiveConn;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Connection connection = hiveConn = this.doConnect(driver, jdbcUrl, info);
            return connection;
        }
        catch (Exception ex) {
            Throwable cause = ex;
            do {
                if (!(cause instanceof SQLException) || !SQL_STATE_NOT_SUPPORTED.equals(((SQLException)cause).getSQLState())) continue;
                Connection connection = null;
                return connection;
            } while ((cause = cause.getCause()) != null);
            throw ex;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public Connection doConnect(Driver driver, JdbcUrl url, Properties info) throws SQLException {
        return driver.connect(url.toString().replaceFirst("pentahoNamedCluster=[^;]*;", ""), info);
    }

    @Override
    public final boolean acceptsURL(String url) {
        try {
            JdbcUrl jdbcUrl = this.jdbcUrlParser.parse(url);
            NamedCluster namedCluster = jdbcUrl.getNamedCluster();
            return this.acceptsURL(url, this.checkBeforeCallActiveDriver(url), namedCluster);
        }
        catch (Exception e) {
            return false;
        }
    }

    private final boolean acceptsURL(String url, Driver driver, NamedCluster namedCluster) throws SQLException {
        if (!this.defaultConfiguration) {
            return false;
        }
        if (driver == null) {
            return false;
        }
        try {
            return this.isRequiredShim(namedCluster, url) && driver.acceptsURL(url);
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected boolean isRequiredShim(NamedCluster namedCluster, String url) {
        boolean useThisShim = false;
        useThisShim = namedCluster != null && namedCluster.getShimIdentifier() != null ? this.hadoopConfigurationId != null && this.hadoopConfigurationId.equals(namedCluster.getShimIdentifier()) : this.hadoopConfigurationId.equals(this.getLegacyDefaultShimName());
        return useThisShim;
    }

    private String getLegacyDefaultShimName() {
        String defaultShimName = null;
        try {
            defaultShimName = LegacyShimLocator.getLegacyDefaultShimName();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return defaultShimName;
    }

    protected Driver checkBeforeCallActiveDriver(String url) throws SQLException {
        if (url.contains(SIMBA_SPECIFIC_URL_PARAMETER) || !this.checkBeforeAccepting(url)) {
            return null;
        }
        return this.delegate;
    }

    protected boolean checkBeforeAccepting(String url) {
        return this.hadoopConfigurationId != null && url.matches(".+:hive2:.*");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Driver driverDelegate = this.delegate;
        if (driverDelegate == null) {
            return null;
        }
        return driverDelegate.getPropertyInfo(url, info);
    }

    @Override
    public int getMajorVersion() {
        Driver driverDelegate = this.delegate;
        if (driverDelegate == null) {
            return -1;
        }
        return driverDelegate.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        Driver driverDelegate = this.delegate;
        if (driverDelegate == null) {
            return -1;
        }
        return driverDelegate.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        Driver driverDelegate = this.delegate;
        if (driverDelegate == null) {
            return false;
        }
        try {
            return driverDelegate.jdbcCompliant();
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        Driver driverDelegate = this.delegate;
        if (driverDelegate == null) {
            return null;
        }
        try {
            return driverDelegate.getParentLogger();
        }
        catch (Throwable e) {
            if (e instanceof SQLFeatureNotSupportedException) {
                throw e;
            }
            throw new SQLFeatureNotSupportedException(e);
        }
    }
}

