/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.parquet.delegate.apache;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.Type;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.plugins.IValueMetaConverter;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.row.value.ValueMetaBigNumber;
import org.pentaho.di.core.row.value.ValueMetaBinary;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaConversionException;
import org.pentaho.di.core.row.value.ValueMetaConverter;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaInternetAddress;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.row.value.ValueMetaTimestamp;
import org.pentaho.hadoop.shim.api.format.IParquetInputField;
import org.pentaho.hadoop.shim.api.format.ParquetSpec;
import org.pentaho.hadoop.shim.common.format.parquet.ParquetInputField;

public class ParquetConverter {
    public static final int PARQUET_JOB_ID = Integer.MAX_VALUE;
    public static final String PARQUET_SCHEMA_CONF_KEY = "PentahoParquetSchema";
    private final List<? extends IParquetInputField> inputFields;

    public ParquetConverter(List<? extends IParquetInputField> inputFields) {
        this.inputFields = inputFields;
    }

    public static List<IParquetInputField> buildInputFields(MessageType schema) {
        ArrayList<IParquetInputField> inputFields = new ArrayList<IParquetInputField>();
        for (Type type : schema.getFields()) {
            if (!type.isPrimitive()) continue;
            inputFields.add(ParquetConverter.convertField(type));
        }
        return inputFields;
    }

    private static IParquetInputField convertField(Type t) {
        OriginalType originalType = t.getOriginalType();
        ParquetSpec.DataType dataType = null;
        int scale = 0;
        int precision = 0;
        block0 : switch (t.asPrimitiveType().getPrimitiveTypeName()) {
            case BINARY: {
                if (originalType == null) {
                    dataType = ParquetSpec.DataType.BINARY;
                    break;
                }
                switch (originalType) {
                    case DECIMAL: {
                        dataType = ParquetSpec.DataType.DECIMAL;
                        precision = t.asPrimitiveType().getDecimalMetadata().getPrecision();
                        scale = t.asPrimitiveType().getDecimalMetadata().getScale();
                        break block0;
                    }
                    case UTF8: {
                        dataType = ParquetSpec.DataType.UTF8;
                        break block0;
                    }
                    case ENUM: {
                        dataType = ParquetSpec.DataType.ENUM;
                        break block0;
                    }
                }
                dataType = ParquetSpec.DataType.BINARY;
                break;
            }
            case BOOLEAN: {
                dataType = ParquetSpec.DataType.BOOLEAN;
                break;
            }
            case DOUBLE: {
                dataType = ParquetSpec.DataType.DOUBLE;
                break;
            }
            case FLOAT: {
                dataType = ParquetSpec.DataType.FLOAT;
                break;
            }
            case INT32: {
                if (originalType == null) {
                    dataType = ParquetSpec.DataType.INT_32;
                    break;
                }
                switch (originalType) {
                    case DECIMAL: {
                        dataType = ParquetSpec.DataType.DECIMAL_INT_32;
                        precision = t.asPrimitiveType().getDecimalMetadata().getPrecision();
                        scale = t.asPrimitiveType().getDecimalMetadata().getScale();
                        break block0;
                    }
                    case DATE: {
                        dataType = ParquetSpec.DataType.DATE;
                        break block0;
                    }
                    case INT_8: {
                        dataType = ParquetSpec.DataType.INT_8;
                        break block0;
                    }
                    case INT_16: {
                        dataType = ParquetSpec.DataType.INT_8;
                        break block0;
                    }
                    case INT_32: {
                        dataType = ParquetSpec.DataType.INT_32;
                        break block0;
                    }
                    case UINT_8: {
                        dataType = ParquetSpec.DataType.UINT_8;
                        break block0;
                    }
                    case UINT_16: {
                        dataType = ParquetSpec.DataType.UINT_16;
                        break block0;
                    }
                    case UINT_32: {
                        dataType = ParquetSpec.DataType.UINT_32;
                        break block0;
                    }
                    case TIME_MILLIS: {
                        dataType = ParquetSpec.DataType.TIME_MILLIS;
                        break block0;
                    }
                }
                dataType = ParquetSpec.DataType.INT_32;
                break;
            }
            case INT64: {
                if (originalType == null) {
                    dataType = ParquetSpec.DataType.INT_64;
                    break;
                }
                switch (originalType) {
                    case DECIMAL: {
                        dataType = ParquetSpec.DataType.DECIMAL_INT_64;
                        precision = t.asPrimitiveType().getDecimalMetadata().getPrecision();
                        scale = t.asPrimitiveType().getDecimalMetadata().getScale();
                        break block0;
                    }
                    case TIMESTAMP_MILLIS: {
                        dataType = ParquetSpec.DataType.TIMESTAMP_MILLIS;
                        break block0;
                    }
                }
                dataType = ParquetSpec.DataType.INT_64;
                break;
            }
            case INT96: {
                dataType = ParquetSpec.DataType.INT_96;
                break;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                if (originalType == null) {
                    dataType = ParquetSpec.DataType.FIXED_LEN_BYTE_ARRAY;
                    break;
                }
                switch (originalType) {
                    case DECIMAL: {
                        dataType = ParquetSpec.DataType.DECIMAL_FIXED_LEN_BYTE_ARRAY;
                        precision = t.asPrimitiveType().getDecimalMetadata().getPrecision();
                        scale = t.asPrimitiveType().getDecimalMetadata().getScale();
                        break block0;
                    }
                }
                dataType = ParquetSpec.DataType.FIXED_LEN_BYTE_ARRAY;
                break;
            }
            default: {
                dataType = ParquetSpec.DataType.NULL;
            }
        }
        ParquetInputField field = new ParquetInputField();
        field.setPentahoFieldName(t.getName());
        field.setFormatFieldName(t.getName());
        field.setPentahoType(dataType.getPdiType());
        field.setParquetType(dataType);
        field.setPrecision(precision);
        field.setScale(scale);
        return field;
    }

    public static class MyGroupConverter
    extends GroupConverter {
        private final RowMeta fields = new RowMeta();
        protected RowMetaAndData current;
        private final Converter[] converters;
        private int count = 0;
        private final IValueMetaConverter valueMetaConverter = new ValueMetaConverter();
        private static final Logger logger = Logger.getLogger(MyGroupConverter.class);

        private Object convertFromSourceToTargetType(IValueMetaConverter valueMetaConverter, Object stagingValue, IParquetInputField f) {
            try {
                String dateFormatStr = f.getStringFormat();
                if (dateFormatStr == null || dateFormatStr.trim().length() == 0) {
                    dateFormatStr = ValueMetaBase.DEFAULT_DATE_FORMAT_MASK;
                }
                valueMetaConverter.setDatePattern(new SimpleDateFormat(dateFormatStr));
                return valueMetaConverter.convertFromSourceToTargetDataType(f.getParquetType().getPdiType(), f.getPentahoType(), stagingValue);
            }
            catch (ValueMetaConversionException e) {
                logger.error((Object)e);
                return null;
            }
        }

        private void addValueMeta(int pdiType, String pentahoFieldName) {
            switch (pdiType) {
                case 8: {
                    this.fields.addValueMeta((ValueMetaInterface)new ValueMetaBinary(pentahoFieldName));
                    break;
                }
                case 6: {
                    this.fields.addValueMeta((ValueMetaInterface)new ValueMetaBigNumber(pentahoFieldName));
                    break;
                }
                case 4: {
                    this.fields.addValueMeta((ValueMetaInterface)new ValueMetaBoolean(pentahoFieldName));
                    break;
                }
                case 3: {
                    this.fields.addValueMeta((ValueMetaInterface)new ValueMetaDate(pentahoFieldName));
                    break;
                }
                case 10: {
                    this.fields.addValueMeta((ValueMetaInterface)new ValueMetaInternetAddress(pentahoFieldName));
                    break;
                }
                case 5: {
                    this.fields.addValueMeta((ValueMetaInterface)new ValueMetaInteger(pentahoFieldName));
                    break;
                }
                case 1: {
                    this.fields.addValueMeta((ValueMetaInterface)new ValueMetaNumber(pentahoFieldName));
                    break;
                }
                case 2: {
                    this.fields.addValueMeta((ValueMetaInterface)new ValueMetaString(pentahoFieldName));
                    break;
                }
                case 9: {
                    this.fields.addValueMeta((ValueMetaInterface)new ValueMetaTimestamp(pentahoFieldName));
                }
            }
        }

        public MyGroupConverter(ParquetConverter converter) {
            for (IParquetInputField f : converter.inputFields) {
                if (f.getFormatFieldName() == null) continue;
                ++this.count;
            }
            this.converters = new Converter[this.count];
            int i = 0;
            for (final IParquetInputField f : converter.inputFields) {
                if (f.getFormatFieldName() == null) continue;
                final int index = i;
                this.addValueMeta(f.getPentahoType(), f.getPentahoFieldName());
                switch (f.getParquetType().getPdiType()) {
                    case 1: {
                        this.converters[i] = new PrimitiveConverter(){

                            public void addDouble(double value) {
                                current.getData()[index] = value;
                                current.getData()[index] = this.convertFromSourceToTargetType(valueMetaConverter, current.getData()[index], f);
                                this.updateValueMeta(index, f);
                            }

                            public void addFloat(float value) {
                                current.getData()[index] = new BigDecimal(String.valueOf(value)).doubleValue();
                                current.getData()[index] = this.convertFromSourceToTargetType(valueMetaConverter, current.getData()[index], f);
                                this.updateValueMeta(index, f);
                            }
                        };
                        break;
                    }
                    case 5: {
                        this.converters[i] = new PrimitiveConverter(){

                            public void addInt(int value) {
                                current.getData()[index] = (long)value;
                                current.getData()[index] = this.convertFromSourceToTargetType(valueMetaConverter, current.getData()[index], f);
                            }

                            public void addLong(long value) {
                                current.getData()[index] = value;
                                current.getData()[index] = this.convertFromSourceToTargetType(valueMetaConverter, current.getData()[index], f);
                                this.updateValueMeta(index, f);
                            }
                        };
                        break;
                    }
                    case 6: {
                        this.converters[i] = new PrimitiveConverter(){

                            public void addBinary(Binary value) {
                                current.getData()[index] = MyGroupConverter.binaryToDecimal(value, f.getPrecision(), f.getScale());
                                current.getData()[index] = this.convertFromSourceToTargetType(valueMetaConverter, current.getData()[index], f);
                                this.updateValueMeta(index, f);
                            }

                            public void addInt(int value) {
                                current.getData()[index] = new BigDecimal(BigInteger.valueOf(value), f.getScale());
                                current.getData()[index] = this.convertFromSourceToTargetType(valueMetaConverter, current.getData()[index], f);
                                this.updateValueMeta(index, f);
                            }

                            public void addLong(long value) {
                                current.getData()[index] = new BigDecimal(BigInteger.valueOf(value), f.getScale());
                                current.getData()[index] = this.convertFromSourceToTargetType(valueMetaConverter, current.getData()[index], f);
                                this.updateValueMeta(index, f);
                            }
                        };
                        break;
                    }
                    case 2: {
                        this.converters[i] = new PrimitiveConverter(){

                            public void addBinary(Binary value) {
                                current.getData()[index] = value.toStringUsingUTF8();
                                current.getData()[index] = this.convertFromSourceToTargetType(valueMetaConverter, current.getData()[index], f);
                                this.updateValueMeta(index, f);
                            }
                        };
                        break;
                    }
                    case 4: {
                        this.converters[i] = new PrimitiveConverter(){

                            public void addBoolean(boolean value) {
                                current.getData()[index] = value;
                                current.getData()[index] = this.convertFromSourceToTargetType(valueMetaConverter, current.getData()[index], f);
                                this.updateValueMeta(index, f);
                            }
                        };
                        break;
                    }
                    case 7: {
                        this.converters[i] = new PrimitiveConverter(){

                            public void addBinary(Binary value) {
                                current.getData()[index] = value.getBytes();
                                current.getData()[index] = this.convertFromSourceToTargetType(valueMetaConverter, current.getData()[index], f);
                                this.updateValueMeta(index, f);
                            }
                        };
                        break;
                    }
                    case 8: {
                        this.converters[i] = new PrimitiveConverter(){

                            public void addBinary(Binary value) {
                                if (f.getPentahoType() == 2) {
                                    current.getData()[index] = value.toStringUsingUTF8();
                                } else {
                                    current.getData()[index] = value.getBytes();
                                    current.getData()[index] = this.convertFromSourceToTargetType(valueMetaConverter, current.getData()[index], f);
                                    this.updateValueMeta(index, f);
                                }
                            }
                        };
                        break;
                    }
                    case 3: {
                        this.converters[i] = new PrimitiveConverter(){

                            public void addLong(long value) {
                                current.getData()[index] = new Date(value);
                                current.getData()[index] = this.convertFromSourceToTargetType(valueMetaConverter, current.getData()[index], f);
                                this.updateValueMeta(index, f);
                            }

                            public void addInt(int value) {
                                LocalDate localDate = LocalDate.ofEpochDay(0L).plusDays(value);
                                current.getData()[index] = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                                current.getData()[index] = this.convertFromSourceToTargetType(valueMetaConverter, current.getData()[index], f);
                                this.updateValueMeta(index, f);
                            }

                            public void addBinary(Binary value) {
                                current.getData()[index] = new Date(MyGroupConverter.dateFromInt96(value));
                                current.getData()[index] = this.convertFromSourceToTargetType(valueMetaConverter, current.getData()[index], f);
                                this.updateValueMeta(index, f);
                            }
                        };
                        break;
                    }
                    case 9: {
                        this.converters[i] = new PrimitiveConverter(){

                            public void addLong(long value) {
                                current.getData()[index] = new Timestamp(value);
                                current.getData()[index] = this.convertFromSourceToTargetType(valueMetaConverter, current.getData()[index], f);
                                this.updateValueMeta(index, f);
                            }

                            public void addInt(int value) {
                                current.getData()[index] = new Timestamp((long)value * 24L * 60L * 60L * 1000L);
                                current.getData()[index] = this.convertFromSourceToTargetType(valueMetaConverter, current.getData()[index], f);
                                this.updateValueMeta(index, f);
                            }

                            public void addBinary(Binary value) {
                                current.getData()[index] = new Timestamp(MyGroupConverter.dateFromInt96(value));
                                current.getData()[index] = this.convertFromSourceToTargetType(valueMetaConverter, current.getData()[index], f);
                                this.updateValueMeta(index, f);
                            }
                        };
                        break;
                    }
                    case 10: {
                        this.converters[i] = new PrimitiveConverter(){

                            public void addBinary(Binary value) {
                                try {
                                    byte[] bytes = value.getBytes();
                                    if (bytes == null || bytes.length == 0) {
                                        current.getData()[index] = null;
                                    } else {
                                        current.getData()[index] = InetAddress.getByAddress(bytes);
                                        current.getData()[index] = this.convertFromSourceToTargetType(valueMetaConverter, current.getData()[index], f);
                                    }
                                    this.updateValueMeta(index, f);
                                }
                                catch (Exception ex) {
                                    throw new RuntimeException(ex);
                                }
                            }
                        };
                        break;
                    }
                    default: {
                        throw new RuntimeException("Undefined type: " + f.getPentahoFieldName());
                    }
                }
                ++i;
            }
        }

        private void updateValueMeta(int index, IParquetInputField inputField) {
            String stringFormat = inputField.getStringFormat();
            if (stringFormat != null && stringFormat.trim().length() > 0) {
                this.current.getValueMeta(index).setConversionMask(stringFormat);
            }
        }

        private static long dateFromInt96(Binary value) {
            byte[] readBuffer = value.getBytes();
            if (readBuffer.length != 12) {
                throw new RuntimeException("Invalid byte array length for INT96");
            }
            long timeOfDayNanos = ((long)readBuffer[7] << 56) + ((long)(readBuffer[6] & 0xFF) << 48) + ((long)(readBuffer[5] & 0xFF) << 40) + ((long)(readBuffer[4] & 0xFF) << 32) + ((long)(readBuffer[3] & 0xFF) << 24) + (long)((readBuffer[2] & 0xFF) << 16) + (long)((readBuffer[1] & 0xFF) << 8) + (long)(readBuffer[0] & 0xFF);
            int julianDay = ((readBuffer[11] & 0xFF) << 24) + ((readBuffer[10] & 0xFF) << 16) + ((readBuffer[9] & 0xFF) << 8) + (readBuffer[8] & 0xFF);
            return (long)(julianDay - 2440588) * 24L * 60L * 60L * 1000L + timeOfDayNanos / 1000000L;
        }

        public void start() {
            this.current = new RowMetaAndData((RowMetaInterface)this.fields, new Object[0]);
            this.current.setData(new Object[this.count]);
        }

        public Converter getConverter(int fieldIndex) {
            return this.converters[fieldIndex];
        }

        public void end() {
        }

        public RowMetaAndData getCurrentRecord() {
            return this.current;
        }

        static BigDecimal binaryToDecimal(Binary value, int precision, int scale) {
            if (precision <= 18) {
                ByteBuffer buffer = value.toByteBuffer();
                byte[] bytes = buffer.array();
                int start = buffer.arrayOffset() + buffer.position();
                int end = buffer.arrayOffset() + buffer.limit();
                long unscaled = 0L;
                for (int i = start; i < end; ++i) {
                    unscaled = unscaled << 8 | (long)(bytes[i] & 0xFF);
                }
                int bits = 8 * (end - start);
                long unscaledNew = unscaled << 64 - bits >> 64 - bits;
                if ((double)unscaledNew <= -Math.pow(10.0, 18.0) || (double)unscaledNew >= Math.pow(10.0, 18.0)) {
                    return new BigDecimal(unscaledNew);
                }
                return BigDecimal.valueOf((double)unscaledNew / Math.pow(10.0, scale));
            }
            return new BigDecimal(new BigInteger(value.getBytes()), scale);
        }
    }

    public static class MyRecordMaterializer
    extends RecordMaterializer<RowMetaAndData> {
        private final MyGroupConverter root;

        public MyRecordMaterializer(ParquetConverter converter) {
            this.root = new MyGroupConverter(converter);
        }

        public RowMetaAndData getCurrentRecord() {
            return this.root.getCurrentRecord();
        }

        public GroupConverter getRootConverter() {
            return this.root;
        }
    }
}

