/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hbase.shim.fake;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.hadoop.shim.ShimVersion;
import org.pentaho.hadoop.shim.api.internal.Configuration;
import org.pentaho.hadoop.shim.api.internal.hbase.ColumnFilter;
import org.pentaho.hadoop.shim.api.internal.hbase.HBaseBytesUtilShim;
import org.pentaho.hadoop.shim.api.internal.hbase.HBaseValueMeta;
import org.pentaho.hadoop.shim.spi.HBaseConnection;
import org.pentaho.hbase.shim.common.CommonHBaseBytesUtil;

public class FakeHBaseConnection
implements HBaseConnection {
    protected HBaseBytesUtilShim m_bytesUtil;
    protected Map<String, FakeTable> m_db = new HashMap<String, FakeTable>();
    protected String m_sourceTable;
    protected String m_targetTable;
    protected Scan m_sourceScan;
    protected Put m_currentTargetPut;
    protected ResultScanner m_resultSet;
    protected Result m_currentResultSetRow;

    public FakeHBaseConnection() {
        try {
            this.getBytesUtil();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public HBaseBytesUtilShim getBytesUtil() throws Exception {
        if (this.m_bytesUtil == null) {
            this.m_bytesUtil = new CommonHBaseBytesUtil();
        }
        return this.m_bytesUtil;
    }

    public ShimVersion getVersion() {
        return new ShimVersion(1, 0);
    }

    @Override
    public void addColumnFilterToScan(ColumnFilter arg0, HBaseValueMeta arg1, VariableSpace arg2, boolean arg3) throws Exception {
    }

    @Override
    public void addColumnToScan(String colFamilyName, String colName, boolean colNameIsBinary) throws Exception {
        this.checkSourceScan();
        this.m_sourceScan.addColumn(this.m_bytesUtil.toBytes(colFamilyName), colNameIsBinary ? this.m_bytesUtil.toBytesBinary(colName) : this.m_bytesUtil.toBytes(colName));
    }

    @Override
    public void addColumnToTargetPut(String columnFamily, String columnName, boolean colNameIsBinary, byte[] colValue) throws Exception {
        this.checkTargetTable();
        this.checkTargetPut();
        this.m_currentTargetPut.addColumn(this.m_bytesUtil.toBytes(columnFamily), colNameIsBinary ? this.m_bytesUtil.toBytesBinary(columnName) : this.m_bytesUtil.toBytes(columnName), colValue);
    }

    @Override
    public boolean checkForHBaseRow(Object arg0) {
        return false;
    }

    @Override
    public void checkHBaseAvailable() throws Exception {
    }

    @Override
    public void closeSourceResultSet() throws Exception {
        if (this.m_resultSet != null) {
            this.m_resultSet = null;
            this.m_currentResultSetRow = null;
        }
    }

    @Override
    public void closeSourceTable() throws Exception {
        this.closeSourceResultSet();
        this.m_sourceTable = null;
    }

    @Override
    public void closeTargetTable() throws Exception {
        this.m_targetTable = null;
    }

    @Override
    public void configureConnection(Properties connProps, List<String> logMessages) throws Exception {
        block7: {
            String defaultConfig = connProps.getProperty("hbase.default");
            String siteConfig = connProps.getProperty("hbase.site");
            String zookeeperQuorum = connProps.getProperty("hbase.zookeeper.quorum");
            String zookeeperPort = connProps.getProperty("hbase.zookeeper.property.clientPort");
            try {
                if (!HBaseConnection.isEmpty(defaultConfig)) {
                    HBaseConnection.stringToURL(defaultConfig);
                }
                if (!HBaseConnection.isEmpty(siteConfig)) {
                    HBaseConnection.stringToURL(siteConfig);
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Malformed URL");
            }
            if (!HBaseConnection.isEmpty(zookeeperPort)) {
                try {
                    Integer.parseInt(zookeeperPort);
                }
                catch (NumberFormatException e) {
                    if (logMessages == null) break block7;
                    logMessages.add("Unable to parse zookeeper port");
                }
            }
        }
    }

    @Override
    public void createTable(String tableName, List<String> colFamilyNames, Properties creationProps) throws Exception {
        if (this.m_db.containsKey(tableName)) {
            throw new Exception("Table already exists!");
        }
        FakeTable ft = new FakeTable(colFamilyNames);
        this.m_db.put(tableName, ft);
    }

    @Override
    public void deleteTable(String tableName) throws Exception {
        this.m_db.remove(tableName);
    }

    @Override
    public void disableTable(String tableName) throws Exception {
        if (!this.m_db.containsKey(tableName)) {
            throw new Exception("Can't disable table - it does not exist!");
        }
        this.m_db.get(tableName).setEnabled(false);
    }

    @Override
    public void enableTable(String tableName) throws Exception {
        if (!this.m_db.containsKey(tableName)) {
            throw new Exception("Can't enable table - it does not exist!");
        }
        this.m_db.get(tableName).setEnabled(true);
    }

    @Override
    public void executeSourceTableScan() throws Exception {
        this.checkSourceTable();
        this.checkSourceScan();
        this.m_resultSet = this.m_sourceScan.getScanner(this.m_sourceTable);
    }

    @Override
    public void executeTargetTableDelete(byte[] rowKey) throws Exception {
        this.checkTargetTable();
        FakeTable table = this.m_db.get(this.m_targetTable);
        if (table == null) {
            throw new Exception("Target table is null!!");
        }
        table.deleteRow(rowKey);
    }

    @Override
    public void executeTargetTablePut() throws Exception {
        this.checkTargetTable();
        this.checkTargetPut();
        FakeTable table = this.m_db.get(this.m_targetTable);
        if (table == null) {
            throw new Exception("Target table doesn't exist!");
        }
        table.put(this.m_currentTargetPut);
    }

    @Override
    public void flushCommitsTargetTable() throws Exception {
    }

    @Override
    public byte[] getResultSetCurrentRowColumnLatest(String colFamilyName, String colName, boolean colNameIsBinary) throws Exception {
        return this.m_currentResultSetRow.getValue(this.m_bytesUtil.toBytes(colFamilyName), colNameIsBinary ? this.m_bytesUtil.toBytesBinary(colName) : this.m_bytesUtil.toBytes(colName));
    }

    @Override
    public NavigableMap<byte[], byte[]> getResultSetCurrentRowFamilyMap(String familyName) throws Exception {
        return this.m_currentResultSetRow.getFamilyMap(this.m_bytesUtil.toBytes(familyName));
    }

    @Override
    public byte[] getResultSetCurrentRowKey() throws Exception {
        this.checkSourceScan();
        this.checkResultSet();
        this.checkForCurrentResultSetRow();
        return this.m_currentResultSetRow.getRow();
    }

    @Override
    public NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> getResultSetCurrentRowMap() throws Exception {
        return this.m_currentResultSetRow.getMap();
    }

    @Override
    public byte[] getRowColumnLatest(Object arg0, String arg1, String arg2, boolean arg3) throws Exception {
        return null;
    }

    @Override
    public NavigableMap<byte[], byte[]> getRowFamilyMap(Object aRow, String family) throws Exception {
        return null;
    }

    @Override
    public byte[] getRowKey(Object arg0) throws Exception {
        return null;
    }

    @Override
    public NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> getRowMap(Object arg0) throws Exception {
        return null;
    }

    @Override
    public List<String> getTableFamiles(String tableName) throws Exception {
        List<String> families = new ArrayList<String>();
        FakeTable tab = this.m_db.get(tableName);
        if (tab != null) {
            families = tab.getFamilies();
        }
        return families;
    }

    @Override
    public boolean isImmutableBytesWritable(Object arg0) {
        return false;
    }

    @Override
    public boolean isTableAvailable(String tableName) throws Exception {
        if (!this.m_db.containsKey(tableName)) {
            return false;
        }
        return this.m_db.get(tableName).getAvailable();
    }

    @Override
    public boolean isTableDisabled(String tableName) throws Exception {
        if (!this.m_db.containsKey(tableName)) {
            return true;
        }
        return this.m_db.get(tableName).getEnabled();
    }

    @Override
    public List<String> listTableNames() throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        for (String tabName : this.m_db.keySet()) {
            names.add(tabName);
        }
        return names;
    }

    @Override
    public void newSourceTable(String tableName) throws Exception {
        this.closeSourceTable();
        if (this.m_db.get(tableName) == null) {
            throw new Exception("Source table " + tableName + " does not exist!");
        }
        this.m_sourceTable = tableName;
    }

    @Override
    public void newSourceTableScan(byte[] keyLowerBound, byte[] keyUpperBound, int cacheSize) throws Exception {
        this.checkSourceTable();
        this.m_sourceScan = new Scan(keyLowerBound, keyUpperBound);
    }

    @Override
    public void newTargetTable(String tableName, Properties arg1) throws Exception {
        this.closeTargetTable();
        this.m_targetTable = tableName;
    }

    @Override
    public void newTargetTablePut(byte[] key, boolean writeToWAL) throws Exception {
        this.checkTargetTable();
        this.m_currentTargetPut = new Put(key);
    }

    @Override
    public boolean resultSetNextRow() throws Exception {
        this.checkResultSet();
        this.m_currentResultSetRow = this.m_resultSet.next();
        return this.m_currentResultSetRow != null;
    }

    @Override
    public boolean sourceTableRowExists(byte[] rowKey) throws Exception {
        this.checkSourceTable();
        FakeTable tab = this.m_db.get(this.m_sourceTable);
        if (tab == null) {
            return false;
        }
        return tab.get(rowKey) != null;
    }

    @Override
    public boolean tableExists(String tableName) throws Exception {
        return this.m_db.get(tableName) != null;
    }

    @Override
    public boolean targetTableIsAutoFlush() throws Exception {
        this.checkTargetTable();
        return true;
    }

    protected void checkSourceTable() throws Exception {
        if (this.m_sourceTable == null) {
            throw new Exception("No source table has been specified!");
        }
    }

    protected void checkTargetTable() throws Exception {
        if (this.m_targetTable == null) {
            throw new Exception("No target table has been specified!");
        }
    }

    protected void checkTargetPut() throws Exception {
        if (this.m_currentTargetPut == null) {
            throw new Exception("No target put configured!");
        }
    }

    protected void checkSourceScan() throws Exception {
        if (this.m_sourceScan == null) {
            throw new Exception("No source scan defined!");
        }
    }

    protected void checkResultSet() throws Exception {
        if (this.m_resultSet == null) {
            throw new Exception("No current result set!");
        }
    }

    protected void checkForCurrentResultSetRow() throws Exception {
        if (this.m_currentResultSetRow == null) {
            throw new Exception("No current resut set row available!");
        }
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void obtainAuthTokenForJob(Configuration conf) throws Exception {
    }

    protected class ResultScanner {
        protected Scan m_scan;
        protected SortedMap<byte[], NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>>> m_rows;
        protected Iterator<Map.Entry<byte[], NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>>>> m_rowIterator;

        public ResultScanner(Scan scan, SortedMap<byte[], NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>>> rows) {
            this.m_scan = scan;
            this.m_rows = rows;
            this.m_rowIterator = this.m_rows.entrySet().iterator();
        }

        public Result next() {
            if (!this.m_rowIterator.hasNext()) {
                return null;
            }
            Map.Entry<byte[], NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>>> nextR = this.m_rowIterator.next();
            if (nextR == null) {
                return null;
            }
            Result r = this.m_scan.columnLimitedRow(nextR.getKey(), nextR.getValue());
            return r;
        }
    }

    protected class Result {
        protected byte[] m_rowKey;
        protected NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> m_row;

        public Result(byte[] rowKey, NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> row) {
            this.m_rowKey = rowKey;
            this.m_row = row;
        }

        public byte[] getRow() {
            return this.m_rowKey;
        }

        public byte[] getValue(byte[] colFam, byte[] colName) {
            NavigableMap colMapForFam = (NavigableMap)this.m_row.get(colFam);
            if (colMapForFam == null) {
                return null;
            }
            NavigableMap versionsOfCol = (NavigableMap)colMapForFam.get(colName);
            if (versionsOfCol == null) {
                return null;
            }
            return (byte[])versionsOfCol.lastEntry().getValue();
        }

        public NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> getMap() {
            return this.m_row;
        }

        public NavigableMap<byte[], byte[]> getFamilyMap(byte[] colFamily) {
            NavigableMap famMap = (NavigableMap)this.m_row.get(colFamily);
            if (famMap == null) {
                return null;
            }
            TreeMap<byte[], byte[]> famMapLatestVals = new TreeMap<byte[], byte[]>(new BytesComparator());
            Set es = famMap.entrySet();
            for (Map.Entry e : es) {
                famMapLatestVals.put((byte[])e.getKey(), (byte[])((NavigableMap)e.getValue()).lastEntry().getValue());
            }
            return famMapLatestVals;
        }
    }

    protected class Scan {
        protected byte[] m_startKey;
        protected byte[] m_stopKey;
        protected List<Col> m_cols = new ArrayList<Col>();

        public Scan() {
        }

        public Scan(byte[] startKey) {
            this.m_startKey = startKey;
        }

        public Scan(byte[] startKey, byte[] stopKey) {
            this.m_startKey = startKey;
            this.m_stopKey = stopKey;
        }

        public void addColumn(byte[] colFamName, byte[] colName) {
            this.m_cols.add(new Col(colFamName, colName));
        }

        public List<Col> getColumns() {
            return this.m_cols;
        }

        public ResultScanner getScanner(String tableName) {
            FakeTable table = FakeHBaseConnection.this.m_db.get(tableName);
            if (table == null) {
                return null;
            }
            SortedMap<byte[], NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>>> subMap = table.getRows(this.m_startKey, this.m_stopKey);
            return new ResultScanner(this, subMap);
        }

        public Result columnLimitedRow(byte[] rowKey, NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> fullRow) {
            if (this.getColumns() == null || this.getColumns().size() == 0) {
                return new Result(rowKey, fullRow);
            }
            TreeMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> colLimited = new TreeMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>>(new BytesComparator());
            for (Col col : this.m_cols) {
                NavigableMap theCol;
                NavigableMap colsForFam = (NavigableMap)fullRow.get(col.m_colFamName);
                if (colsForFam == null || (theCol = (NavigableMap)colsForFam.get(col.m_colName)) == null) continue;
                TreeMap<byte[], NavigableMap> resultCols = (TreeMap<byte[], NavigableMap>)colLimited.get(col.m_colFamName);
                if (resultCols == null) {
                    resultCols = new TreeMap<byte[], NavigableMap>(new BytesComparator());
                    colLimited.put(col.m_colFamName, resultCols);
                }
                resultCols.put(col.m_colName, theCol);
            }
            return new Result(rowKey, colLimited);
        }
    }

    protected class Put {
        protected byte[] m_key;
        protected List<Col> m_cols = new ArrayList<Col>();

        public Put(byte[] key) {
            this.m_key = key;
        }

        public void addColumn(byte[] colFamName, byte[] colName, byte[] colVal) {
            this.m_cols.add(new Col(colFamName, colName, colVal));
        }

        public byte[] getKey() {
            return this.m_key;
        }

        public List<Col> getColumns() {
            return this.m_cols;
        }
    }

    protected class Col {
        protected byte[] m_colFamName;
        protected byte[] m_colName;
        protected byte[] m_value;

        public Col(byte[] colFamName, byte[] colName, byte[] value) {
            this.m_colFamName = colFamName;
            this.m_colName = colName;
            this.m_value = value;
        }

        public Col(byte[] colFamName, byte[] colName) {
            this(colFamName, colName, null);
        }
    }

    protected class FakeTable {
        public String m_tableName;
        protected Set<String> m_families = new HashSet<String>();
        protected boolean m_enabled;
        protected boolean m_available;
        public NavigableMap<byte[], NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>>> m_table = new TreeMap<byte[], NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>>>(new BytesComparator());

        public FakeTable(List<String> families) {
            for (String fam : families) {
                this.m_families.add(fam);
            }
            this.m_enabled = true;
            this.m_available = true;
        }

        public String getName() {
            return this.m_tableName;
        }

        public boolean getEnabled() {
            return this.m_enabled;
        }

        public void setEnabled(boolean enabled) {
            this.m_enabled = enabled;
        }

        public void setAvailable(boolean avail) {
            this.m_available = avail;
        }

        public boolean getAvailable() {
            return this.m_available;
        }

        public List<String> getFamilies() {
            ArrayList<String> fams = new ArrayList<String>();
            for (String f : this.m_families) {
                fams.add(f);
            }
            return fams;
        }

        public Result get(byte[] rowKey) {
            NavigableMap row = (NavigableMap)this.m_table.get(rowKey);
            if (row == null) {
                return null;
            }
            return new Result(rowKey, row);
        }

        public void put(Put toPut) {
            byte[] key = toPut.getKey();
            List<Col> colsToPut = toPut.getColumns();
            TreeMap row = (TreeMap)this.m_table.get(key);
            if (row == null) {
                row = new TreeMap(new BytesComparator());
                this.m_table.put(key, row);
            }
            for (Col c : colsToPut) {
                TreeMap<Long, byte[]> valsForCol;
                TreeMap colsForFam = (TreeMap)row.get(c.m_colFamName);
                if (colsForFam == null) {
                    colsForFam = new TreeMap(new BytesComparator());
                    row.put(c.m_colFamName, colsForFam);
                }
                if ((valsForCol = (TreeMap<Long, byte[]>)colsForFam.get(c.m_colName)) == null) {
                    valsForCol = new TreeMap<Long, byte[]>();
                    colsForFam.put(c.m_colName, valsForCol);
                }
                Long ts = new Long(System.currentTimeMillis());
                valsForCol.put(ts, c.m_value);
            }
        }

        public SortedMap<byte[], NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>>> getRows(byte[] startKey, byte[] stopKey) {
            SortedMap<byte[], NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>>> subMap = null;
            if (startKey == null && stopKey == null) {
                return this.m_table;
            }
            if (stopKey == null) {
                Map.Entry<byte[], NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>>> lastE = this.m_table.lastEntry();
                byte[] upperKey = lastE.getKey();
                subMap = this.m_table.subMap(startKey, true, upperKey, true);
            } else {
                BytesComparator comp = new BytesComparator();
                subMap = comp.compare(startKey, stopKey) == 0 ? this.m_table.subMap(startKey, true, stopKey, true) : this.m_table.subMap(startKey, stopKey);
            }
            return subMap;
        }

        public void deleteRow(byte[] rowKey) {
            this.m_table.remove(rowKey);
        }
    }

    public static class BytesComparator
    implements Comparator<byte[]> {
        public int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
            int end1 = offset1 + length1;
            int end2 = offset2 + length2;
            int i = offset1;
            for (int j = offset2; i < end1 && j < end2; ++i, ++j) {
                int a = buffer1[i] & 0xFF;
                int b = buffer2[j] & 0xFF;
                if (a == b) continue;
                return a - b;
            }
            return length1 - length2;
        }

        public int compareTo(byte[] left, byte[] right) {
            return this.compareTo(left, 0, left.length, right, 0, right.length);
        }

        @Override
        public int compare(byte[] left, byte[] right) {
            return this.compareTo(left, right);
        }
    }
}

