/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.big.data.bundles.impl.shim.hdfs;

import com.pentaho.big.data.bundles.impl.shim.hdfs.HadoopFileSystemImpl;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.pentaho.hadoop.shim.api.ShimIdentifierInterface;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.hdfs.HadoopFileSystem;
import org.pentaho.hadoop.shim.api.hdfs.HadoopFileSystemFactory;
import org.pentaho.hadoop.shim.api.internal.Configuration;
import org.pentaho.hadoop.shim.spi.HadoopShim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopFileSystemFactoryImpl
implements HadoopFileSystemFactory {
    public static final String SHIM_IDENTIFIER = "shim.identifier";
    public static final String HDFS = "hdfs";
    protected static final Logger LOGGER = LoggerFactory.getLogger(HadoopFileSystemFactoryImpl.class);
    protected final boolean isActiveConfiguration;
    protected final HadoopShim hadoopShim;
    protected final ShimIdentifierInterface shimIdentifier;

    public HadoopFileSystemFactoryImpl(HadoopShim hadoopShim, ShimIdentifierInterface shimIdentifier) {
        this(true, hadoopShim, HDFS, shimIdentifier);
    }

    public HadoopFileSystemFactoryImpl(boolean isActiveConfiguration, HadoopShim hadoopShim, String scheme, ShimIdentifierInterface shimIdentifier) {
        this.isActiveConfiguration = isActiveConfiguration;
        this.hadoopShim = hadoopShim;
        this.shimIdentifier = shimIdentifier;
    }

    public boolean canHandle(NamedCluster namedCluster) {
        String shimIdentifier = namedCluster.getShimIdentifier();
        return shimIdentifier == null && !namedCluster.isUseGateway() || this.shimIdentifier.getId().equals(shimIdentifier) && !namedCluster.isUseGateway();
    }

    public HadoopFileSystem create(NamedCluster namedCluster) throws IOException {
        return this.create(namedCluster, null);
    }

    public HadoopFileSystem create(NamedCluster namedCluster, URI uri) throws IOException {
        Configuration configuration = this.hadoopShim.createConfiguration(namedCluster.getName());
        FileSystem fileSystem = (FileSystem)this.hadoopShim.getFileSystem(configuration).getDelegate();
        if (fileSystem instanceof LocalFileSystem) {
            LOGGER.error("Got a local filesystem, was expecting an hdfs connection");
            throw new IOException("Got a local filesystem, was expecting an hdfs connection");
        }
        URI finalUri = fileSystem.getUri() != null ? fileSystem.getUri() : uri;
        HadoopFileSystemImpl hadoopFileSystem = new HadoopFileSystemImpl(() -> {
            try {
                return finalUri != null ? (FileSystem)this.hadoopShim.getFileSystem(finalUri, configuration, namedCluster).getDelegate() : (FileSystem)this.hadoopShim.getFileSystem(configuration).getDelegate();
            }
            catch (IOException | InterruptedException e) {
                LOGGER.debug("Error looking up/creating the file system ", (Throwable)e);
                return null;
            }
        });
        hadoopFileSystem.setNamedCluster(namedCluster);
        return hadoopFileSystem;
    }
}

