/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.shim;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pentaho.big.data.bundles.impl.shim.hbase.ByteConversionUtilImpl;
import com.pentaho.big.data.bundles.impl.shim.hbase.HBaseConnectionImpl;
import com.pentaho.big.data.bundles.impl.shim.hbase.ResultFactoryImpl;
import com.pentaho.big.data.bundles.impl.shim.hbase.mapping.ColumnFilterFactoryImpl;
import com.pentaho.big.data.bundles.impl.shim.hbase.mapping.MappingFactoryImpl;
import com.pentaho.big.data.bundles.impl.shim.hbase.meta.HBaseValueMetaInterfaceFactoryImpl;
import com.pentaho.big.data.bundles.impl.shim.hdfs.HadoopFileSystemImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.avro.Conversion;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.util.PropertiesUtil;
import org.apache.pig.tools.grunt.GruntParser;
import org.apache.pig.tools.parameters.ParameterSubstitutionPreprocessor;
import org.apache.pig.tools.pigscript.parser.ParseException;
import org.apache.sqoop.Sqoop;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.pentaho.big.data.impl.shim.oozie.OozieJobInfoDelegate;
import org.pentaho.big.data.impl.shim.oozie.OozieJobInfoImpl;
import org.pentaho.big.data.impl.shim.pig.PigResultImpl;
import org.pentaho.big.data.impl.shim.pig.WriterAppenderManager;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.hadoop.shim.api.HadoopClientServices;
import org.pentaho.hadoop.shim.api.HadoopClientServicesException;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.hbase.ByteConversionUtil;
import org.pentaho.hadoop.shim.api.hbase.HBaseConnection;
import org.pentaho.hadoop.shim.api.hbase.ResultFactory;
import org.pentaho.hadoop.shim.api.hdfs.HadoopFileSystem;
import org.pentaho.hadoop.shim.api.internal.hbase.HBaseBytesUtilShim;
import org.pentaho.hadoop.shim.api.oozie.OozieJobInfo;
import org.pentaho.hadoop.shim.api.pig.PigResult;
import org.pentaho.hadoop.shim.common.ShimUtils;
import org.pentaho.hadoop.shim.spi.HadoopShim;
import org.pentaho.hbase.shim.common.CommonHBaseBytesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopClientServicesImpl
implements HadoopClientServices {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Logger LOGGER = LoggerFactory.getLogger(HadoopClientServicesImpl.class);
    public static final String SQOOP_THROW_ON_ERROR = "sqoop.throwOnError";
    private static final String ALT_CLASSPATH = "hadoop.alt.classpath";
    private static final String TMPJARS = "tmpjars";
    protected NamedCluster namedCluster;
    protected final OozieClient oozieClient;
    protected final HadoopShim hadoopShim;
    private BundleContext bundleContext;
    private List<String> sqoopBundleFileLocations = new ArrayList<String>();
    private final WriterAppenderManager.Factory writerAppenderManagerFactory;
    protected final HBaseBytesUtilShim bytesUtil;

    public HadoopClientServicesImpl(NamedCluster namedCluster, HadoopShim hadoopShim, BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.hadoopShim = hadoopShim;
        this.namedCluster = namedCluster;
        this.oozieClient = new OozieClient(namedCluster.getOozieUrl());
        this.writerAppenderManagerFactory = new WriterAppenderManager.Factory();
        this.bytesUtil = new CommonHBaseBytesUtil();
    }

    public String getOozieProtocolUrl() throws HadoopClientServicesException {
        try {
            return this.oozieClient.getProtocolUrl();
        }
        catch (OozieClientException e) {
            throw new HadoopClientServicesException((Throwable)e, e.getErrorCode());
        }
    }

    public OozieJobInfo runOozie(Properties props) throws HadoopClientServicesException {
        try {
            String jobId = this.oozieClient.run(props);
            return new OozieJobInfoDelegate(new OozieJobInfoImpl(jobId, this.oozieClient));
        }
        catch (OozieClientException e) {
            throw new HadoopClientServicesException((Throwable)e, e.getErrorCode());
        }
    }

    public void validateOozieWSVersion() throws HadoopClientServicesException {
        try {
            this.oozieClient.validateWSVersion();
        }
        catch (OozieClientException e) {
            throw new HadoopClientServicesException((Throwable)e, e.getErrorCode());
        }
    }

    public boolean hasOozieAppPath(Properties props) {
        return props.containsKey("oozie.wf.application.path") || props.containsKey("oozie.coord.application.path") || props.containsKey("oozie.bundle.application.path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runSqoop(List<String> argsList, Properties properties) {
        int serviceFilter2;
        block15: {
            String tmpPropertyHolder;
            block13: {
                org.pentaho.hadoop.shim.api.internal.Configuration configuration = this.hadoopShim.createConfiguration(this.namedCluster.getName());
                for (Map.Entry entry : Maps.fromProperties((Properties)properties).entrySet()) {
                    configuration.set((String)entry.getKey(), (String)entry.getValue());
                }
                System.setProperty(SQOOP_THROW_ON_ERROR, Boolean.toString(true));
                this.configureShim(configuration);
                String[] args = argsList.toArray(new String[argsList.size()]);
                org.pentaho.hadoop.shim.api.internal.Configuration c = configuration;
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                tmpPropertyHolder = System.getProperty(ALT_CLASSPATH);
                try {
                    this.loadBundleFilesLocations();
                    System.setProperty(ALT_CLASSPATH, this.createHadoopAltClasspath());
                    c.set(TMPJARS, this.getSqoopJarLocation(c));
                    if (args.length > 0 && (Arrays.asList(args).contains("--as-avrodatafile") || Arrays.asList(args).contains("--export-dir"))) {
                        this.addDependencyJars(c, Conversion.class, AvroWrapper.class);
                    }
                    if (args.length > 0 && Arrays.asList(args).contains("--hbase-table")) {
                        Filter serviceFilter2 = this.bundleContext.createFilter("(shim=" + this.namedCluster.getShimIdentifier() + ")");
                        ServiceReference serviceReference = (ServiceReference)this.bundleContext.getServiceReferences(HadoopShim.class, serviceFilter2.toString()).toArray()[0];
                        Object service = this.bundleContext.getService(serviceReference);
                        Class[] depClasses = (Class[])service.getClass().getMethod("getHbaseDependencyClasses", new Class[0]).invoke(service, new Object[0]);
                        this.addDependencyJars(c, depClasses);
                    }
                    serviceFilter2 = Sqoop.runTool((String[])args, (Configuration)ShimUtils.asConfiguration(c));
                    Thread.currentThread().setContextClassLoader(cl);
                    if (tmpPropertyHolder != null) break block13;
                }
                catch (IOException e) {
                    int n;
                    block16: {
                        block14: {
                            try {
                                e.printStackTrace();
                                n = -1;
                                Thread.currentThread().setContextClassLoader(cl);
                                if (tmpPropertyHolder != null) break block14;
                            }
                            catch (Throwable throwable) {
                                try {
                                    Thread.currentThread().setContextClassLoader(cl);
                                    if (tmpPropertyHolder == null) {
                                        System.clearProperty(ALT_CLASSPATH);
                                    } else {
                                        System.setProperty(ALT_CLASSPATH, tmpPropertyHolder);
                                    }
                                    throw throwable;
                                }
                                catch (Exception e2) {
                                    LOGGER.error("Error executing sqoop", (Throwable)e2);
                                    return 1;
                                }
                            }
                            System.clearProperty(ALT_CLASSPATH);
                            break block16;
                        }
                        System.setProperty(ALT_CLASSPATH, tmpPropertyHolder);
                    }
                    return n;
                }
                System.clearProperty(ALT_CLASSPATH);
                break block15;
            }
            System.setProperty(ALT_CLASSPATH, tmpPropertyHolder);
        }
        return serviceFilter2;
    }

    private void configureShim(org.pentaho.hadoop.shim.api.internal.Configuration conf) throws Exception {
        ArrayList messages = Lists.newArrayList();
        if (this.namedCluster.isMapr()) {
            this.hadoopShim.configureConnectionInformation("", "", "", "", conf, messages);
        } else {
            this.hadoopShim.configureConnectionInformation(this.namedCluster.environmentSubstitute(this.namedCluster.getHdfsHost()), this.namedCluster.environmentSubstitute(this.namedCluster.getHdfsPort()), this.namedCluster.environmentSubstitute(this.namedCluster.getJobTrackerHost()), this.namedCluster.environmentSubstitute(this.namedCluster.getJobTrackerPort()), conf, messages);
        }
        for (String m : messages) {
            LOGGER.info(m);
        }
    }

    private String getSqoopJarLocation(org.pentaho.hadoop.shim.api.internal.Configuration c) {
        StringBuilder sb = new StringBuilder();
        for (String bundleFileLocation : this.sqoopBundleFileLocations) {
            File filesInsideBundle = new File(bundleFileLocation);
            Iterator filesIterator = FileUtils.iterateFiles((File)filesInsideBundle, (String[])new String[]{"jar"}, (boolean)true);
            while (filesIterator.hasNext()) {
                File file = (File)filesIterator.next();
                String name = file.getName();
                if (!name.startsWith("sqoop")) continue;
                sb.append(file.getAbsolutePath());
            }
        }
        try {
            LocalFileSystem fs = FileSystem.getLocal((Configuration)ShimUtils.asConfiguration(c));
            return new Path(sb.toString()).makeQualified((FileSystem)fs).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return sb.toString();
        }
    }

    private void addDependencyJars(org.pentaho.hadoop.shim.api.internal.Configuration conf, Class ... classes) throws IOException {
        ArrayList<String> classNames = new ArrayList<String>();
        for (Class clazz : classes) {
            classNames.add(clazz.getCanonicalName().replace(".", "/") + ".class");
        }
        HashSet<String> tmpjars = new HashSet<String>();
        if (conf.get(TMPJARS) != null) {
            tmpjars.addAll(Arrays.asList(conf.get(TMPJARS).split(",")));
        }
        block13: for (String bundleFileLocation : this.sqoopBundleFileLocations) {
            File filesInsideBundle = new File(bundleFileLocation);
            Iterator filesIterator = FileUtils.iterateFiles((File)filesInsideBundle, (String[])new String[]{"jar"}, (boolean)true);
            while (filesIterator.hasNext()) {
                File file = (File)filesIterator.next();
                ZipFile zip = new ZipFile(file);
                Throwable throwable = null;
                try {
                    Enumeration<? extends ZipEntry> list = zip.entries();
                    while (list.hasMoreElements()) {
                        ZipEntry entry = list.nextElement();
                        if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                        ListIterator classNameIterator = classNames.listIterator();
                        while (classNameIterator.hasNext()) {
                            if (!entry.getName().endsWith((String)classNameIterator.next())) continue;
                            tmpjars.add(file.toURI().toURL().toString());
                            classNameIterator.remove();
                            if (classNames.size() != 0) continue;
                            continue block13;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (zip == null) continue block13;
                    if (throwable != null) {
                        try {
                            zip.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue block13;
                    }
                    zip.close();
                    continue block13;
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        if (tmpjars.size() > 0) {
            for (String jarPath : tmpjars) {
                sb.append(",").append(jarPath);
            }
            conf.set(TMPJARS, sb.toString().substring(1));
        }
    }

    private void loadBundleFilesLocations() {
        this.sqoopBundleFileLocations.clear();
        String bundleLocation = this.bundleContext.getBundle().getDataFile("").getParent();
        this.sqoopBundleFileLocations.add(bundleLocation);
        BundleWiring wiring = (BundleWiring)this.bundleContext.getBundle().adapt(BundleWiring.class);
        List fragments = wiring.getProvidedWires("osgi.wiring.host");
        for (BundleWire fragment : fragments) {
            Bundle fragmentBundle = fragment.getRequirerWiring().getBundle();
            String fragmentBundleLocation = fragmentBundle.getDataFile("").getParent();
            this.sqoopBundleFileLocations.add(fragmentBundleLocation);
        }
    }

    private String createHadoopAltClasspath() {
        StringBuilder sb = new StringBuilder();
        for (String bundleFileLocation : this.sqoopBundleFileLocations) {
            File filesInsideBundle = new File(bundleFileLocation);
            Iterator filesIterator = FileUtils.iterateFiles((File)filesInsideBundle, (String[])new String[]{"jar"}, (boolean)true);
            while (filesIterator.hasNext()) {
                File file = (File)filesIterator.next();
                String name = file.getName();
                if (!name.startsWith("hadoop-common") && !name.startsWith("hadoop-mapreduce-client-core") && !name.startsWith("hadoop-core") && !name.startsWith("sqoop")) continue;
                sb.append(file.getAbsolutePath());
                sb.append(File.pathSeparator);
            }
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PigResult runPig(String scriptPath, HadoopClientServices.PigExecutionMode executionMode, List<String> parameters, String name, LogChannelInterface logChannelInterface, VariableSpace variableSpace, LogLevel logLevel) {
        FileObject appenderFile = null;
        try (WriterAppenderManager appenderManager = this.writerAppenderManagerFactory.create(logChannelInterface, logLevel, name);){
            URL scriptU;
            appenderFile = appenderManager.getFile();
            org.pentaho.hadoop.shim.api.internal.Configuration configuration = this.hadoopShim.createConfiguration(this.namedCluster.getName());
            if (executionMode != HadoopClientServices.PigExecutionMode.LOCAL) {
                ArrayList<String> configMessages = new ArrayList<String>();
                this.hadoopShim.configureConnectionInformation(variableSpace.environmentSubstitute(this.namedCluster.getHdfsHost()), variableSpace.environmentSubstitute(this.namedCluster.getHdfsPort()), variableSpace.environmentSubstitute(this.namedCluster.getJobTrackerHost()), variableSpace.environmentSubstitute(this.namedCluster.getJobTrackerPort()), configuration, configMessages);
                if (logChannelInterface != null) {
                    for (String configMessage : configMessages) {
                        logChannelInterface.logBasic(configMessage);
                    }
                }
            }
            String scriptFileS = scriptPath;
            if ((scriptFileS = variableSpace.environmentSubstitute(scriptFileS)).indexOf("://") == -1) {
                File scriptFile = new File(scriptFileS);
                scriptU = scriptFile.toURI().toURL();
            } else {
                scriptU = new URL(scriptFileS);
            }
            String pigScript = this.substitutePigScriptParameters(scriptU, parameters);
            Properties properties = new Properties();
            this.updatePigConfiguration(properties, executionMode == HadoopClientServices.PigExecutionMode.LOCAL ? null : configuration);
            PigResultImpl pigResultImpl = new PigResultImpl(appenderFile, this.executePigScript(pigScript, executionMode == HadoopClientServices.PigExecutionMode.LOCAL ? HadoopClientServices.PigExecutionMode.LOCAL : HadoopClientServices.PigExecutionMode.MAPREDUCE, properties), null);
            return pigResultImpl;
        }
        catch (Exception e) {
            return new PigResultImpl(appenderFile, null, e);
        }
    }

    private void updatePigConfiguration(Properties properties, org.pentaho.hadoop.shim.api.internal.Configuration configuration) {
        PropertiesUtil.loadDefaultProperties((Properties)properties);
        if (configuration != null) {
            properties.putAll((Map<?, ?>)ConfigurationUtil.toProperties((Configuration)ShimUtils.asConfiguration(configuration)));
            properties.setProperty("pig.use.overriden.hadoop.configs", "true");
        }
    }

    private void addExternalJarsToPigContext(PigContext pigContext) throws MalformedURLException {
        File filesInsideBundle = new File(this.bundleContext.getBundle().getDataFile("").getParent());
        Iterator filesIterator = FileUtils.iterateFiles((File)filesInsideBundle, (String[])new String[]{"jar"}, (boolean)true);
        while (filesIterator.hasNext()) {
            File file = (File)filesIterator.next();
            this.addMatchedJarToPigContext(pigContext, file);
        }
    }

    private void addMatchedJarToPigContext(PigContext pigContext, File jarFile) throws MalformedURLException {
        String jarName = jarFile.getName();
        for (ExternalPigJars externalPigJars : ExternalPigJars.values()) {
            if (!jarName.startsWith(externalPigJars.getJarName())) continue;
            String jarPath = jarFile.getAbsolutePath();
            pigContext.addJar(jarPath);
            break;
        }
    }

    private int[] executePigScript(String pigScript, HadoopClientServices.PigExecutionMode mode, Properties properties) throws IOException, ParseException {
        GruntParser grunt = null;
        PigContext pigContext = new PigContext(this.getExecType(mode), properties);
        this.addExternalJarsToPigContext(pigContext);
        PigServer pigServer = new PigServer(pigContext);
        try {
            Constructor constructor = GruntParser.class.getConstructor(Reader.class, PigServer.class);
            grunt = (GruntParser)constructor.newInstance(new StringReader(pigScript), pigServer);
        }
        catch (Exception e) {
            try {
                Constructor constructor = GruntParser.class.getConstructor(Reader.class);
                grunt = (GruntParser)constructor.newInstance(new StringReader(pigScript));
                Method method = grunt.getClass().getMethod("setParams", PigServer.class);
                method.invoke((Object)grunt, pigServer);
            }
            catch (Exception e1) {
                throw new ParseException("Error constructing Grunt Parser in " + this.getClass().getName());
            }
        }
        if (grunt == null) {
            throw new ParseException("Grunt Parser is null in " + this.getClass().getName());
        }
        grunt.setInteractive(false);
        int[] retValues = grunt.parseStopOnError(false);
        return retValues;
    }

    protected ExecType getExecType(HadoopClientServices.PigExecutionMode mode) {
        switch (mode) {
            case LOCAL: {
                return ExecType.LOCAL;
            }
            case MAPREDUCE: {
                return ExecType.MAPREDUCE;
            }
        }
        throw new IllegalStateException("unknown execution mode: " + mode);
    }

    private String substitutePigScriptParameters(URL pigScript, List<String> paramList) throws Exception {
        InputStream inStream = pigScript.openStream();
        StringWriter writer = new StringWriter();
        ParameterSubstitutionPreprocessor psp = new ParameterSubstitutionPreprocessor(50);
        psp.genSubstitutedFile(new BufferedReader(new InputStreamReader(inStream)), (Writer)writer, paramList.size() > 0 ? paramList.toArray(EMPTY_STRING_ARRAY) : null, null);
        return writer.toString();
    }

    public NamedCluster getNamedCluster() {
        return this.namedCluster;
    }

    public HadoopFileSystem getFileSystem(NamedCluster namedCluster, URI uri) throws IOException {
        org.pentaho.hadoop.shim.api.internal.Configuration configuration = this.hadoopShim.createConfiguration(namedCluster.getName());
        FileSystem fileSystem = (FileSystem)this.hadoopShim.getFileSystem(configuration).getDelegate();
        if (fileSystem instanceof LocalFileSystem) {
            LOGGER.error("Got a local filesystem, was expecting an hdfs connection");
            throw new IOException("Got a local filesystem, was expecting an hdfs connection");
        }
        URI finalUri = fileSystem.getUri() != null ? fileSystem.getUri() : uri;
        HadoopFileSystemImpl hadoopFileSystem = new HadoopFileSystemImpl(() -> {
            try {
                return finalUri != null ? (FileSystem)this.hadoopShim.getFileSystem(finalUri, configuration, namedCluster).getDelegate() : (FileSystem)this.hadoopShim.getFileSystem(configuration).getDelegate();
            }
            catch (IOException | InterruptedException e) {
                LOGGER.debug("Error looking up/creating the file system ", (Throwable)e);
                return null;
            }
        });
        hadoopFileSystem.setNamedCluster(namedCluster);
        return hadoopFileSystem;
    }

    protected HBaseConnectionImpl getConnectionImpl(Properties connProps, LogChannelInterface logChannelInterface) throws IOException {
        return new HBaseConnectionImpl(null, this.bytesUtil, connProps, logChannelInterface);
    }

    public HBaseConnection getHBaseConnection(VariableSpace variableSpace, String siteConfig, String defaultConfig, LogChannelInterface logChannelInterface) throws IOException {
        Properties connProps = new Properties();
        String zooKeeperHost = null;
        String zooKeeperPort = null;
        if (this.namedCluster != null) {
            zooKeeperHost = variableSpace.environmentSubstitute(this.namedCluster.getZooKeeperHost());
            zooKeeperPort = variableSpace.environmentSubstitute(this.namedCluster.getZooKeeperPort());
        }
        if (!Const.isEmpty(zooKeeperHost)) {
            connProps.setProperty("hbase.zookeeper.quorum", zooKeeperHost);
        }
        if (!Const.isEmpty(zooKeeperPort)) {
            connProps.setProperty("hbase.zookeeper.property.clientPort", zooKeeperPort);
        }
        if (!Const.isEmpty((String)siteConfig)) {
            connProps.setProperty("hbase.site", siteConfig);
        }
        if (!Const.isEmpty((String)defaultConfig)) {
            connProps.setProperty("hbase.default", defaultConfig);
        }
        connProps.setProperty("named.cluster", this.namedCluster.getName());
        return this.getConnectionImpl(connProps, logChannelInterface);
    }

    public ColumnFilterFactoryImpl getHBaseColumnFilterFactory() {
        return new ColumnFilterFactoryImpl();
    }

    public MappingFactoryImpl getHBaseMappingFactory() {
        return new MappingFactoryImpl(this.bytesUtil, this.getHBaseValueMetaInterfaceFactory());
    }

    public HBaseValueMetaInterfaceFactoryImpl getHBaseValueMetaInterfaceFactory() {
        return new HBaseValueMetaInterfaceFactoryImpl(this.bytesUtil);
    }

    public ByteConversionUtil getHBaseByteConversionUtil() {
        return new ByteConversionUtilImpl(this.bytesUtil);
    }

    public ResultFactory getHBaseResultFactory() {
        return new ResultFactoryImpl(this.bytesUtil);
    }

    private static enum ExternalPigJars {
        PIG("pig"),
        AUTOMATON("automaton"),
        ANTLR("antlr-runtime"),
        GUAVA("guava"),
        JACKSON_CORE("jackson-core-asl"),
        JACKSON_MAPPER("jackson-mapper-asl"),
        JODATIME("joda-time");

        private final String jarName;

        private ExternalPigJars(String jarName) {
            this.jarName = jarName;
        }

        public String getJarName() {
            return this.jarName;
        }
    }
}

