/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.VersionInfo;
import org.pentaho.big.data.api.shims.LegacyShimLocator;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.shim.ShimRuntimeException;
import org.pentaho.hadoop.shim.api.ConfigurationException;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.internal.DistributedCacheUtil;
import org.pentaho.hadoop.shim.api.internal.fs.FileSystem;
import org.pentaho.hadoop.shim.api.internal.mapred.RunningJob;
import org.pentaho.hadoop.shim.common.ConfigurationProxy;
import org.pentaho.hadoop.shim.common.DistributedCacheUtilImpl;
import org.pentaho.hadoop.shim.common.DriverProxyInvocationChain;
import org.pentaho.hadoop.shim.common.ShellPrevalidator;
import org.pentaho.hadoop.shim.common.ShimUtils;
import org.pentaho.hadoop.shim.common.fs.FileSystemProxy;
import org.pentaho.hadoop.shim.spi.HadoopShim;

public class CommonHadoopShim
implements HadoopShim {
    private static final String FS_HDFS_IMPL = "fs.hdfs.impl";
    private static final String FS_FILE_IMPL = "fs.file.impl";
    private static final String IPC_CLIENT_CONNECT_TIMEOUT = "ipc.client.connect.max.retries.on.timeouts";
    private static final String MAPRED_JOB_TRACKER = "mapred.job.tracker";
    private static final String SHIM_NOT_SUPPORTED_DRIVER = "org.pentaho.hadoop.shim.common.CommonHadoopShim$NotSupportedDriver";
    private static final String DEFAULT_NAMENODE_PORT = "9000";
    private static final String DEFAULT_JOBTRACKER_PORT = "9001";
    public static final String PENTAHO_MAPREDUCE_GENERIC_COMBINER_CLASS_NAME = "org.pentaho.hadoop.mapreduce.GenericTransCombiner";
    public static final String PENTAHO_MAPREDUCE_GENERIC_REDUCER_CLASS_NAME = "org.pentaho.hadoop.mapreduce.GenericTransReduce";
    public static final String PENTAHO_MAPREDUCE_RUNNABLE_CLASS_NAME = "org.pentaho.hadoop.mapreduce.PentahoMapRunnable";
    public static final String HADOOPFS_IPC_CLIENT_CONNECT_MAX_RETRIES_ON_TIMEOUTS = "hadoopfs.ipc.client.connect.max.retries.on.timeouts";
    private org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(this.getClass());
    private DistributedCacheUtil dcUtil;
    protected static final Map<String, Class<? extends Driver>> JDBC_DRIVER_MAP = new HashMap<String, Class<? extends Driver>>();
    protected static final Map<String, String> JDBC_POSSIBLE_DRIVER_MAP = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<? extends Driver> tryToLoadDriver(String driverClassName) {
        Class<?> possibleDriver = null;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            possibleDriver = Class.forName(driverClassName);
            if (Driver.class.isAssignableFrom(possibleDriver)) {
                Class<?> clazz = possibleDriver;
                return clazz;
            }
            try {
                throw new ClassCastException("Specified extra driver class does not extends java.sql.Driver");
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ClassCastException e2) {
                this.logger.error((Object)"ClassCastException caught.", (Throwable)e2);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return null;
    }

    @Override
    public String getHadoopVersion() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            String string = VersionInfo.getVersion();
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    @Override
    public Driver getHiveJdbcDriver() {
        return null;
    }

    protected void validateHadoopHomeWithWinutils() {
        try {
            ShellPrevalidator.doesWinutilsFileExist();
        }
        catch (IOException e) {
            this.logger.error((Object)BaseMessages.getString(CommonHadoopShim.class, (String)"CommonHadoopShim.HadoopHomeNotSet", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public Driver getJdbcDriver(String driverType) {
        try {
            Driver newInstance = null;
            Class<? extends Driver> clazz = JDBC_DRIVER_MAP.get(driverType);
            if (clazz != null) {
                newInstance = clazz.newInstance();
                return DriverProxyInvocationChain.getProxy(Driver.class, newInstance);
            }
            clazz = this.tryToLoadDriver(JDBC_POSSIBLE_DRIVER_MAP.get(driverType));
            if (clazz != null) {
                newInstance = clazz.newInstance();
                if (driverType.equals("Impala")) {
                    return DriverProxyInvocationChain.getProxy(Driver.class, newInstance);
                }
                return newInstance;
            }
            return null;
        }
        catch (Exception ex) {
            throw new ShimRuntimeException("Unable to load JDBC driver of type: " + driverType, ex);
        }
    }

    @Override
    public org.pentaho.hadoop.shim.api.internal.Configuration createConfiguration() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            ConfigurationProxy configurationProxy = new ConfigurationProxy();
            return configurationProxy;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public org.pentaho.hadoop.shim.api.internal.Configuration createConfiguration(String namedCluster) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            ConfigurationProxy configurationProxy = new ConfigurationProxy(namedCluster);
            return configurationProxy;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public FileSystem getFileSystem(org.pentaho.hadoop.shim.api.internal.Configuration conf) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        conf.set(FS_HDFS_IMPL, DistributedFileSystem.class.getName());
        conf.set(FS_FILE_IMPL, LocalFileSystem.class.getName());
        Properties legacyPluginProps = LegacyShimLocator.getLegacyBigDataProps();
        String timeoutNum = legacyPluginProps.getProperty(HADOOPFS_IPC_CLIENT_CONNECT_MAX_RETRIES_ON_TIMEOUTS);
        if (null != timeoutNum && !timeoutNum.equals("")) {
            conf.set(IPC_CLIENT_CONNECT_TIMEOUT, timeoutNum);
        }
        try {
            try (FileSystemProxy fsp = new FileSystemProxy(org.apache.hadoop.fs.FileSystem.get((Configuration)ShimUtils.asConfiguration(conf)));){
                FileSystemProxy fileSystemProxy = fsp;
                return fileSystemProxy;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public FileSystem getFileSystem(URI uri, org.pentaho.hadoop.shim.api.internal.Configuration conf, String user) throws IOException, InterruptedException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        conf.set(FS_HDFS_IMPL, DistributedFileSystem.class.getName());
        conf.set(FS_FILE_IMPL, LocalFileSystem.class.getName());
        Properties legacyPluginProps = LegacyShimLocator.getLegacyBigDataProps();
        String timeoutNum = legacyPluginProps.getProperty(HADOOPFS_IPC_CLIENT_CONNECT_MAX_RETRIES_ON_TIMEOUTS);
        if (null != timeoutNum && !timeoutNum.equals("")) {
            conf.set(IPC_CLIENT_CONNECT_TIMEOUT, timeoutNum);
        }
        try {
            try (FileSystemProxy fsp = new FileSystemProxy(org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)ShimUtils.asConfiguration(conf), (String)user));){
                FileSystemProxy fileSystemProxy = fsp;
                return fileSystemProxy;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public FileSystem getFileSystem(URI uri, org.pentaho.hadoop.shim.api.internal.Configuration conf, NamedCluster namedCluster) throws IOException, InterruptedException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        conf.set(FS_HDFS_IMPL, DistributedFileSystem.class.getName());
        conf.set(FS_FILE_IMPL, LocalFileSystem.class.getName());
        Properties legacyPluginProps = LegacyShimLocator.getLegacyBigDataProps();
        String timeoutNum = legacyPluginProps.getProperty(HADOOPFS_IPC_CLIENT_CONNECT_MAX_RETRIES_ON_TIMEOUTS);
        if (null != timeoutNum && !timeoutNum.equals("")) {
            conf.set(IPC_CLIENT_CONNECT_TIMEOUT, timeoutNum);
        }
        try {
            try (FileSystemProxy fsp = new FileSystemProxy(org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)ShimUtils.asConfiguration(conf)));){
                FileSystemProxy fileSystemProxy = fsp;
                return fileSystemProxy;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public void setDistributedCacheUtil(DistributedCacheUtil dcUtilParam) {
        if (dcUtilParam == null) {
            throw new NullPointerException();
        }
        this.dcUtil = dcUtilParam;
    }

    @Override
    public DistributedCacheUtil getDistributedCacheUtil() throws ConfigurationException {
        if (this.dcUtil == null) {
            this.dcUtil = new DistributedCacheUtilImpl();
        }
        return this.dcUtil;
    }

    @Override
    public String[] getNamenodeConnectionInfo(org.pentaho.hadoop.shim.api.internal.Configuration c) {
        URI namenode = org.apache.hadoop.fs.FileSystem.getDefaultUri((Configuration)ShimUtils.asConfiguration(c));
        String[] result = new String[2];
        if (namenode != null) {
            result[0] = namenode.getHost();
            if (namenode.getPort() != -1) {
                result[1] = String.valueOf(namenode.getPort());
            }
        }
        return result;
    }

    @Override
    public String[] getJobtrackerConnectionInfo(org.pentaho.hadoop.shim.api.internal.Configuration c) {
        String[] result = new String[2];
        if (!"local".equals(c.get(MAPRED_JOB_TRACKER, "local"))) {
            InetSocketAddress jobtracker = CommonHadoopShim.getJobTrackerAddress(c);
            result[0] = jobtracker.getHostName();
            result[1] = String.valueOf(jobtracker.getPort());
        }
        return result;
    }

    public static InetSocketAddress getJobTrackerAddress(org.pentaho.hadoop.shim.api.internal.Configuration conf) {
        String jobTrackerStr = conf.get(MAPRED_JOB_TRACKER, "localhost:8012");
        return NetUtils.createSocketAddr((String)jobTrackerStr);
    }

    @Override
    public void configureConnectionInformation(String namenodeHost, String namenodePort, String jobtrackerHost, String jobtrackerPort, org.pentaho.hadoop.shim.api.internal.Configuration conf, List<String> logMessages) throws Exception {
        if (namenodeHost == null || namenodeHost.trim().length() == 0) {
            throw new ConfigurationException("No hdfs host specified!");
        }
        if (jobtrackerHost == null || jobtrackerHost.trim().length() == 0) {
            throw new ConfigurationException("No job tracker host specified!");
        }
        if (namenodePort != null && namenodePort.trim().length() != 0 && !"-1".equals(namenodePort.trim())) {
            namenodePort = ":" + namenodePort;
        } else {
            namenodePort = "";
            logMessages.add("No hdfs port specified - HA? ");
        }
        if (jobtrackerPort == null || jobtrackerPort.trim().length() == 0) {
            jobtrackerPort = this.getDefaultJobtrackerPort();
            logMessages.add("No job tracker port specified - using default: " + jobtrackerPort);
        }
        String fsDefaultName = "hdfs://" + namenodeHost + namenodePort;
        String jobTracker = jobtrackerHost + ":" + jobtrackerPort;
        conf.set("fs.default.name", fsDefaultName);
        conf.set(MAPRED_JOB_TRACKER, jobTracker);
    }

    protected String getDefaultNamenodePort() {
        return DEFAULT_NAMENODE_PORT;
    }

    protected String getDefaultJobtrackerPort() {
        return DEFAULT_JOBTRACKER_PORT;
    }

    @Override
    public RunningJob submitJob(org.pentaho.hadoop.shim.api.internal.Configuration c) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            RunningJob runningJob = c.submit();
            return runningJob;
        }
        catch (ClassNotFoundException e) {
            throw new ShimRuntimeException("Caught ClassNotFoundException.", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ShimRuntimeException("Caught InterruptedException.", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @Override
    public Class[] getHbaseDependencyClasses() {
        return new Class[0];
    }

    public Class<? extends Writable> getHadoopWritableCompatibleClass(ValueMetaInterface kettleType) {
        if (kettleType == null) {
            return NullWritable.class;
        }
        switch (kettleType.getType()) {
            case 2: 
            case 3: 
            case 6: {
                return Text.class;
            }
            case 5: {
                return LongWritable.class;
            }
            case 1: {
                return DoubleWritable.class;
            }
            case 4: {
                return BooleanWritable.class;
            }
            case 8: {
                return BytesWritable.class;
            }
        }
        return Text.class;
    }

    @Override
    public String getPentahoMapReduceCombinerClass() {
        return PENTAHO_MAPREDUCE_GENERIC_COMBINER_CLASS_NAME;
    }

    @Override
    public String getPentahoMapReduceReducerClass() {
        return PENTAHO_MAPREDUCE_GENERIC_REDUCER_CLASS_NAME;
    }

    @Override
    public String getPentahoMapReduceMapRunnerClass() {
        return PENTAHO_MAPREDUCE_RUNNABLE_CLASS_NAME;
    }

    static {
        JDBC_POSSIBLE_DRIVER_MAP.put("hive2Simba", SHIM_NOT_SUPPORTED_DRIVER);
        JDBC_POSSIBLE_DRIVER_MAP.put("ImpalaSimba", SHIM_NOT_SUPPORTED_DRIVER);
        JDBC_POSSIBLE_DRIVER_MAP.put("SparkSqlSimba", SHIM_NOT_SUPPORTED_DRIVER);
        JDBC_POSSIBLE_DRIVER_MAP.put("Impala", "org.apache.hive.jdbc.HiveDriver");
    }

    public static class NotSupportedDriver
    implements Driver {
        public static final SQLException notSupported = new SQLException("Chosen driver is not supported in currently active Hadoop shim");

        @Override
        public Connection connect(String url, Properties info) throws SQLException {
            throw notSupported;
        }

        @Override
        public boolean acceptsURL(String url) throws SQLException {
            throw notSupported;
        }

        @Override
        public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
            throw notSupported;
        }

        @Override
        public int getMajorVersion() {
            return 0;
        }

        @Override
        public int getMinorVersion() {
            return 0;
        }

        @Override
        public boolean jdbcCompliant() {
            return false;
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return null;
        }
    }
}

