/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.parquet.delegate.twitter;

import java.io.IOException;
import java.util.Iterator;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.hadoop.shim.api.format.IPentahoInputFormat;
import parquet.hadoop.ParquetRecordReader;

public class PentahoParquetRecordReader
implements IPentahoInputFormat.IPentahoRecordReader {
    private final ParquetRecordReader<RowMetaAndData> nativeParquetRecordReader;

    public PentahoParquetRecordReader(ParquetRecordReader<RowMetaAndData> parquetReader) {
        this.nativeParquetRecordReader = parquetReader;
    }

    public void close() throws IOException {
        this.nativeParquetRecordReader.close();
    }

    public Iterator<RowMetaAndData> iterator() {
        return new Iterator<RowMetaAndData>(){

            @Override
            public boolean hasNext() {
                try {
                    return PentahoParquetRecordReader.this.nativeParquetRecordReader.nextKeyValue();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("some error while reading parquet file", e);
                }
                catch (InterruptedException e) {
                    throw new IllegalArgumentException("sync error while reading parquet file", e);
                }
            }

            @Override
            public RowMetaAndData next() {
                try {
                    return (RowMetaAndData)PentahoParquetRecordReader.this.nativeParquetRecordReader.getCurrentValue();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("some error while reading parquet file", e);
                }
                catch (InterruptedException e) {
                    throw new IllegalArgumentException("sync error while reading parquet file", e);
                }
            }
        };
    }
}

