/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon.client.impl;

import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import java.util.List;
import java.util.stream.Collectors;
import org.pentaho.amazon.client.api.AimClient;
import org.pentaho.ui.xul.util.AbstractModelList;

public class AimClientImpl
implements AimClient {
    private AmazonIdentityManagement aim;

    public AimClientImpl(AmazonIdentityManagement aim) {
        this.aim = aim;
    }

    @Override
    public AbstractModelList<String> getEc2RolesFromAmazonAccount() {
        List ec2RolesList = this.aim.listInstanceProfiles().getInstanceProfiles();
        AbstractModelList ec2List = ec2RolesList.stream().map(e -> e.getInstanceProfileName()).collect(Collectors.toCollection(AbstractModelList::new));
        return ec2List;
    }

    @Override
    public AbstractModelList<String> getEmrRolesFromAmazonAccount() {
        List emrRolesList = this.aim.listRoles().getRoles();
        AbstractModelList emrList = emrRolesList.stream().filter(e -> e.getAssumeRolePolicyDocument().contains("elasticmapreduce")).map(e -> e.getRoleName()).collect(Collectors.toCollection(AbstractModelList::new));
        return emrList;
    }
}

