/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.factory;

import java.io.IOException;
import java.io.InputStream;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.factory.FactoryModule;

public abstract class AbstractFactoryModule
implements FactoryModule {
    protected AbstractFactoryModule() {
    }

    protected abstract int[] getFingerPrint();

    protected abstract String[] getMimeTypes();

    protected abstract String[] getFileExtensions();

    @Override
    public int getHeaderFingerprintSize() {
        int[] fingerPrint = this.getFingerPrint();
        if (fingerPrint == null) {
            return 0;
        }
        return fingerPrint.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int canHandleResource(ResourceManager caller, ResourceData data) throws ResourceCreationException, ResourceLoadingException {
        try {
            InputStream asStream = data.getResourceAsStream(caller);
            try {
                if (this.getHeaderFingerprintSize() != 0) {
                    if (this.canHandleResourceByContent(asStream)) {
                        int n = 4000;
                        return n;
                    }
                    int n = -1;
                    return n;
                }
                String mimeType = (String)data.getAttribute("content-type");
                if (mimeType != null && this.canHandleResourceByMimeType(mimeType)) {
                    int n = 2000;
                    return n;
                }
                String fileName = (String)data.getAttribute("filename");
                if (fileName != null && this.canHandleResourceByName(fileName)) {
                    int n = 1000;
                    return n;
                }
                if (this.getHeaderFingerprintSize() != 0) {
                    int n = 0;
                    return n;
                }
                int n = -1;
                return n;
            }
            finally {
                asStream.close();
            }
        }
        catch (ResourceLoadingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceCreationException("Failed to load or check content", e);
        }
    }

    protected boolean canHandleResourceByContent(InputStream data) throws IOException {
        int[] fingerprint = this.getFingerPrint();
        if (fingerprint.length == 0) {
            return false;
        }
        for (int i = 0; i < fingerprint.length; ++i) {
            if (fingerprint[i] == data.read()) continue;
            return false;
        }
        return true;
    }

    protected boolean canHandleResourceByMimeType(String name) {
        String[] mimes = this.getMimeTypes();
        for (int i = 0; i < mimes.length; ++i) {
            if (!name.equals(mimes[i])) continue;
            return true;
        }
        int idx = name.indexOf(59);
        if (idx > 0) {
            return this.canHandleResourceByMimeType(name.substring(0, idx));
        }
        return false;
    }

    protected boolean canHandleResourceByName(String name) {
        String[] fexts = this.getFileExtensions();
        for (int i = 0; i < fexts.length; ++i) {
            if (!StringUtils.endsWithIgnoreCase((String)name, (String)fexts[i])) continue;
            return true;
        }
        return false;
    }
}

