/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.importer.IPlatformImportBundle;
import org.pentaho.platform.plugin.services.importer.IPlatformImportHandler;
import org.pentaho.platform.plugin.services.importer.IPlatformImporter;
import org.pentaho.platform.plugin.services.importer.LocaleFilesProcessor;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportBundle;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportFileHandler;
import org.pentaho.platform.plugin.services.importer.mimeType.MimeType;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class PRPTImportHandler
extends RepositoryFileImportFileHandler
implements IPlatformImportHandler {
    private static final Log log = LogFactory.getLog(PRPTImportHandler.class);
    private final String rootElement = "/office:document-meta/office:meta";

    public PRPTImportHandler(List<MimeType> mimeTypes) {
        super(mimeTypes);
    }

    @Override
    public void importFile(IPlatformImportBundle bundle) throws PlatformImportException {
        RepositoryFileImportBundle importBundle = (RepositoryFileImportBundle)bundle;
        LocaleFilesProcessor localeFilesProcessor = new LocaleFilesProcessor();
        IPlatformImporter importer = (IPlatformImporter)PentahoSystem.get(IPlatformImporter.class);
        String fileName = importBundle.getName();
        String filePath = importBundle.getPath().equals("/") || importBundle.getPath().equals("\\") ? "" : importBundle.getPath();
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)bundle.getInputStream());
            ByteArrayInputStream bundleInputStream = new ByteArrayInputStream(bytes);
            importBundle.setInputStream(bundleInputStream);
            boolean hidden = this.extractMetaData(localeFilesProcessor, bytes, filePath, fileName, importBundle.getFile());
            importBundle.setHidden(hidden);
            super.importFile(importBundle);
            localeFilesProcessor.processLocaleFiles(importer);
        }
        catch (Exception ex) {
            throw new PlatformImportException(ex.getMessage(), ex);
        }
    }

    private boolean extractMetaData(LocaleFilesProcessor localeFilesProcessor, byte[] bytes, String filePath, String fileName, RepositoryFile rf) throws IOException, PlatformImportException {
        try {
            String title;
            ResourceManager mgr = new ResourceManager();
            MasterReport report = (MasterReport)mgr.createDirectly((Object)bytes, MasterReport.class).getResource();
            DocumentMetaData metaData = report.getBundle().getMetaData();
            String description = (String)metaData.getBundleAttribute("http://purl.org/dc/elements/1.1/", "description");
            if (StringUtils.isEmpty((String)description, (boolean)true)) {
                description = null;
            }
            if (StringUtils.isEmpty((String)(title = (String)metaData.getBundleAttribute("http://purl.org/dc/elements/1.1/", "title")), (boolean)true)) {
                title = null;
            }
            if (title != null || description != null) {
                localeFilesProcessor.createLocaleEntry(filePath, fileName, title, description, rf, new ByteArrayInputStream("".getBytes()));
            }
            return "false".equals(metaData.getBundleAttribute("http://reporting.pentaho.org/namespaces/engine/classic/metadata/1.0", "visible"));
        }
        catch (ResourceException e) {
            throw new PlatformImportException("An unexpected error occurred while parsing a report definition", e);
        }
    }
}

