/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.hibernate;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.exception.ConstraintViolationException;
import org.pentaho.platform.api.data.IDBDatasourceService;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.IPentahoSystemEntryPoint;
import org.pentaho.platform.api.engine.IPentahoSystemExitPoint;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.repository.ContentException;
import org.pentaho.platform.api.repository.ISearchable;
import org.pentaho.platform.api.repository.RepositoryException;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.JndiDatasourceService;
import org.pentaho.platform.engine.services.solution.PentahoEntityResolver;
import org.pentaho.platform.repository.hibernate.HibernateLoadEventListener;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.platform.util.messages.MessageUtil;
import org.xml.sax.EntityResolver;

public class HibernateUtil
implements IPentahoSystemEntryPoint,
IPentahoSystemExitPoint {
    private static final Log log = LogFactory.getLog(HibernateUtil.class);
    private static final boolean debug = true;
    private static boolean useNewDatasourceService = false;
    private static Configuration configuration;
    private static SessionFactory sessionFactory;
    private static final byte[] lock;
    private static final ThreadLocal<Session> threadSession;
    private static final ThreadLocal<Transaction> threadTransaction;
    private static final ThreadLocal<Interceptor> threadInterceptor;
    private static boolean hibernateManaged;
    private static String factoryJndiName;
    private static String dialect;
    private static Context iniCtx;
    private static final String QUERYWILDCARD = "%{0}%";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseNewDatasourceService(boolean useNewService) {
        byte[] byArray = lock;
        synchronized (lock) {
            useNewDatasourceService = useNewService;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private HibernateUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean initialize() {
        IApplicationContext applicationContext = PentahoSystem.getApplicationContext();
        HibernateUtil hUtil = new HibernateUtil();
        applicationContext.addEntryPointHandler((IPentahoSystemEntryPoint)hUtil);
        applicationContext.addExitPointHandler((IPentahoSystemExitPoint)hUtil);
        String hibernateConfigurationFile = HibernateUtil.lookupSetting(applicationContext, "hibernateConfigPath", "settings/config-file", "hibernate/hibernateConfigPath");
        String hibernateManagedString = HibernateUtil.lookupSetting(applicationContext, "hibernateManaged", "settings/managed", "hibernate/hibernateManaged");
        if (hibernateManagedString != null) {
            hibernateManaged = Boolean.parseBoolean(hibernateManagedString);
        }
        try {
            configuration = new Configuration();
            configuration.setEntityResolver((EntityResolver)new PentahoEntityResolver());
            configuration.setListener("load", (Object)new HibernateLoadEventListener());
            if (hibernateConfigurationFile != null) {
                String configPath = applicationContext.getSolutionPath(hibernateConfigurationFile);
                File cfgFile = new File(configPath);
                if (!cfgFile.exists()) {
                    log.error((Object)Messages.getInstance().getErrorString("HIBUTIL.ERROR_0012_CONFIG_NOT_FOUND", new Object[]{configPath}));
                    return false;
                }
                configuration.configure(cfgFile);
            } else {
                log.error((Object)Messages.getInstance().getErrorString("HIBUTIL.ERROR_0420_CONFIGURATION_ERROR_NO_HIB_CFG_FILE_SETTING"));
                configuration.configure();
            }
            String dsName = configuration.getProperty("connection.datasource");
            if (dsName != null && dsName.toUpperCase().endsWith("HIBERNATE")) {
                IDBDatasourceService datasourceService = HibernateUtil.getDatasourceService();
                String actualDSName = datasourceService.getDSBoundName("Hibernate");
                configuration.setProperty("hibernate.connection.datasource", actualDSName);
            }
            dialect = configuration.getProperty("dialect");
            if (!hibernateManaged) {
                log.info((Object)Messages.getInstance().getString("HIBUTIL.USER_HIBERNATEUNMANAGED"));
                sessionFactory = configuration.buildSessionFactory();
            } else {
                factoryJndiName = configuration.getProperty("hibernate.session_factory_name");
                if (factoryJndiName == null) {
                    log.error((Object)Messages.getInstance().getErrorString("HIBUTIL.ERROR_0013_NO_SESSION_FACTORY"));
                    return false;
                }
                log.info((Object)Messages.getInstance().getString("HIBUTIL.USER_HIBERNATEMANAGED"));
                configuration.buildSessionFactory();
                Properties contextProperties = new Properties();
                if (configuration.getProperty("hibernate.jndi.url") != null) {
                    contextProperties.put("java.naming.provider.url", configuration.getProperty("hibernate.jndi.url"));
                }
                if (configuration.getProperty("hibernate.jndi.class") != null) {
                    contextProperties.put("java.naming.factory.initial", configuration.getProperty("hibernate.jndi.class"));
                }
                iniCtx = new InitialContext(contextProperties);
            }
            Dialect.getDialect((Properties)configuration.getProperties());
            return true;
        }
        catch (Throwable ex) {
            log.error((Object)Messages.getInstance().getErrorString("HIBUTIL.ERROR_0006_BUILD_SESSION_FACTORY"), ex);
            throw new ExceptionInInitializerError(ex);
        }
    }

    private static IDBDatasourceService getDatasourceService() throws ObjectFactoryException {
        if (!useNewDatasourceService) {
            return new JndiDatasourceService();
        }
        IDBDatasourceService datasourceService = (IDBDatasourceService)PentahoSystem.getObjectFactory().get(IDBDatasourceService.class, null);
        return datasourceService;
    }

    private static String lookupSetting(IApplicationContext applicationContext, String applicationContextName, String hibernateSettingsName, String pentahoXmlName) {
        String tmp = null;
        tmp = applicationContext.getProperty(applicationContextName, null);
        if (tmp != null && !StringUtil.isEmpty((String)tmp)) {
            return tmp.trim();
        }
        if (tmp == null && (tmp = PentahoSystem.getSystemSetting((String)"hibernate/hibernate-settings.xml", (String)hibernateSettingsName, null)) != null && !StringUtil.isEmpty((String)tmp)) {
            return tmp.trim();
        }
        if (tmp == null && (tmp = PentahoSystem.getSystemSetting((String)pentahoXmlName, null)) != null && !StringUtil.isEmpty((String)tmp)) {
            return tmp.trim();
        }
        return null;
    }

    public static SessionFactory getSessionFactory() {
        if (!hibernateManaged) {
            return sessionFactory;
        }
        SessionFactory sf = null;
        try {
            if (iniCtx == null) {
                iniCtx = new InitialContext();
            }
            String jndiName = factoryJndiName;
            try {
                sf = (SessionFactory)iniCtx.lookup(jndiName);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (sf == null) {
                try {
                    sf = (SessionFactory)iniCtx.lookup("java:" + jndiName);
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                }
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return sf;
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rebuildSessionFactory() throws RepositoryException {
        if (!hibernateManaged) {
            byte[] byArray = lock;
            synchronized (lock) {
                try {
                    sessionFactory = HibernateUtil.getConfiguration().buildSessionFactory();
                }
                catch (Exception ex) {
                    log.error((Object)Messages.getInstance().getErrorString("HIBUTIL.ERROR_0007_REBUILD_SESSION_FACTORY"), (Throwable)ex);
                    throw new RepositoryException(Messages.getInstance().getErrorString("HIBUTIL.ERROR_0007_REBUILD_SESSION_FACTORY"), (Throwable)ex);
                }
            }
        }
        try {
            HibernateUtil.getConfiguration().buildSessionFactory();
        }
        catch (Exception ex) {
            log.error((Object)Messages.getInstance().getErrorString("HIBUTIL.ERROR_0007_REBUILD_SESSION_FACTORY"), (Throwable)ex);
            throw new RepositoryException(Messages.getInstance().getErrorString("HIBUTIL.ERROR_0007_REBUILD_SESSION_FACTORY"), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rebuildSessionFactory(Configuration cfg) throws RepositoryException {
        if (!hibernateManaged) {
            byte[] byArray = lock;
            synchronized (lock) {
                try {
                    sessionFactory = cfg.buildSessionFactory();
                    configuration = cfg;
                }
                catch (Exception ex) {
                    log.error((Object)Messages.getInstance().getErrorString("HIBUTIL.ERROR_0007_REBUILD_SESSION_FACTORY"), (Throwable)ex);
                    throw new RepositoryException(Messages.getInstance().getErrorString("HIBUTIL.ERROR_0007_REBUILD_SESSION_FACTORY"), (Throwable)ex);
                }
            }
        }
        try {
            cfg.buildSessionFactory();
            configuration = cfg;
        }
        catch (Exception ex) {
            log.error((Object)Messages.getInstance().getErrorString("HIBUTIL.ERROR_0007_REBUILD_SESSION_FACTORY"), (Throwable)ex);
            throw new RepositoryException(Messages.getInstance().getErrorString("HIBUTIL.ERROR_0007_REBUILD_SESSION_FACTORY"), (Throwable)ex);
        }
    }

    public static Session getSession() throws RepositoryException {
        Session s = threadSession.get();
        try {
            if (s == null) {
                log.debug((Object)Messages.getInstance().getString("HIBUTIL.DEBUG_OPEN_NEW_SESSION"));
                if (HibernateUtil.getInterceptor() != null) {
                    log.debug((Object)(Messages.getInstance().getString("HIBUTIL.DEBUG_USING_INTERCEPTOR") + HibernateUtil.getInterceptor().getClass()));
                    s = HibernateUtil.getSessionFactory().openSession(HibernateUtil.getInterceptor());
                } else {
                    s = HibernateUtil.getSessionFactory().openSession();
                }
                threadSession.set(s);
            }
        }
        catch (HibernateException ex) {
            log.error((Object)Messages.getInstance().getErrorString("HIBUTIL.ERROR_0005_GET_SESSION"), (Throwable)ex);
            throw new RepositoryException(Messages.getInstance().getErrorString("HIBUTIL.ERROR_0005_GET_SESSION"), (Throwable)ex);
        }
        return s;
    }

    public static void flushSession() throws RepositoryException {
        try {
            Session s = HibernateUtil.getSession();
            s.flush();
        }
        catch (HibernateException ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public static void closeSession() throws RepositoryException {
        try {
            Session s = threadSession.get();
            threadSession.set(null);
            if (s != null && s.isOpen()) {
                log.debug((Object)Messages.getInstance().getString("HIBUTIL.DEBUG_CLOSING_SESSION"));
                s.close();
            }
            threadTransaction.set(null);
        }
        catch (HibernateException ex) {
            log.error((Object)Messages.getInstance().getErrorString("HIBUTIL.ERROR_0009_CLOSE_SESSION"), (Throwable)ex);
            threadTransaction.set(null);
            throw new RepositoryException(Messages.getInstance().getErrorString("HIBUTIL.ERROR_0009_CLOSE_SESSION"), (Throwable)ex);
        }
    }

    public static void beginTransaction() throws RepositoryException {
        Transaction tx = threadTransaction.get();
        try {
            if (tx == null) {
                log.debug((Object)Messages.getInstance().getString("HIBUTIL.DEBUG_START_TRANS"));
                tx = HibernateUtil.getSession().beginTransaction();
                threadTransaction.set(tx);
            }
        }
        catch (HibernateException ex) {
            log.error((Object)Messages.getInstance().getErrorString("HIBUTIL.ERROR_0004_START_TRANS"), (Throwable)ex);
            throw new RepositoryException(Messages.getInstance().getErrorString("HIBUTIL.ERROR_0004_START_TRANS"), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void commitTransaction() throws RepositoryException {
        Transaction tx = threadTransaction.get();
        try {
            if (tx != null && !tx.wasCommitted() && !tx.wasRolledBack()) {
                log.debug((Object)Messages.getInstance().getString("HIBUTIL.DEBUG_COMMIT_TRANS"));
                tx.commit();
            }
        }
        catch (HibernateException ex) {
            log.error((Object)Messages.getInstance().getErrorString("HIBUTIL.ERROR_0008_COMMIT_TRANS"), (Throwable)ex);
            try {
                HibernateUtil.rollbackTransaction();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ex instanceof ConstraintViolationException) {
                throw new RepositoryException(Messages.getInstance().getErrorString("HIBUTIL.ERROR_0008_COMMIT_TRANS"), (Throwable)ex);
            }
        }
        finally {
            threadTransaction.set(null);
        }
    }

    public static void rollbackTransaction() throws RepositoryException {
        Transaction tx = threadTransaction.get();
        try {
            threadTransaction.set(null);
            if (tx != null && !tx.wasCommitted() && !tx.wasRolledBack()) {
                log.debug((Object)Messages.getInstance().getString("HIBUTIL.DEBUG_ROLLBACK"));
                tx.rollback();
            }
        }
        catch (HibernateException ex) {
            log.error((Object)Messages.getInstance().getErrorString("HIBUTIL.ERROR_0003_ROLLBACK"), (Throwable)ex);
            throw new RepositoryException(Messages.getInstance().getErrorString("HIBUTIL.ERROR_0003_ROLLBACK"), (Throwable)ex);
        }
        finally {
            HibernateUtil.closeSession();
        }
    }

    public static Session disconnectSession() throws RepositoryException {
        Session session = HibernateUtil.getSession();
        try {
            threadSession.set(null);
            if (session.isConnected() && session.isOpen()) {
                session.disconnect();
            }
        }
        catch (HibernateException ex) {
            log.error((Object)Messages.getInstance().getErrorString("HIBUTIL.ERROR_0002_DISCONNECT"), (Throwable)ex);
            throw new RepositoryException(Messages.getInstance().getErrorString("HIBUTIL.ERROR_0002_DISCONNECT"), (Throwable)ex);
        }
        return session;
    }

    public static void registerInterceptor(Interceptor interceptor) {
        threadInterceptor.set(interceptor);
    }

    private static Interceptor getInterceptor() {
        Interceptor interceptor = threadInterceptor.get();
        return interceptor;
    }

    public static List searchForTerm(ISearchable searchable, String searchTerm, int searchType) {
        Session session = HibernateUtil.getSession();
        if (searchType == 0) {
            Query qry = session.getNamedQuery(searchable.getPhraseSearchQueryName());
            String searchWildcard = MessageUtil.formatErrorMessage((String)QUERYWILDCARD, (String)searchTerm);
            qry.setString("searchTerm", searchWildcard);
            List rtn = qry.list();
            return rtn;
        }
        String connector = searchType == 2 ? " and " : " or ";
        StringTokenizer st = new StringTokenizer(searchTerm, " ");
        ArrayList<String> searchWords = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            searchWords.add(MessageUtil.formatErrorMessage((String)QUERYWILDCARD, (String)st.nextToken()));
        }
        StringBuffer assembly = HibernateUtil.assembleQuery(searchable.getSearchableTable(), connector, searchWords, searchable.getSearchableColumns());
        Query qry = session.createQuery(assembly.toString());
        for (int j = 0; j < searchWords.size(); ++j) {
            qry.setParameter("searchTerm" + j, searchWords.get(j));
        }
        List rtn = qry.list();
        return rtn;
    }

    private static StringBuffer assembleQuery(String tableName, String connector, List<String> terms, String[] columns) {
        StringBuffer qry = new StringBuffer();
        qry.append("from ").append(tableName).append(" tbl where ");
        for (int colno = 0; colno < columns.length; ++colno) {
            String currCol = columns[colno];
            qry.append("(");
            for (int termNo = 0; termNo < terms.size(); ++termNo) {
                String term = terms.get(termNo);
                qry.append("tbl.").append(currCol).append(" like :searchTerm").append(term).append(" ");
                if (termNo >= terms.size() - 1) continue;
                qry.append(connector);
            }
            qry.append(")");
            if (colno >= columns.length - 1) continue;
            qry.append(" or ");
        }
        return qry;
    }

    public static void clear() {
        HibernateUtil.getSession().clear();
    }

    public static void makePersistent(Object obj) throws RepositoryException {
        log.debug((Object)Messages.getInstance().getString("HIBUTIL.DEBUG_MAKE_PERSISTENT", new Object[]{obj.toString()}));
        try {
            HibernateUtil.getSession().saveOrUpdate(obj);
        }
        catch (HibernateException ex) {
            log.error((Object)Messages.getInstance().getErrorString("HIBUTIL.ERROR_0010_SAVING_UPDATING"), (Throwable)ex);
            throw new ContentException(Messages.getInstance().getErrorString("HIBUTIL.ERROR_0010_SAVING_UPDATING"), (Throwable)ex);
        }
    }

    public static void makeTransient(Object obj) throws RepositoryException {
        log.debug((Object)Messages.getInstance().getString("HIBUTIL.DEBUG_MAKE_TRANSIENT", new Object[]{obj.toString()}));
        try {
            HibernateUtil.getSession().delete(obj);
        }
        catch (HibernateException ex) {
            log.error((Object)Messages.getInstance().getErrorString("HIBUTIL.ERROR_0011_DELETING_OBJ"), (Throwable)ex);
            throw new ContentException(Messages.getInstance().getErrorString("HIBUTIL.ERROR_0011_DELETING_OBJ"), (Throwable)ex);
        }
    }

    public static boolean isOracleDialect() {
        return dialect.indexOf("oracle") >= 0 || dialect.indexOf("Oracle") >= 0 || dialect.indexOf("ORACLE") >= 0;
    }

    public static void evict(Object obj) {
        try {
            HibernateUtil.getSession().evict(obj);
        }
        catch (HibernateException ex) {
            log.error((Object)Messages.getInstance().getErrorString("HIBUTIL.ERROR_0014_EVICTING_OBJECT"), (Throwable)ex);
        }
    }

    public void systemEntryPoint() {
    }

    public void systemExitPoint() {
        try {
            HibernateUtil.commitTransaction();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            HibernateUtil.closeSession();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static {
        lock = new byte[0];
        threadSession = new ThreadLocal();
        threadTransaction = new ThreadLocal();
        threadInterceptor = new ThreadLocal();
        HibernateUtil.initialize();
    }
}

