/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.usersettings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.usersettings.IUserSettingService;
import org.pentaho.platform.api.usersettings.pojo.IUserSetting;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.repository.usersettings.pojo.UserSetting;
import org.pentaho.platform.repository2.ClientRepositoryPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSettingService
implements IUserSettingService {
    public static final String SETTING_PREFIX = "_USERSETTING";
    IPentahoSession session = null;
    private static final byte[] lock = new byte[0];
    protected IUnifiedRepository repository;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public UserSettingService(IUnifiedRepository repository) {
        this.repository = repository;
    }

    public void init(IPentahoSession session) {
        this.session = session;
    }

    public void deleteUserSettings() {
        String homePath = ClientRepositoryPaths.getUserHomeFolderPath(PentahoSessionHolder.getSession().getName());
        Serializable id = this.repository.getFile(homePath).getId();
        Map fileMetadata = this.repository.getFileMetadata(id);
        HashMap finalMetadata = new HashMap();
        for (String key : fileMetadata.keySet()) {
            if (key.startsWith(SETTING_PREFIX)) continue;
            finalMetadata.put(key, fileMetadata.get(key));
        }
        this.repository.setFileMetadata(id, finalMetadata);
    }

    public List<IUserSetting> getUserSettings() {
        ArrayList<IUserSetting> userSettings = new ArrayList<IUserSetting>();
        String tentantHomePath = ClientRepositoryPaths.getEtcFolderPath();
        Serializable tenantHomeId = this.repository.getFile(tentantHomePath).getId();
        Map tenantMetadata = this.repository.getFileMetadata(tenantHomeId);
        for (String key : tenantMetadata.keySet()) {
            if (!key.startsWith(SETTING_PREFIX)) continue;
            UserSetting setting = new UserSetting();
            setting.setSettingName(key.substring(SETTING_PREFIX.length()));
            setting.setSettingValue(((Serializable)tenantMetadata.get(key)).toString());
            userSettings.add(setting);
        }
        String homePath = ClientRepositoryPaths.getUserHomeFolderPath(PentahoSessionHolder.getSession().getName());
        Serializable userHomeId = this.repository.getFile(homePath).getId();
        Map userMetadata = this.repository.getFileMetadata(userHomeId);
        for (String key : userMetadata.keySet()) {
            if (!key.startsWith(SETTING_PREFIX)) continue;
            UserSetting setting = new UserSetting();
            setting.setSettingName(key.substring(SETTING_PREFIX.length()));
            setting.setSettingValue(((Serializable)userMetadata.get(key)).toString());
            if (userSettings.contains(setting)) {
                userSettings.remove(setting);
            }
            userSettings.add(setting);
        }
        return userSettings;
    }

    public IUserSetting getUserSetting(String settingName, String defaultValue) {
        boolean hasAuth;
        boolean bl = hasAuth = PentahoSessionHolder.getSession().getAttribute("SPRING_SECURITY_CONTEXT") != null;
        if (hasAuth) {
            try {
                String homePath = ClientRepositoryPaths.getUserHomeFolderPath(PentahoSessionHolder.getSession().getName());
                Serializable userHomeId = this.repository.getFile(homePath).getId();
                Map userMetadata = this.repository.getFileMetadata(userHomeId);
                for (String key : userMetadata.keySet()) {
                    if (!key.startsWith(SETTING_PREFIX)) continue;
                    UserSetting setting = new UserSetting();
                    setting.setSettingName(key.substring(SETTING_PREFIX.length()));
                    setting.setSettingValue(((Serializable)userMetadata.get(key)).toString());
                    if (!setting.getSettingName().equals(settingName)) continue;
                    return setting;
                }
                String tentantHomePath = ClientRepositoryPaths.getEtcFolderPath();
                Serializable tenantHomeId = this.repository.getFile(tentantHomePath).getId();
                Map tenantMetadata = this.repository.getFileMetadata(tenantHomeId);
                for (String key : tenantMetadata.keySet()) {
                    if (!key.startsWith(SETTING_PREFIX)) continue;
                    UserSetting setting = new UserSetting();
                    setting.setSettingName(key.substring(SETTING_PREFIX.length()));
                    setting.setSettingValue(((Serializable)tenantMetadata.get(key)).toString());
                    if (!setting.getSettingName().equals(settingName)) continue;
                    return setting;
                }
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        UserSetting defaultSetting = new UserSetting();
        defaultSetting.setSettingName(settingName);
        defaultSetting.setSettingValue(defaultValue);
        return defaultSetting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserSetting(String settingName, String settingValue) {
        String name = PentahoSessionHolder.getSession().getName();
        String homePath = ClientRepositoryPaths.getUserHomeFolderPath(name);
        byte[] byArray = lock;
        synchronized (lock) {
            final Serializable id = this.repository.getFile(homePath).getId();
            final Map fileMetadata = this.repository.getFileMetadata(id);
            if (fileMetadata.containsKey(SETTING_PREFIX + settingName)) {
                fileMetadata.remove(SETTING_PREFIX + settingName);
            }
            fileMetadata.put(SETTING_PREFIX + settingName, settingValue);
            try {
                SecurityHelper.getInstance().runAsSystem((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        UserSettingService.this.repository.setFileMetadata(id, fileMetadata);
                        return null;
                    }
                });
            }
            catch (Exception e) {
                this.log.debug("Error storing user setting for user: " + name + ", setting: " + settingName + ", value: " + settingValue, (Throwable)e);
                this.log.error("Error storing user setting", (Throwable)e);
            }
            return;
        }
    }

    public IUserSetting getGlobalUserSetting(String settingName, String defaultValue) {
        String tentantHomePath = ClientRepositoryPaths.getEtcFolderPath();
        Serializable tenantHomeId = this.repository.getFile(tentantHomePath).getId();
        Map tenantMetadata = this.repository.getFileMetadata(tenantHomeId);
        if (tenantMetadata.containsKey(SETTING_PREFIX + settingName)) {
            UserSetting setting = new UserSetting();
            setting.setSettingName(settingName);
            setting.setSettingValue(((Serializable)tenantMetadata.get(SETTING_PREFIX + settingName)).toString());
            return setting;
        }
        UserSetting defaultSetting = new UserSetting();
        defaultSetting.setSettingName(settingName);
        defaultSetting.setSettingValue(defaultValue);
        return defaultSetting;
    }

    public List<IUserSetting> getGlobalUserSettings() {
        ArrayList<IUserSetting> userSettings = new ArrayList<IUserSetting>();
        String tentantHomePath = ClientRepositoryPaths.getEtcFolderPath();
        Serializable tenantHomeId = this.repository.getFile(tentantHomePath).getId();
        Map tenantMetadata = this.repository.getFileMetadata(tenantHomeId);
        for (String key : tenantMetadata.keySet()) {
            if (!key.startsWith(SETTING_PREFIX)) continue;
            UserSetting setting = new UserSetting();
            setting.setSettingName(key.substring(SETTING_PREFIX.length()));
            setting.setSettingValue(((Serializable)tenantMetadata.get(key)).toString());
            userSettings.add(setting);
        }
        return userSettings;
    }

    public void setGlobalUserSetting(String settingName, String settingValue) {
        if (SecurityHelper.getInstance().isPentahoAdministrator(this.session)) {
            String tentantHomePath = ClientRepositoryPaths.getEtcFolderPath();
            Serializable tenantHomeId = this.repository.getFile(tentantHomePath).getId();
            Map tenantMetadata = this.repository.getFileMetadata(tenantHomeId);
            if (tenantMetadata.containsKey(SETTING_PREFIX + settingName)) {
                tenantMetadata.remove(SETTING_PREFIX + settingName);
            }
            tenantMetadata.put(SETTING_PREFIX + settingName, settingValue);
            this.repository.setFileMetadata(tenantHomeId, tenantMetadata);
        }
    }
}

