/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.webservices;

import java.util.ArrayList;
import java.util.List;
import javax.jws.WebService;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.platform.api.repository.datasource.DatasourceMgmtServiceException;
import org.pentaho.platform.api.repository.datasource.IDatasourceMgmtService;
import org.pentaho.platform.api.repository.datasource.NonExistingDatasourceException;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository.webservices.DatabaseConnectionAdapter;
import org.pentaho.platform.repository.webservices.DatabaseConnectionDto;
import org.pentaho.platform.repository.webservices.IDatasourceMgmtWebService;

@WebService(endpointInterface="org.pentaho.platform.repository.webservices.IDatasourceMgmtWebService", serviceName="datasourceMgmtService", portName="datasourceMgmtServicePort", targetNamespace="http://www.pentaho.org/ws/1.0")
public class DefaultDatasourceMgmtWebService
implements IDatasourceMgmtWebService {
    protected IDatasourceMgmtService datasourceMgmtService;
    private DatabaseConnectionAdapter databaseConnectionAdapter = new DatabaseConnectionAdapter();

    public DefaultDatasourceMgmtWebService() {
        this.datasourceMgmtService = (IDatasourceMgmtService)PentahoSystem.get(IDatasourceMgmtService.class);
        if (this.datasourceMgmtService == null) {
            throw new IllegalStateException();
        }
    }

    public DefaultDatasourceMgmtWebService(IDatasourceMgmtService datasourceMgmtService) {
        this.datasourceMgmtService = datasourceMgmtService;
    }

    @Override
    public String createDatasource(DatabaseConnectionDto dbConnDto) {
        try {
            return this.datasourceMgmtService.createDatasource((IDatabaseConnection)this.databaseConnectionAdapter.unmarshal(dbConnDto));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteDatasourceByName(String name) {
        try {
            this.datasourceMgmtService.deleteDatasourceByName(name);
        }
        catch (NonExistingDatasourceException e) {
            e.printStackTrace();
        }
        catch (DatasourceMgmtServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DatabaseConnectionDto getDatasourceByName(String name) {
        try {
            return this.databaseConnectionAdapter.marshal((DatabaseConnection)this.datasourceMgmtService.getDatasourceByName(name));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public List<DatabaseConnectionDto> getDatasources() {
        ArrayList<DatabaseConnectionDto> databaseConnections = new ArrayList<DatabaseConnectionDto>();
        try {
            for (IDatabaseConnection databaseConnection : this.datasourceMgmtService.getDatasources()) {
                try {
                    databaseConnections.add(this.databaseConnectionAdapter.marshal((DatabaseConnection)databaseConnection));
                }
                catch (Exception e) {}
            }
        }
        catch (DatasourceMgmtServiceException e) {
            throw new RuntimeException(e);
        }
        return databaseConnections;
    }

    @Override
    public String updateDatasourceByName(String name, DatabaseConnectionDto databaseConnectionDto) {
        try {
            return this.datasourceMgmtService.updateDatasourceByName(name, (IDatabaseConnection)this.databaseConnectionAdapter.unmarshal(databaseConnectionDto));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteDatasourceById(String id) {
        try {
            this.datasourceMgmtService.deleteDatasourceById(id);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DatabaseConnectionDto getDatasourceById(String id) {
        try {
            return this.databaseConnectionAdapter.marshal((DatabaseConnection)this.datasourceMgmtService.getDatasourceById(id));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> getDatasourceIds() {
        try {
            return this.datasourceMgmtService.getDatasourceIds();
        }
        catch (DatasourceMgmtServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String updateDatasourceById(String id, DatabaseConnectionDto databaseConnection) {
        try {
            return this.datasourceMgmtService.updateDatasourceById(id, (IDatabaseConnection)this.databaseConnectionAdapter.unmarshal(databaseConnection));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

