/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema.concept;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.pentaho.di.core.changed.ChangedFlag;
import org.pentaho.pms.core.event.AllowsIDChangeListenersInterface;
import org.pentaho.pms.core.event.IDChangedEvent;
import org.pentaho.pms.core.event.IDChangedListener;
import org.pentaho.pms.messages.Messages;
import org.pentaho.pms.schema.DefaultProperty;
import org.pentaho.pms.schema.RequiredProperties;
import org.pentaho.pms.schema.concept.Concept;
import org.pentaho.pms.schema.concept.ConceptInterface;
import org.pentaho.pms.schema.concept.ConceptPropertyInterface;
import org.pentaho.pms.schema.concept.DefaultPropertyID;
import org.pentaho.pms.schema.concept.types.aggregation.AggregationSettings;
import org.pentaho.pms.schema.concept.types.aggregation.ConceptPropertyAggregation;
import org.pentaho.pms.schema.concept.types.aggregation.ConceptPropertyAggregationList;
import org.pentaho.pms.schema.concept.types.bool.ConceptPropertyBoolean;
import org.pentaho.pms.schema.concept.types.datatype.ConceptPropertyDataType;
import org.pentaho.pms.schema.concept.types.datatype.DataTypeSettings;
import org.pentaho.pms.schema.concept.types.fieldtype.ConceptPropertyFieldType;
import org.pentaho.pms.schema.concept.types.fieldtype.FieldTypeSettings;
import org.pentaho.pms.schema.concept.types.number.ConceptPropertyNumber;
import org.pentaho.pms.schema.concept.types.rowlevelsecurity.ConceptPropertyRowLevelSecurity;
import org.pentaho.pms.schema.concept.types.security.ConceptPropertySecurity;
import org.pentaho.pms.schema.concept.types.string.ConceptPropertyString;
import org.pentaho.pms.schema.concept.types.tabletype.ConceptPropertyTableType;
import org.pentaho.pms.schema.concept.types.tabletype.TableTypeSettings;
import org.pentaho.pms.schema.security.RowLevelSecurity;
import org.pentaho.pms.schema.security.Security;
import org.pentaho.pms.util.Const;
import org.pentaho.pms.util.ObjectAlreadyExistsException;
import org.pentaho.pms.util.UniqueList;

public class ConceptUtilityBase
extends ChangedFlag
implements AllowsIDChangeListenersInterface {
    private static final String DEFAULT_LOCALE = "en_US";
    private String id;
    private ConceptInterface concept = new Concept();
    protected transient List<IDChangedListener> idChangedListeners = new ArrayList<IDChangedListener>();

    public ConceptUtilityBase() {
        this(null);
    }

    public ConceptUtilityBase(String id) {
        this.id = id;
        this.addDefaultProperties();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConceptUtilityBase)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        ConceptUtilityBase rhs = (ConceptUtilityBase)obj;
        String lhsId = null != this.id ? this.id.toUpperCase() : null;
        String rhsId = null != rhs.id ? rhs.id.toUpperCase() : null;
        return new EqualsBuilder().append((Object)lhsId, (Object)rhsId).isEquals();
    }

    public int hashCode() {
        String idToHash = null != this.id ? this.id.toUpperCase() : null;
        return new HashCodeBuilder(11, 113).append((Object)idToHash).toHashCode();
    }

    public String toString() {
        return this.id;
    }

    public boolean hasChanged() {
        if (this.concept.hasChanged()) {
            return true;
        }
        return super.hasChanged();
    }

    public void clearChanged() {
        this.setChanged(false);
        this.concept.clearChanged();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) throws ObjectAlreadyExistsException {
        for (int i = 0; i < this.idChangedListeners.size(); ++i) {
            IDChangedListener listener = this.idChangedListeners.get(i);
            try {
                listener.IDChanged(new IDChangedEvent(this.id, id, this));
                continue;
            }
            catch (ObjectAlreadyExistsException e) {
                throw new ObjectAlreadyExistsException(Messages.getString("ConceptUtilityBase.ERROR_0001_OBJECT_ID_EXISTS", id), e);
            }
        }
        this.id = id;
        this.setChanged();
    }

    public ConceptInterface getConcept() {
        return this.concept;
    }

    public void setConcept(ConceptInterface concept) {
        this.concept = concept;
        this.setChanged();
    }

    public String getDisplayName(String locale) {
        return this.getName(locale);
    }

    public void setName(String locale, String name) {
        this.concept.setName(locale, name);
    }

    public String getName(String locale) {
        String name = this.internalGetName(locale);
        if (Const.isEmpty(name) && !DEFAULT_LOCALE.startsWith(locale)) {
            name = this.internalGetName(DEFAULT_LOCALE);
        }
        return Const.isEmpty(name) ? this.id : name;
    }

    private String internalGetName(String locale) {
        String name = this.concept.getName(locale);
        if (Const.isEmpty(name) && locale != null && locale.indexOf(95) > 0) {
            name = this.internalGetName(locale.substring(0, locale.lastIndexOf(95)));
        }
        return name;
    }

    public void setDescription(String locale, String description) {
        this.concept.setDescription(locale, description);
    }

    public String getDescription(String locale) {
        String description = this.concept.getDescription(locale);
        if (Const.isEmpty(description) && DEFAULT_LOCALE.indexOf(locale) != 0) {
            description = this.internalGetDescription(DEFAULT_LOCALE);
        }
        return Const.isEmpty(description) ? this.id : description;
    }

    private String internalGetDescription(String locale) {
        String description = this.concept.getDescription(locale);
        if (Const.isEmpty(description) && locale != null && locale.indexOf(95) > 0) {
            description = this.internalGetDescription(locale.substring(0, locale.lastIndexOf(95)));
        }
        return description;
    }

    public String getTargetSchema() {
        ConceptPropertyInterface property = this.concept.getProperty(DefaultPropertyID.TARGET_SCHEMA.getId());
        if (property != null) {
            return property.toString();
        }
        return null;
    }

    public void setTargetSchema(String targetSchema) {
        ConceptPropertyInterface property = this.concept.getChildProperty(DefaultPropertyID.TARGET_SCHEMA.getId());
        if (null != property) {
            property.setValue(targetSchema);
        } else {
            this.concept.addProperty(new ConceptPropertyString(DefaultPropertyID.TARGET_SCHEMA.getId(), targetSchema));
        }
    }

    public String getTargetTable() {
        ConceptPropertyInterface property = this.concept.getProperty(DefaultPropertyID.TARGET_TABLE.getId());
        if (property != null) {
            return property.toString();
        }
        return null;
    }

    public void setTargetTable(String targetTable) {
        ConceptPropertyInterface property = this.concept.getChildProperty(DefaultPropertyID.TARGET_TABLE.getId());
        if (null != property) {
            property.setValue(targetTable);
        } else {
            this.concept.addProperty(new ConceptPropertyString(DefaultPropertyID.TARGET_TABLE.getId(), targetTable));
        }
    }

    public String getMask() {
        ConceptPropertyInterface property = this.concept.getProperty(DefaultPropertyID.MASK.getId());
        if (property != null) {
            return property.toString();
        }
        return null;
    }

    public void setMask(String mask) {
        ConceptPropertyInterface property = this.concept.getChildProperty(DefaultPropertyID.MASK.getId());
        if (null != property) {
            property.setValue(mask);
        } else {
            this.concept.addProperty(new ConceptPropertyString(DefaultPropertyID.MASK.getId(), mask));
        }
    }

    public TableTypeSettings getTableType() {
        ConceptPropertyInterface property = this.concept.getProperty(DefaultPropertyID.TABLE_TYPE.getId());
        if (property == null) {
            return TableTypeSettings.OTHER;
        }
        return (TableTypeSettings)property.getValue();
    }

    public void setTableType(TableTypeSettings type) {
        ConceptPropertyInterface property = this.concept.getChildProperty(DefaultPropertyID.TABLE_TYPE.getId());
        if (null != property) {
            property.setValue(type);
        } else {
            this.concept.addProperty(new ConceptPropertyTableType(DefaultPropertyID.TABLE_TYPE.getId(), type));
        }
    }

    public boolean isDimensionTable() {
        return this.getTableType().isDimension();
    }

    public boolean isFactTable() {
        return this.getTableType().isFact();
    }

    public int getRelativeSize() {
        BigDecimal value;
        ConceptPropertyInterface property = this.concept.getProperty(DefaultPropertyID.RELATIVE_SIZE.getId());
        if (property != null && (value = (BigDecimal)property.getValue()) != null) {
            return value.intValue();
        }
        return -1;
    }

    public void setRelativeSize(int size) {
        ConceptPropertyInterface property = this.concept.getChildProperty(DefaultPropertyID.RELATIVE_SIZE.getId());
        if (null != property) {
            property.setValue(new BigDecimal(size));
        } else {
            this.concept.addProperty(new ConceptPropertyNumber(DefaultPropertyID.RELATIVE_SIZE.getId(), size));
        }
    }

    public String getFormula() {
        ConceptPropertyInterface property = this.concept.getProperty(DefaultPropertyID.FORMULA.getId());
        if (property == null) {
            return null;
        }
        return (String)property.getValue();
    }

    public void setFormula(String formula) {
        ConceptPropertyInterface property = this.concept.getChildProperty(DefaultPropertyID.FORMULA.getId());
        if (null != property) {
            property.setValue(formula);
        } else {
            this.concept.addProperty(new ConceptPropertyString(DefaultPropertyID.FORMULA.getId(), formula));
        }
    }

    public FieldTypeSettings getFieldType() {
        ConceptPropertyInterface property = this.concept.getProperty(DefaultPropertyID.FIELD_TYPE.getId());
        if (property == null || property.getValue() == null) {
            return FieldTypeSettings.OTHER;
        }
        return (FieldTypeSettings)property.getValue();
    }

    public void setFieldType(FieldTypeSettings fieldType) {
        ConceptPropertyInterface property = this.concept.getChildProperty(DefaultPropertyID.FIELD_TYPE.getId());
        if (null != property) {
            property.setValue(fieldType);
        } else {
            this.concept.addProperty(new ConceptPropertyFieldType(DefaultPropertyID.FIELD_TYPE.getId(), fieldType));
        }
    }

    public String getFieldTypeDesc() {
        return this.getFieldType().getDescription();
    }

    public void setAggregationType(AggregationSettings aggregationType) {
        ConceptPropertyInterface property = this.concept.getChildProperty(DefaultPropertyID.AGGREGATION.getId());
        if (null != property) {
            property.setValue(aggregationType);
        } else {
            this.concept.addProperty(new ConceptPropertyAggregation(DefaultPropertyID.AGGREGATION.getId(), aggregationType));
        }
    }

    public AggregationSettings getAggregationType() {
        ConceptPropertyInterface property = this.concept.getProperty(DefaultPropertyID.AGGREGATION.getId());
        if (property == null || property.getValue() == null) {
            return AggregationSettings.NONE;
        }
        return (AggregationSettings)property.getValue();
    }

    public String getAggregationTypeDesc() {
        return this.getAggregationType().getDescription();
    }

    public void setAggregationList(List<AggregationSettings> aggregationList) {
        ConceptPropertyInterface property = this.concept.getChildProperty(DefaultPropertyID.AGGREGATION_LIST.getId());
        if (null != property) {
            property.setValue(aggregationList);
        } else {
            this.concept.addProperty(new ConceptPropertyAggregationList(DefaultPropertyID.AGGREGATION_LIST.getId(), aggregationList));
        }
    }

    public List<AggregationSettings> getAggregationList() {
        ConceptPropertyInterface property = this.concept.getProperty(DefaultPropertyID.AGGREGATION_LIST.getId());
        if (property == null || property.getValue() == null) {
            return null;
        }
        return (List)property.getValue();
    }

    public void setHidden(boolean hidden) {
        ConceptPropertyInterface property = this.concept.getChildProperty(DefaultPropertyID.HIDDEN.getId());
        if (null != property) {
            property.setValue(new Boolean(hidden));
        } else {
            this.concept.addProperty(new ConceptPropertyBoolean(DefaultPropertyID.HIDDEN.getId(), hidden));
        }
    }

    public void flipHidden() {
        this.setHidden(!this.isHidden());
    }

    public boolean isHidden() {
        ConceptPropertyInterface property = this.concept.getProperty(DefaultPropertyID.HIDDEN.getId());
        if (property == null || property.getValue() == null) {
            return false;
        }
        return (Boolean)property.getValue();
    }

    public boolean isExact() {
        ConceptPropertyInterface property = this.concept.getProperty(DefaultPropertyID.EXACT.getId());
        if (property == null || property.getValue() == null) {
            return false;
        }
        return (Boolean)property.getValue();
    }

    public void setExact(boolean exact) {
        ConceptPropertyInterface property = this.concept.getChildProperty(DefaultPropertyID.EXACT.getId());
        if (null != property) {
            property.setValue(new Boolean(exact));
        } else {
            this.concept.addProperty(new ConceptPropertyBoolean(DefaultPropertyID.EXACT.getId(), exact));
        }
    }

    public void flipExact() {
        this.setExact(!this.isExact());
    }

    public boolean isFactField() {
        return this.getFieldType().isFact();
    }

    public boolean isDimensionField() {
        return this.getFieldType().isDimension();
    }

    public boolean isAttributeField() {
        return this.getFieldType().isDimension();
    }

    public boolean hasAggregate() {
        return !this.getAggregationType().equals(AggregationSettings.NONE);
    }

    public DataTypeSettings getDataType() {
        ConceptPropertyInterface property = this.concept.getProperty(DefaultPropertyID.DATA_TYPE.getId());
        if (property == null || property.getValue() == null) {
            return DataTypeSettings.UNKNOWN;
        }
        return (DataTypeSettings)property.getValue();
    }

    public void setDataType(DataTypeSettings dataType) {
        ConceptPropertyInterface property = this.concept.getChildProperty(DefaultPropertyID.DATA_TYPE.getId());
        if (null != property) {
            property.setValue(dataType);
        } else {
            this.concept.addProperty(new ConceptPropertyDataType(DefaultPropertyID.DATA_TYPE.getId(), dataType));
        }
    }

    public Security getSecurity() {
        ConceptPropertyInterface property = this.concept.getProperty(DefaultPropertyID.SECURITY.getId());
        if (property == null || property.getValue() == null) {
            return new Security();
        }
        return (Security)property.getValue();
    }

    public void setSecurity(Security security) {
        ConceptPropertyInterface property = this.concept.getChildProperty(DefaultPropertyID.SECURITY.getId());
        if (null != property) {
            property.setValue(security);
        } else {
            this.concept.addProperty(new ConceptPropertySecurity(DefaultPropertyID.SECURITY.getId(), security));
        }
    }

    public RowLevelSecurity getRowLevelSecurity() {
        ConceptPropertyInterface property = this.concept.getProperty(DefaultPropertyID.ROW_LEVEL_SECURITY.getId());
        if (property == null || property.getValue() == null) {
            return new RowLevelSecurity();
        }
        return (RowLevelSecurity)property.getValue();
    }

    public void setRowLevelSecurity(RowLevelSecurity rowLevelSecurity) {
        ConceptPropertyInterface property = this.concept.getChildProperty(DefaultPropertyID.ROW_LEVEL_SECURITY.getId());
        if (null != property) {
            property.setValue(rowLevelSecurity);
        } else {
            this.concept.addProperty(new ConceptPropertyRowLevelSecurity(DefaultPropertyID.ROW_LEVEL_SECURITY.getId(), rowLevelSecurity));
        }
    }

    @Override
    public void addIDChangedListener(IDChangedListener listener) {
        this.idChangedListeners.add(listener);
    }

    public static IDChangedListener createIDChangedListener(final UniqueList uniqueList) {
        return new IDChangedListener(){

            @Override
            public void IDChanged(IDChangedEvent event) throws ObjectAlreadyExistsException {
                if (event.newID == null && event.oldID == null) {
                    return;
                }
                if (event.newID == null) {
                    return;
                }
                if (event.newID.equals(event.oldID)) {
                    return;
                }
                if (event.object instanceof ConceptUtilityBase) {
                    for (int i = 0; i < uniqueList.size(); ++i) {
                        ConceptUtilityBase base = (ConceptUtilityBase)uniqueList.get(i);
                        if (!base.getId().equals(event.newID)) continue;
                        throw new ObjectAlreadyExistsException(Messages.getString("ConceptUtilityBase.ERROR_0001_OBJECT_ID_EXISTS", event.newID));
                    }
                }
            }
        };
    }

    protected void addDefaultProperties() {
        List list = new RequiredProperties().getDefaultProperties(this.getClass());
        if (null != list) {
            for (int i = 0; i < list.size(); ++i) {
                DefaultProperty defaultProperty = (DefaultProperty)list.get(i);
                ConceptPropertyInterface prop = DefaultPropertyID.getDefaultEmptyProperty(defaultProperty.getConceptPropertyType(), defaultProperty.getName());
                prop.setRequired(true);
                this.concept.addProperty(prop);
            }
        }
    }
}

