/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import java.io.CharConversionException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLTime
implements SQLData {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private SQLConversionSettings settings_;
    private int timeFormat_;
    private int hour_;
    private int minute_;
    private int second_;
    private int truncated_;

    SQLTime(SQLConversionSettings sQLConversionSettings, int n) {
        this.settings_ = sQLConversionSettings;
        this.hour_ = 0;
        this.minute_ = 0;
        this.second_ = 0;
        this.truncated_ = 0;
        this.timeFormat_ = n;
    }

    public Object clone() {
        return new SQLTime(this.settings_, this.timeFormat_);
    }

    public static Time stringToTime(String string, SQLConversionSettings sQLConversionSettings, Calendar calendar) throws SQLException {
        try {
            if (string.trim().length() == 0) {
                return new Time(0L);
            }
            if (calendar == null) {
                calendar = Calendar.getInstance();
            }
            switch (sQLConversionSettings.getTimeFormat()) {
                case 1: {
                    int n = Integer.parseInt(string.substring(0, 2));
                    char c = string.charAt(6);
                    if (n == 12) {
                        if (c == 'A') {
                            n = 0;
                        }
                    } else if (c == 'P') {
                        n += 12;
                    }
                    calendar.set(11, n);
                    calendar.set(12, Integer.parseInt(string.substring(3, 5)));
                    calendar.set(13, 0);
                    break;
                }
                case 0: 
                case 2: 
                case 3: 
                case 4: {
                    calendar.set(11, Integer.parseInt(string.substring(0, 2)));
                    calendar.set(12, Integer.parseInt(string.substring(3, 5)));
                    calendar.set(13, Integer.parseInt(string.substring(6, 8)));
                }
            }
            calendar.set(1, 0);
            calendar.set(2, 0);
            calendar.set(5, 0);
            calendar.set(14, 0);
        }
        catch (NumberFormatException numberFormatException) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(null, "Error parsing time " + string, numberFormatException);
            }
            JDError.throwSQLException("07006", string);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(null, "Error parsing time " + string, stringIndexOutOfBoundsException);
            }
            JDError.throwSQLException("07006", string);
        }
        return new Time(calendar.getTime().getTime());
    }

    public static String timeToString(Time time, SQLConversionSettings sQLConversionSettings, Calendar calendar) {
        return SQLTime.timeToString(time, sQLConversionSettings, calendar, -1);
    }

    private static String timeToString(Time time, SQLConversionSettings sQLConversionSettings, Calendar calendar, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sQLConversionSettings.getTimeSeparator();
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.setTime(time);
        int n2 = calendar.get(11);
        int n3 = calendar.get(12);
        int n4 = 0;
        switch (sQLConversionSettings.getTimeFormat()) {
            case 1: {
                char c;
                if (n2 > 12) {
                    n2 -= 12;
                    c = 'P';
                } else if (n2 == 12) {
                    c = 'P';
                } else if (n2 > 0 && n2 < 12) {
                    c = 'A';
                } else if (n3 == 0 && n4 == 0) {
                    if (n == 24) {
                        n2 = 12;
                    }
                    c = 'A';
                } else {
                    n2 = 12;
                    c = 'A';
                }
                stringBuffer.append(JDUtilities.padZeros(n2, 2));
                stringBuffer.append(':');
                stringBuffer.append(JDUtilities.padZeros(n3, 2));
                stringBuffer.append(' ');
                stringBuffer.append(c);
                stringBuffer.append('M');
                break;
            }
            case 2: 
            case 3: {
                n4 = calendar.get(13);
                stringBuffer.append(JDUtilities.padZeros(n2, 2));
                stringBuffer.append('.');
                stringBuffer.append(JDUtilities.padZeros(n3, 2));
                stringBuffer.append('.');
                stringBuffer.append(JDUtilities.padZeros(n4, 2));
                break;
            }
            case 4: {
                n4 = calendar.get(13);
                stringBuffer.append(JDUtilities.padZeros(n2, 2));
                stringBuffer.append(':');
                stringBuffer.append(JDUtilities.padZeros(n3, 2));
                stringBuffer.append(':');
                stringBuffer.append(JDUtilities.padZeros(n4, 2));
                break;
            }
            case 0: {
                n4 = calendar.get(13);
                stringBuffer.append(JDUtilities.padZeros(n2, 2));
                stringBuffer.append(string);
                stringBuffer.append(JDUtilities.padZeros(n3, 2));
                stringBuffer.append(string);
                stringBuffer.append(JDUtilities.padZeros(n4, 2));
            }
        }
        if (n == 24 && n2 == 0) {
            stringBuffer.setCharAt(0, '2');
            stringBuffer.setCharAt(1, '4');
        }
        return stringBuffer.toString();
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        int n2 = this.settings_.getTimeFormat();
        switch (this.timeFormat_ != -1 && this.timeFormat_ != n2 ? this.timeFormat_ : n2) {
            case 1: {
                this.hour_ = (byArray[n] & 0xF) * 10 + (byArray[n + 1] & 0xF);
                this.minute_ = (byArray[n + 3] & 0xF) * 10 + (byArray[n + 4] & 0xF);
                this.second_ = 0;
                if ((byArray[n + 6] != -41 || this.hour_ >= 12) && (byArray[n + 6] != -63 || this.hour_ != 12)) break;
                this.hour_ += 12;
                break;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: {
                this.hour_ = (byArray[n] & 0xF) * 10 + (byArray[n + 1] & 0xF);
                this.minute_ = (byArray[n + 3] & 0xF) * 10 + (byArray[n + 4] & 0xF);
                this.second_ = (byArray[n + 6] & 0xF) * 10 + (byArray[n + 7] & 0xF);
                break;
            }
        }
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(8);
        stringBuffer.append(JDUtilities.padZeros(this.hour_, 2));
        stringBuffer.append('.');
        stringBuffer.append(JDUtilities.padZeros(this.minute_, 2));
        stringBuffer.append('.');
        stringBuffer.append(JDUtilities.padZeros(this.second_, 2));
        try {
            convTable.stringToByteArray(stringBuffer.toString(), byArray, n);
        }
        catch (CharConversionException charConversionException) {
            JDError.throwSQLException("HY000", charConversionException);
        }
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        if (object instanceof String) {
            SQLTime.stringToTime((String)object, this.settings_, calendar);
            this.hour_ = calendar.get(11);
            this.minute_ = calendar.get(12);
            this.second_ = calendar.get(13);
        } else if (object instanceof Time) {
            calendar.setTime((Time)object);
            this.hour_ = calendar.get(11);
            this.minute_ = calendar.get(12);
            this.second_ = calendar.get(13);
        } else if (object instanceof Timestamp) {
            calendar.setTime((Timestamp)object);
            this.hour_ = calendar.get(11);
            this.minute_ = calendar.get(12);
            this.second_ = calendar.get(13);
        } else {
            JDError.throwSQLException(this, "07006");
        }
    }

    public int getSQLType() {
        return 27;
    }

    public String getCreateParameters() {
        return null;
    }

    public int getDisplaySize() {
        return 8;
    }

    public String getJavaClassName() {
        return "java.sql.Time";
    }

    public String getLiteralPrefix() {
        return "'";
    }

    public String getLiteralSuffix() {
        return "'";
    }

    public String getLocalName() {
        return "TIME";
    }

    public int getMaximumPrecision() {
        return 8;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 388;
    }

    public int getPrecision() {
        return 8;
    }

    public int getRadix() {
        return 10;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 92;
    }

    public String getTypeName() {
        return "TIME";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return false;
    }

    public int getActualSize() {
        return 8;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public InputStream getAsciiStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Blob getBlob() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1;
    }

    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Reader getCharacterStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Clob getClob() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1L;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1970, 0, 1, this.hour_, this.minute_, this.second_);
        calendar.set(14, 0);
        return new Time(calendar.getTime().getTime());
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1;
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1970, 0, 1, this.hour_, this.minute_, this.second_);
        calendar.set(14, 0);
        Time time = new Time(calendar.getTime().getTime());
        return SQLTime.timeToString(time, this.settings_, calendar, this.hour_);
    }

    public Time getTime(Calendar calendar) throws SQLException {
        this.truncated_ = 0;
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.set(1970, 0, 1, this.hour_, this.minute_, this.second_);
        calendar.set(14, 0);
        return new Time(calendar.getTime().getTime());
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        this.truncated_ = 0;
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.set(1970, 0, 1, this.hour_, this.minute_, this.second_);
        calendar.set(14, 0);
        Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
        timestamp.setNanos(0);
        return timestamp;
    }

    public InputStream getUnicodeStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }
}

