/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.media.mediarss;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.util.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExtensionDescription.Default(nsAlias="media", nsUri="http://search.yahoo.com/mrss/", localName="keywords")
public class MediaKeywords
extends AbstractExtension {
    private final List<String> keywords = new ArrayList<String>();

    public static ExtensionDescription getDefaultDescription() {
        return ExtensionDescription.getDefaultDescription(MediaKeywords.class);
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void addKeyword(String keyword) {
        this.keywords.add(keyword);
    }

    public void addKeywords(Collection<String> keywords) {
        this.keywords.addAll(keywords);
    }

    public void clearKeywords() {
        this.keywords.clear();
    }

    @Override
    protected void putAttributes(AttributeGenerator generator) {
        StringBuffer content = new StringBuffer();
        boolean isFirst = true;
        for (String keyword : this.keywords) {
            if (isFirst) {
                isFirst = false;
            } else {
                content.append(", ");
            }
            content.append(keyword);
        }
        generator.setContent(content.toString());
    }

    @Override
    protected void consumeAttributes(AttributeHelper attrsHelper) throws ParseException {
        String value = attrsHelper.consumeContent(false);
        this.keywords.clear();
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                this.keywords.add(token);
            }
        }
    }
}

