/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.metadata.mqleditor.editor.service.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.commons.metadata.mqleditor.Operator;

public class OperatorFormatter {
    private static final String PIPE_EVAL = "[|]{0,1}";
    private static final String IN_EVAL = "([^|]+)[|]{0,1}";
    private static final String IN_EVAL_QUOTES = "\\s*\"([^\"]*)\"\\s*[|]{0,1}";
    private static final Pattern IN_EVAL_PAT = Pattern.compile("\\s*\"([^\"]*)\"\\s*[|]{0,1}|([^|]+)[|]{0,1}");

    public String formatCondition(Operator op, String objectName, String value, boolean parameterized) {
        if (parameterized) {
            value = "[param:" + value.replaceAll("[\\{\\}]", "") + "]";
        } else if (op == Operator.IN) {
            Matcher m = IN_EVAL_PAT.matcher(value);
            StringBuilder sb = new StringBuilder();
            while (m.find()) {
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append("\"");
                sb.append(m.group(1) != null ? m.group(1) : m.group(2));
                sb.append("\"");
            }
            if (sb.length() > 0) {
                value = sb.toString();
            }
        } else if (op.getOperatorType() == 0 || op.getOperatorType() == 2) {
            value = "\"" + value + "\"";
        }
        String retVal = "";
        switch (op) {
            case EXACTLY_MATCHES: 
            case EQUAL: {
                retVal = retVal + "EQUALS(" + objectName + ";" + value + ")";
                break;
            }
            case CONTAINS: {
                retVal = retVal + "CONTAINS(" + objectName + ";" + value + ")";
                break;
            }
            case DOES_NOT_CONTAIN: {
                retVal = retVal + "NOT(CONTAINS(" + objectName + ";" + value + "))";
                break;
            }
            case BEGINS_WITH: {
                retVal = retVal + "BEGINSWITH(" + objectName + ";" + value + ")";
                break;
            }
            case ENDS_WITH: {
                retVal = retVal + "ENDSWITH(" + objectName + ";" + value + ")";
                break;
            }
            case IS_NULL: {
                retVal = retVal + "ISNA(" + objectName + ")";
                break;
            }
            case IS_NOT_NULL: {
                retVal = retVal + "NOT(ISNA(" + objectName + "))";
                break;
            }
            case IN: {
                retVal = retVal + "IN(" + objectName + ";" + value + ")";
                break;
            }
            default: {
                retVal = objectName + " " + op.toString();
                if (!op.getRequiresValue()) break;
                retVal = retVal + value;
            }
        }
        return retVal;
    }
}

