/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.DefaultAuthorizationProvider;
import org.apache.hadoop.security.AccessControlException;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class AuthorizationProvider {
    private static final ThreadLocal<Boolean> CLIENT_OP_TL = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private static AuthorizationProvider provider = new DefaultAuthorizationProvider();
    public static final int CURRENT_STATE_ID = 0x7FFFFFFE;

    static void beginClientOp() {
        CLIENT_OP_TL.set(Boolean.TRUE);
    }

    static void endClientOp() {
        CLIENT_OP_TL.set(Boolean.FALSE);
    }

    public static AuthorizationProvider get() {
        return provider;
    }

    static void set(AuthorizationProvider authzProvider) {
        provider = authzProvider != null ? authzProvider : new DefaultAuthorizationProvider();
    }

    protected final boolean isClientOp() {
        return CLIENT_OP_TL.get() == Boolean.TRUE;
    }

    public void start() {
    }

    public void stop() {
    }

    public void setSnaphottableDirs(Map<INodeAuthorizationInfo, Integer> snapshotableDirs) {
    }

    public void addSnapshottable(INodeAuthorizationInfo dir) {
    }

    public void removeSnapshottable(INodeAuthorizationInfo dir) {
    }

    public void createSnapshot(INodeAuthorizationInfo dir, int snapshotId) throws IOException {
    }

    public void removeSnapshot(INodeAuthorizationInfo dir, int snapshotId) throws IOException {
    }

    public abstract void setUser(INodeAuthorizationInfo var1, String var2);

    public abstract String getUser(INodeAuthorizationInfo var1, int var2);

    public abstract void setGroup(INodeAuthorizationInfo var1, String var2);

    public abstract String getGroup(INodeAuthorizationInfo var1, int var2);

    public abstract void setPermission(INodeAuthorizationInfo var1, FsPermission var2);

    public abstract FsPermission getFsPermission(INodeAuthorizationInfo var1, int var2);

    public abstract AclFeature getAclFeature(INodeAuthorizationInfo var1, int var2);

    public abstract void removeAclFeature(INodeAuthorizationInfo var1);

    public abstract void addAclFeature(INodeAuthorizationInfo var1, AclFeature var2);

    public abstract void checkPermission(String var1, Set<String> var2, INodeAuthorizationInfo[] var3, int var4, boolean var5, FsAction var6, FsAction var7, FsAction var8, FsAction var9, boolean var10) throws AccessControlException, UnresolvedLinkException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static interface INodeAuthorizationInfo {
        public long getId();

        public String getLocalName();

        public INodeAuthorizationInfo getParent();

        public String getFullPathName();

        public boolean isDirectory();

        public String getUserName(int var1);

        public String getGroupName(int var1);

        public FsPermission getFsPermission(int var1);

        public AclFeature getAclFeature(int var1);
    }
}

