/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.hadoopjobexecutor;

import java.io.FileDescriptor;
import java.net.InetAddress;
import java.security.Permission;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.pentaho.di.i18n.BaseMessages;

public class NoExitSecurityManager
extends SecurityManager {
    private SecurityManager decorated;
    private Set<Thread> blockedThreads;

    public NoExitSecurityManager(SecurityManager decorated) {
        this.decorated = decorated;
        this.blockedThreads = Collections.synchronizedSet(new HashSet());
    }

    public void addBlockedThread(Thread t) {
        this.blockedThreads.add(t);
    }

    @Override
    public void checkExit(int status) {
        if (this.decorated != null) {
            this.decorated.checkExit(status);
        }
        if (this.blockedThreads.contains(Thread.currentThread())) {
            throw new NoExitSecurityException(status, BaseMessages.getString(this.getClass(), (String)"NoSystemExit", (String[])new String[0]));
        }
    }

    @Override
    public void checkExec(String cmd) {
        if (this.decorated != null) {
            this.decorated.checkExec(cmd);
        }
    }

    @Override
    public void checkLink(String lib) {
        if (this.decorated != null) {
            this.decorated.checkLink(lib);
        }
    }

    @Override
    public void checkRead(FileDescriptor fd) {
        if (this.decorated != null) {
            this.decorated.checkRead(fd);
        }
    }

    @Override
    public void checkRead(String file) {
        if (this.decorated != null) {
            this.decorated.checkRead(file);
        }
    }

    @Override
    public void checkRead(String file, Object context) {
        if (this.decorated != null) {
            this.decorated.checkRead(file, context);
        }
    }

    @Override
    public void checkWrite(FileDescriptor fd) {
        if (this.decorated != null) {
            this.decorated.checkWrite(fd);
        }
    }

    @Override
    public void checkWrite(String file) {
        if (this.decorated != null) {
            this.decorated.checkWrite(file);
        }
    }

    @Override
    public void checkDelete(String file) {
        if (this.decorated != null) {
            this.decorated.checkDelete(file);
        }
    }

    @Override
    public void checkConnect(String host, int port) {
        if (this.decorated != null) {
            this.decorated.checkConnect(host, port);
        }
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
        if (this.decorated != null) {
            this.decorated.checkConnect(host, port, context);
        }
    }

    @Override
    public void checkListen(int port) {
        if (this.decorated != null) {
            this.decorated.checkListen(port);
        }
    }

    @Override
    public void checkAccept(String host, int port) {
        if (this.decorated != null) {
            this.decorated.checkAccept(host, port);
        }
    }

    @Override
    public void checkMulticast(InetAddress maddr) {
        if (this.decorated != null) {
            this.decorated.checkMulticast(maddr);
        }
    }

    @Override
    @Deprecated
    public void checkMulticast(InetAddress maddr, byte ttl) {
        if (this.decorated != null) {
            this.decorated.checkMulticast(maddr, ttl);
        }
    }

    @Override
    public void checkPropertiesAccess() {
        if (this.decorated != null) {
            this.decorated.checkPropertiesAccess();
        }
    }

    @Override
    public void checkPropertyAccess(String key) {
        if (this.decorated != null) {
            this.decorated.checkPropertyAccess(key);
        }
    }

    public boolean checkTopLevelWindow(Object window) {
        if (this.decorated != null) {
            return this.decorated.checkTopLevelWindow(window);
        }
        return true;
    }

    @Override
    public void checkPrintJobAccess() {
        if (this.decorated != null) {
            this.decorated.checkPrintJobAccess();
        }
    }

    public void checkSystemClipboardAccess() {
        if (this.decorated != null) {
            this.decorated.checkSystemClipboardAccess();
        }
    }

    public void checkAwtEventQueueAccess() {
        if (this.decorated != null) {
            this.decorated.checkAwtEventQueueAccess();
        }
    }

    @Override
    public void checkPackageAccess(String pkg) {
        if (this.decorated != null) {
            this.decorated.checkPackageAccess(pkg);
        }
    }

    @Override
    public void checkPackageDefinition(String pkg) {
        if (this.decorated != null) {
            this.decorated.checkPackageDefinition(pkg);
        }
    }

    @Override
    public void checkSetFactory() {
        if (this.decorated != null) {
            this.decorated.checkSetFactory();
        }
    }

    public void checkMemberAccess(Class<?> clazz, int which) {
        if (this.decorated != null) {
            this.decorated.checkMemberAccess(clazz, which);
        }
    }

    @Override
    public void checkSecurityAccess(String target) {
        if (this.decorated != null) {
            this.decorated.checkSecurityAccess(target);
        }
    }

    @Override
    public void checkPermission(Permission perm) {
        if (this.decorated != null) {
            this.decorated.checkPermission(perm);
        }
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        if (this.decorated != null) {
            this.decorated.checkPermission(perm, context);
        }
    }

    @Override
    public void checkCreateClassLoader() {
        if (this.decorated != null) {
            this.decorated.checkCreateClassLoader();
        }
    }

    @Override
    public void checkAccess(Thread t) {
        if (this.decorated != null) {
            this.decorated.checkAccess(t);
        }
    }

    @Override
    public void checkAccess(ThreadGroup g) {
        if (this.decorated != null) {
            this.decorated.checkAccess(g);
        }
    }

    public static class NoExitSecurityException
    extends SecurityException {
        private int status;

        public NoExitSecurityException(int status, String message) {
            super(message);
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

