/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.hadoopjobexecutor;

import java.util.Deque;
import java.util.LinkedList;

public class SecurityManagerStack {
    private Deque<StackElement> stack = new LinkedList<StackElement>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSecurityManager(SecurityManager sm) {
        if (sm == null) {
            throw new IllegalArgumentException("SecurityManager is required");
        }
        Deque<StackElement> deque = this.stack;
        synchronized (deque) {
            this.stack.push(new StackElement(sm, this.getCurrentSecurityManager()));
            System.setSecurityManager(sm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecurityManager(SecurityManager sm) {
        if (sm == null) {
            throw new IllegalArgumentException("SecurityManager is required");
        }
        Deque<StackElement> deque = this.stack;
        synchronized (deque) {
            if (this.stack.peek() == null) {
                throw new IllegalStateException("empty stack");
            }
            if (sm.equals(this.stack.peek().sm)) {
                SecurityManager smToRestore = this.stack.pop().original;
                while (this.stack.peek() != null && this.stack.peek().released) {
                    smToRestore = this.stack.pop().original;
                }
                this.restore(smToRestore);
            } else {
                for (StackElement e : this.stack) {
                    if (!e.sm.equals(sm)) continue;
                    e.released = true;
                }
            }
        }
    }

    private SecurityManager getCurrentSecurityManager() {
        return System.getSecurityManager();
    }

    private void restore(SecurityManager sm) {
        System.setSecurityManager(sm);
    }

    private class StackElement {
        SecurityManager sm;
        SecurityManager original;
        boolean released;

        StackElement(SecurityManager sm, SecurityManager original) {
            this.sm = sm;
            this.original = original;
            this.released = false;
        }
    }
}

